/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.SearchCommandArgs;

public class Limit
implements AggregateOperation {
    private final long offset;
    private final long num;

    public Limit(long offset, long num) {
        this.offset = offset;
        this.num = num;
    }

    @Override
    public AggregateOperation.Type getType() {
        return AggregateOperation.Type.LIMIT;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getNum() {
        return this.num;
    }

    @Override
    public void build(SearchCommandArgs args) {
        args.add(SearchCommandKeyword.LIMIT);
        args.add(this.offset);
        args.add(this.num);
    }

    public String toString() {
        return "LIMIT [offset=" + this.offset + ", num=" + this.num + "]";
    }

    public static NumBuilder offset(long offset) {
        return new Builder().offset(offset);
    }

    public static final class Builder
    implements OffsetBuilder,
    NumBuilder {
        private long offset;

        private Builder() {
        }

        @Override
        public NumBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public Limit num(long num) {
            return new Limit(this.offset, num);
        }
    }

    public static interface NumBuilder {
        public Limit num(long var1);
    }

    public static interface OffsetBuilder {
        public NumBuilder offset(long var1);
    }
}

