/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import com.redis.lettucemod.RedisModulesUtils;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.Arrays;

public class RedisURIBuilder {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 6379;
    public static final Duration DEFAULT_TIMEOUT_DURATION = RedisURI.DEFAULT_TIMEOUT_DURATION;
    public static final long DEFAULT_TIMEOUT = 60L;
    public static final SslVerifyMode DEFAULT_VERIFY_MODE = SslVerifyMode.FULL;
    private RedisURI uri;
    private String host = "127.0.0.1";
    private int port = 6379;
    private String socket;
    private String username;
    private char[] password;
    private Duration timeout = DEFAULT_TIMEOUT_DURATION;
    private int database;
    private String clientName;
    private boolean tls;
    private SslVerifyMode verifyMode = DEFAULT_VERIFY_MODE;

    public RedisURI build() {
        RedisURI.Builder builder = this.redisURIBuilder();
        if (!RedisModulesUtils.isEmpty(this.password)) {
            if (RedisModulesUtils.hasLength(this.username)) {
                builder.withAuthentication(this.username, this.password);
            } else {
                builder.withPassword(this.password);
            }
        }
        if (this.database > 0) {
            builder.withDatabase(this.database);
        }
        if (this.tls) {
            builder.withSsl(this.tls);
        }
        builder.withVerifyPeer(this.verifyMode);
        if (this.timeout != null) {
            builder.withTimeout(this.timeout);
        }
        RedisURI redisURI = builder.build();
        if (RedisModulesUtils.hasLength(this.clientName) && !RedisModulesUtils.hasLength(redisURI.getClientName())) {
            redisURI.setClientName(this.clientName);
        }
        return redisURI;
    }

    private RedisURI.Builder redisURIBuilder() {
        if (this.uri != null) {
            return RedisURI.builder((RedisURI)this.uri);
        }
        if (RedisModulesUtils.hasLength(this.socket)) {
            return RedisURI.Builder.socket((String)this.socket);
        }
        return RedisURI.Builder.redis((String)this.host, (int)this.port);
    }

    public RedisURIBuilder uri(RedisURI uri) {
        this.uri = uri;
        return this;
    }

    public RedisURIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public RedisURIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public RedisURIBuilder socket(String socket) {
        this.socket = socket;
        return this;
    }

    public RedisURIBuilder username(String username) {
        this.username = username;
        return this;
    }

    public RedisURIBuilder password(String password) {
        LettuceAssert.notNull((Object)password, (String)"Password must not be null");
        return this.password(password.toCharArray());
    }

    public RedisURIBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public RedisURIBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedisURIBuilder database(int database) {
        this.database = database;
        return this;
    }

    public RedisURIBuilder clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public RedisURIBuilder tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public RedisURIBuilder verifyMode(SslVerifyMode verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public String toString() {
        return "RedisURIBuilder [uri=" + this.uri + ", host=" + this.host + ", port=" + this.port + ", socket=" + this.socket + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", timeout=" + this.timeout + ", database=" + this.database + ", clientName=" + this.clientName + ", tls=" + this.tls + ", verifyMode=" + this.verifyMode + "]";
    }
}

