/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.json;

import com.redis.lettucemod.RedisModulesCommandBuilder;
import com.redis.lettucemod.json.ArrpopOptions;
import com.redis.lettucemod.json.GetOptions;
import com.redis.lettucemod.json.SetMode;
import com.redis.lettucemod.json.Slice;
import com.redis.lettucemod.protocol.JsonCommandType;
import io.lettuce.core.KeyValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.KeyValueListOutput;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Arrays;
import java.util.List;

public class JSONCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    public JSONCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(JsonCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    protected static void notNullPath(Object path) {
        JSONCommandBuilder.notNull(path, "Path");
    }

    public Command<K, V, Long> del(K key, String path) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        return this.createCommand(JsonCommandType.DEL, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, V> get(K key, GetOptions options, K ... paths) {
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        args.addKeys((Object[])paths);
        return this.createCommand(JsonCommandType.GET, (CommandOutput)new ValueOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<V>> mget(String path, K ... keys) {
        JSONCommandBuilder.notEmptyKeys(keys);
        JSONCommandBuilder.notNullPath(path);
        CommandArgs args = new CommandArgs(this.codec).addKeys((Object[])keys);
        args.add(path);
        return this.createCommand(JsonCommandType.MGET, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> mget(KeyValueStreamingChannel<K, V> channel, String path, K ... keys) {
        JSONCommandBuilder.notEmptyKeys(keys);
        JSONCommandBuilder.notNullPath(path);
        JSONCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys((Object[])keys);
        args.add(path);
        return this.createCommand(JsonCommandType.MGET, (CommandOutput)new KeyValueStreamingOutput(this.codec, channel, Arrays.asList(keys)), (CommandArgs)args);
    }

    public Command<K, V, Long> mget(KeyValueStreamingChannel<K, V> channel, String path, Iterable<K> keys) {
        JSONCommandBuilder.notNull(keys, "Keys");
        JSONCommandBuilder.notNullPath(path);
        JSONCommandBuilder.notNull(channel);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        args.add(path);
        return this.createCommand(JsonCommandType.MGET, (CommandOutput)new KeyValueStreamingOutput(this.codec, channel, keys), (CommandArgs)args);
    }

    public Command<K, V, List<KeyValue<K, V>>> mgetKeyValue(String path, K ... keys) {
        JSONCommandBuilder.notEmptyKeys(keys);
        JSONCommandBuilder.notNullPath(path);
        CommandArgs args = new CommandArgs(this.codec).addKeys((Object[])keys);
        args.add(path);
        return this.createCommand(JsonCommandType.MGET, (CommandOutput)new KeyValueListOutput(this.codec, Arrays.asList(keys)), (CommandArgs)args);
    }

    public Command<K, V, List<KeyValue<K, V>>> mgetKeyValue(String path, Iterable<K> keys) {
        JSONCommandBuilder.notNull(keys, "Keys");
        JSONCommandBuilder.notNullPath(path);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        args.add(path);
        return this.createCommand(JsonCommandType.MGET, (CommandOutput)new KeyValueListOutput(this.codec, keys), (CommandArgs)args);
    }

    public Command<K, V, String> set(K key, String path, V json, SetMode mode) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        JSONCommandBuilder.notNull(json, "JSON");
        args.addValue(json);
        if (mode != null) {
            mode.build(args);
        }
        return this.createCommand(JsonCommandType.SET, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> merge(K key, String path, V json) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        JSONCommandBuilder.notNull(json, "JSON");
        args.addValue(json);
        return this.createCommand(JsonCommandType.MERGE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> type(K key, String path) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        return this.createCommand(JsonCommandType.TYPE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, V> numIncrBy(K key, String path, double number) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        args.add(number);
        return this.createCommand(JsonCommandType.NUMINCRBY, (CommandOutput)new ValueOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, V> numMultBy(K key, String path, double number) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        args.add(number);
        return this.createCommand(JsonCommandType.NUMMULTBY, (CommandOutput)new ValueOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> strAppend(K key, String path, V json) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        args.addValue(json);
        return this.createCommand(JsonCommandType.STRAPPEND, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> strLen(K key, String path) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        return this.createCommand(JsonCommandType.STRLEN, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> arrAppend(K key, String path, V ... jsons) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        JSONCommandBuilder.notEmpty(jsons, "JSONs");
        args.addValues((Object[])jsons);
        return this.createCommand(JsonCommandType.ARRAPPEND, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> arrIndex(K key, String path, V jsonScalar, Slice slice) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        JSONCommandBuilder.notNull(jsonScalar, "JSON scalar");
        args.addValue(jsonScalar);
        if (slice != null) {
            slice.build(args);
        }
        return this.createCommand(JsonCommandType.ARRINDEX, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> arrInsert(K key, String path, long index, V ... jsons) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        args.add(index);
        JSONCommandBuilder.notEmpty(jsons, "JSONs");
        args.addValues((Object[])jsons);
        return this.createCommand(JsonCommandType.ARRINSERT, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> arrLen(K key, String path) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        return this.createCommand(JsonCommandType.ARRLEN, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, V> arrPop(K key, ArrpopOptions<K> options) {
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(JsonCommandType.ARRPOP, (CommandOutput)new ValueOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> arrTrim(K key, String path, long start, long stop) {
        CommandArgs args = this.args(key);
        JSONCommandBuilder.notNullPath(path);
        args.add(path);
        args.add(start);
        args.add(stop);
        return this.createCommand(JsonCommandType.ARRTRIM, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<K>> objKeys(K key, String path) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        return this.createCommand(JsonCommandType.OBJKEYS, (CommandOutput)new KeyListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> objLen(K key, String path) {
        CommandArgs args = this.args(key);
        if (path != null) {
            args.add(path);
        }
        return this.createCommand(JsonCommandType.OBJLEN, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }
}

