/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.bloom;

import com.redis.lettucemod.RedisModulesCommandBuilder;
import com.redis.lettucemod.bloom.BloomFilterInfo;
import com.redis.lettucemod.bloom.BloomFilterInfoType;
import com.redis.lettucemod.bloom.BloomFilterInsertOptions;
import com.redis.lettucemod.bloom.BloomFilterReserveOptions;
import com.redis.lettucemod.bloom.CmsInfo;
import com.redis.lettucemod.bloom.CuckooFilter;
import com.redis.lettucemod.bloom.CuckooFilterInsertOptions;
import com.redis.lettucemod.bloom.CuckooFilterReserveOptions;
import com.redis.lettucemod.bloom.LongScoredValue;
import com.redis.lettucemod.bloom.TDigestInfo;
import com.redis.lettucemod.bloom.TDigestMergeOptions;
import com.redis.lettucemod.bloom.TopKInfo;
import com.redis.lettucemod.output.BfInfoOutput;
import com.redis.lettucemod.output.CfInfoOutput;
import com.redis.lettucemod.output.CmsInfoOutput;
import com.redis.lettucemod.output.TDigestDoubleListOutput;
import com.redis.lettucemod.output.TDigestDoubleOutput;
import com.redis.lettucemod.output.TDigestInfoOutput;
import com.redis.lettucemod.output.TopKInfoOutput;
import com.redis.lettucemod.output.TopKListWithScoresOutput;
import com.redis.lettucemod.protocol.BloomCommandKeyword;
import com.redis.lettucemod.protocol.BloomFilterCommandType;
import com.redis.lettucemod.protocol.CountMinSketchCommandType;
import com.redis.lettucemod.protocol.CuckooFilterCommandType;
import com.redis.lettucemod.protocol.TDigestCommandType;
import com.redis.lettucemod.protocol.TopKCommandType;
import io.lettuce.core.KeyValue;
import io.lettuce.core.Value;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.BooleanListOutput;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerListOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.StringListOutput;
import io.lettuce.core.output.ValueValueListOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BloomCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    public BloomCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(BloomFilterCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    protected <A, B, T> Command<A, B, T> createCommand(CuckooFilterCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    protected <A, B, T> Command<A, B, T> createCommand(CountMinSketchCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    protected <A, B, T> Command<A, B, T> createCommand(TopKCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    protected <A, B, T> Command<A, B, T> createCommand(TDigestCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    public Command<K, V, Boolean> bfAdd(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(BloomFilterCommandType.ADD, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> bfCard(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(BloomFilterCommandType.CARD, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Boolean> bfExists(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(BloomFilterCommandType.EXISTS, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, BloomFilterInfo> bfInfo(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(BloomFilterCommandType.INFO, new BfInfoOutput(this.codec), args);
    }

    public Command<K, V, Long> bfInfo(K key, BloomFilterInfoType type) {
        CommandArgs args = this.args(key);
        args.add(type.name());
        return this.createCommand(BloomFilterCommandType.INFO, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Boolean>> bfInsert(K key, V[] items) {
        CommandArgs args = this.args(key);
        for (V item : items) {
            args.addValue(item);
        }
        return this.createCommand(BloomFilterCommandType.INSERT, (CommandOutput)new BooleanListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Boolean>> bfInsert(K key, BloomFilterInsertOptions options, V ... items) {
        BloomCommandBuilder.notNullKey(key);
        LettuceAssert.isTrue((items.length > 0 ? 1 : 0) != 0, (String)"At least one item is required");
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        args.add((ProtocolKeyword)BloomCommandKeyword.ITEMS);
        for (V item : items) {
            args.addValue(item);
        }
        return this.createCommand(BloomFilterCommandType.INSERT, (CommandOutput)new BooleanListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Boolean>> bfMAdd(K key, V[] items) {
        CommandArgs args = this.args(key);
        for (V item : items) {
            args.addValue(item);
        }
        return this.createCommand(BloomFilterCommandType.MADD, (CommandOutput)new BooleanListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Boolean>> bfMExists(K key, V[] items) {
        CommandArgs args = this.args(key);
        for (V item : items) {
            args.addValue(item);
        }
        return this.createCommand(BloomFilterCommandType.MEXISTS, (CommandOutput)new BooleanListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> bfReserve(K key, double errorRate, long capacity, BloomFilterReserveOptions options) {
        BloomCommandBuilder.notNullKey(key);
        CommandArgs args = this.args(key);
        args.add(errorRate);
        args.add(capacity);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(BloomFilterCommandType.RESERVE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Boolean> cfAdd(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(CuckooFilterCommandType.ADD, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Boolean> cfAddNx(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(CuckooFilterCommandType.ADDNX, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> cfCount(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(CuckooFilterCommandType.COUNT, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Boolean> cfDel(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(CuckooFilterCommandType.DEL, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Boolean> cfExists(K key, V item) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        return this.createCommand(CuckooFilterCommandType.EXISTS, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, CuckooFilter> cfInfo(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(CuckooFilterCommandType.INFO, new CfInfoOutput(this.codec), args);
    }

    public Command<K, V, List<Long>> cfInsert(K key, V[] items) {
        CommandArgs args = this.args(key);
        args.add((ProtocolKeyword)BloomCommandKeyword.ITEMS);
        args.addValues((Object[])items);
        return this.createCommand(CuckooFilterCommandType.INSERT, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Long>> cfInsert(K key, V[] items, CuckooFilterInsertOptions options) {
        CommandArgs args = this.args(key);
        options.build(args);
        args.add((ProtocolKeyword)BloomCommandKeyword.ITEMS);
        args.addValues((Object[])items);
        return this.createCommand(CuckooFilterCommandType.INSERT, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Long>> cfInsertNx(K key, V[] items) {
        CommandArgs args = this.args(key);
        args.add((ProtocolKeyword)BloomCommandKeyword.ITEMS);
        args.addValues((Object[])items);
        return this.createCommand(CuckooFilterCommandType.INSERTNX, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Long>> cfInsertNx(K key, V[] items, CuckooFilterInsertOptions options) {
        CommandArgs args = this.args(key);
        options.build(args);
        args.add((ProtocolKeyword)BloomCommandKeyword.ITEMS);
        args.addValues((Object[])items);
        return this.createCommand(CuckooFilterCommandType.INSERTNX, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Boolean>> cfMExists(K key, V[] items) {
        CommandArgs args = this.args(key);
        args.addValues((Object[])items);
        return this.createCommand(CuckooFilterCommandType.MEXISTS, (CommandOutput)new BooleanListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> cfReserve(K key, long capacity, CuckooFilterReserveOptions options) {
        CommandArgs args = this.args(key);
        args.add(capacity);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(CuckooFilterCommandType.RESERVE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> cmsIncrBy(K key, V item, long increment) {
        CommandArgs args = this.args(key);
        args.addValue(item);
        args.add(increment);
        return this.createCommand(CountMinSketchCommandType.INCRBY, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Long>> cmsIncrBy(K key, LongScoredValue<V> ... increments) {
        CommandArgs args = this.args(key);
        for (LongScoredValue<V> increment : increments) {
            args.addValue(increment.getValue());
            args.add(increment.getScore());
        }
        return this.createCommand(CountMinSketchCommandType.INCRBY, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> cmsInitByProb(K key, double error, double probability) {
        CommandArgs args = this.args(key);
        args.add(error);
        args.add(probability);
        return this.createCommand(CountMinSketchCommandType.INITBYPROB, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> cmsInitByDim(K key, long width, long depth) {
        CommandArgs args = this.args(key);
        args.add(width);
        args.add(depth);
        return this.createCommand(CountMinSketchCommandType.INITBYDIM, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Long>> cmsQuery(K key, V ... items) {
        CommandArgs args = this.args(key);
        args.addValues((Object[])items);
        return this.createCommand(CountMinSketchCommandType.QUERY, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> cmsMerge(K desKey, K ... sourceKeys) {
        LettuceAssert.isTrue((sourceKeys.length > 0 ? 1 : 0) != 0, (String)"At least one source is required");
        CommandArgs args = this.args(desKey);
        args.add((long)sourceKeys.length);
        args.addKeys((Object[])sourceKeys);
        return this.createCommand(CountMinSketchCommandType.MERGE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> cmsMerge(K destKey, LongScoredValue<K> ... weights) {
        LettuceAssert.isTrue((weights.length > 0 ? 1 : 0) != 0, (String)"At least one weight is required");
        CommandArgs args = this.args(destKey);
        args.add((long)weights.length);
        args.addKeys((Iterable)Stream.of(weights).map(Value::getValue).collect(Collectors.toList()));
        args.add((ProtocolKeyword)BloomCommandKeyword.WEIGHTS);
        Stream.of(weights).map(LongScoredValue::getScore).forEach(arg_0 -> args.add(arg_0));
        return this.createCommand(CountMinSketchCommandType.MERGE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, CmsInfo> cmsInfo(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(CountMinSketchCommandType.INFO, new CmsInfoOutput(this.codec), args);
    }

    public Command<K, V, List<Value<V>>> topKAdd(K key, V ... items) {
        CommandArgs args = this.args(key);
        args.addValues((Object[])items);
        return this.createCommand(TopKCommandType.ADD, (CommandOutput)new ValueValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Value<V>>> topKIncrBy(K key, LongScoredValue<V> ... increments) {
        LettuceAssert.isTrue((increments.length > 0 ? 1 : 0) != 0, (String)"At least one increment is required");
        CommandArgs args = this.args(key);
        for (LongScoredValue<V> entry : increments) {
            args.addValue(entry.getValue());
            args.add(entry.getScore());
        }
        return this.createCommand(TopKCommandType.ADD, (CommandOutput)new ValueValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, TopKInfo> topKInfo(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TopKCommandType.INFO, new TopKInfoOutput(this.codec), args);
    }

    public Command<K, V, List<String>> topKList(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TopKCommandType.LIST, (CommandOutput)new StringListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<KeyValue<String, Long>>> topKListWithScores(K key) {
        CommandArgs args = this.args(key);
        args.add((ProtocolKeyword)BloomCommandKeyword.WITHCOUNT);
        return this.createCommand(TopKCommandType.LIST, new TopKListWithScoresOutput(this.codec), args);
    }

    public Command<K, V, List<Boolean>> topKQuery(K key, V ... items) {
        CommandArgs args = this.args(key);
        args.addValues((Object[])items);
        return this.createCommand(TopKCommandType.QUERY, (CommandOutput)new BooleanListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> topKReserve(K key, long k) {
        CommandArgs args = this.args(key);
        args.add(k);
        return this.createCommand(TopKCommandType.RESERVE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> topKReserve(K key, long k, long width, long depth, double decay) {
        CommandArgs args = this.args(key);
        args.add(k);
        args.add(width);
        args.add(depth);
        args.add(decay);
        return this.createCommand(TopKCommandType.RESERVE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> tDigestAdd(K key, double ... values) {
        CommandArgs args = this.args(key);
        for (double val : values) {
            args.add(val);
        }
        return this.createCommand(TDigestCommandType.ADD, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Double>> tDigestByRank(K key, long ... ranks) {
        CommandArgs args = this.args(key);
        for (long rank : ranks) {
            args.add(rank);
        }
        return this.createCommand(TDigestCommandType.BYRANK, new TDigestDoubleListOutput(this.codec), args);
    }

    public Command<K, V, List<Double>> tDigestByRevRank(K key, long ... ranks) {
        CommandArgs args = this.args(key);
        for (long rank : ranks) {
            args.add(rank);
        }
        return this.createCommand(TDigestCommandType.BYREVRANK, new TDigestDoubleListOutput(this.codec), args);
    }

    public Command<K, V, List<Double>> tDigestCdf(K key, double ... values) {
        CommandArgs args = this.args(key);
        for (double value : values) {
            args.add(value);
        }
        return this.createCommand(TDigestCommandType.CDF, new TDigestDoubleListOutput(this.codec), args);
    }

    public Command<K, V, String> tDigestCreate(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TDigestCommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> tDigestCreate(K key, long compression) {
        CommandArgs args = this.args(key);
        args.add((ProtocolKeyword)BloomCommandKeyword.COMPRESSION);
        args.add(compression);
        return this.createCommand(TDigestCommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, TDigestInfo> tDigestInfo(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TDigestCommandType.INFO, new TDigestInfoOutput(this.codec), args);
    }

    public Command<K, V, Double> tDigestMax(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TDigestCommandType.MAX, new TDigestDoubleOutput(this.codec), args);
    }

    public Command<K, V, String> tDigestMerge(K destinationKey, K ... sourceKeys) {
        CommandArgs args = this.args(destinationKey);
        args.addKeys((Object[])sourceKeys);
        return this.createCommand(TDigestCommandType.MERGE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> tDigestMerge(K destinationKey, TDigestMergeOptions options, K ... sourceKeys) {
        CommandArgs args = this.args(destinationKey);
        args.addKeys((Object[])sourceKeys);
        options.build(args);
        return this.createCommand(TDigestCommandType.MERGE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Double> tDigestMin(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TDigestCommandType.MIN, new TDigestDoubleOutput(this.codec), args);
    }

    public Command<K, V, List<Double>> tDigestQuantile(K key, double ... quantiles) {
        CommandArgs args = this.args(key);
        for (double quantile : quantiles) {
            args.add(quantile);
        }
        return this.createCommand(TDigestCommandType.QUANTILE, new TDigestDoubleListOutput(this.codec), args);
    }

    public Command<K, V, List<Long>> tDigestRank(K key, double ... values) {
        CommandArgs args = this.args(key);
        for (double value : values) {
            args.add(value);
        }
        return this.createCommand(TDigestCommandType.RANK, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> tDigestReset(K key) {
        CommandArgs args = this.args(key);
        return this.createCommand(TDigestCommandType.RESET, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Long>> tDigestRevRank(K key, double ... values) {
        CommandArgs args = this.args(key);
        for (double value : values) {
            args.add(value);
        }
        return this.createCommand(TDigestCommandType.REVRANK, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Double> tDigestTrimmedMean(K key, double lowCutQuantile, double highCutQuantile) {
        CommandArgs args = this.args(key);
        args.add(lowCutQuantile);
        args.add(highCutQuantile);
        return this.createCommand(TDigestCommandType.TRIMMED_MEAN, new TDigestDoubleOutput(this.codec), args);
    }
}

