/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import lombok.Generated;

public class CursorOptions {
    private OptionalLong count = OptionalLong.empty();
    private Optional<Duration> maxIdle = Optional.empty();

    public CursorOptions() {
    }

    private CursorOptions(Builder builder) {
        this.count = builder.count;
        this.maxIdle = builder.maxIdle;
    }

    public <K, V> void build(SearchCommandArgs<K, V> args) {
        this.count.ifPresent(c -> {
            args.add(SearchCommandKeyword.COUNT);
            args.add(c);
        });
        this.maxIdle.ifPresent(m -> {
            args.add(SearchCommandKeyword.MAXIDLE);
            args.add(m.toMillis());
        });
    }

    public OptionalLong getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = OptionalLong.of(count);
    }

    public Optional<Duration> getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(Duration maxIdle) {
        this.maxIdle = Optional.of(maxIdle);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.maxIdle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CursorOptions other = (CursorOptions)obj;
        return Objects.equals(this.count, other.count) && Objects.equals(this.maxIdle, other.maxIdle);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String toString() {
        return "CursorOptions(count=" + this.getCount() + ", maxIdle=" + this.getMaxIdle() + ")";
    }

    public static final class Builder {
        private OptionalLong count = OptionalLong.empty();
        private Optional<Duration> maxIdle = Optional.empty();

        private Builder() {
        }

        public Builder count(long count) {
            this.count = OptionalLong.of(count);
            return this;
        }

        public Builder maxIdle(Duration maxIdle) {
            this.maxIdle = Optional.of(maxIdle);
            return this;
        }

        public CursorOptions build() {
            return new CursorOptions(this);
        }
    }
}

