/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.CreateOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.IndexInfo;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.TagField;
import com.redis.lettucemod.search.TextField;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class IndexInfoParser {
    private static final String FIELD_FIELDS = "fields";
    private static final String FIELD_ATTRIBUTES = "attributes";
    public static final String ERROR_UNKNOWN_INDEX_NAME = "Unknown Index name";
    private final Map<String, Object> map;

    public IndexInfoParser(List<Object> list) {
        this.map = IndexInfoParser.toMap(list);
    }

    public static Map<String, Object> toMap(List<Object> list) {
        LettuceAssert.isTrue((list.size() % 2 == 0 ? 1 : 0) != 0, (String)"List must be a multiple of 2 and contain a sequence of field1, value1, field2, value2, ..., fieldN, valueN");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); i += 2) {
            map.put((String)list.get(i), list.get(i + 1));
        }
        return map;
    }

    private List<Field<String>> fieldsFromAttributes(List<Object> list) {
        ArrayList<Field<String>> fields = new ArrayList<Field<String>>();
        for (Object object : list) {
            List attributes = (List)object;
            Field<String> field = this.field((String)attributes.get(5), (String)attributes.get(1));
            field.setAs((String)attributes.get(3));
            if (attributes.size() > 6) {
                this.populateField(field, attributes.subList(6, attributes.size()));
            }
            fields.add(field);
        }
        return fields;
    }

    private String getString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private Long toLong(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return null;
        }
        return this.getLong(map.get(key));
    }

    private Field<String> field(String type, String name) {
        if (type.toUpperCase().equals(SearchCommandKeyword.GEO.name())) {
            return Field.geo(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.NUMERIC.name())) {
            return Field.numeric(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.TAG.name())) {
            return Field.tag(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.TEXT.name())) {
            return Field.text(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.VECTOR.name())) {
            return Field.vector(name).build();
        }
        throw new IllegalArgumentException("Unknown field type: " + type);
    }

    private void populateField(Field<String> field, List<Object> attributes) {
        if (field.getType() == Field.Type.TAG) {
            LettuceAssert.isTrue((boolean)SearchCommandKeyword.SEPARATOR.name().equals(attributes.remove(0)), (String)"Wrong attribute name");
            TagField tagField = (TagField)field;
            String separator = (String)attributes.remove(0);
            if (!separator.isEmpty()) {
                tagField.setSeparator(separator.charAt(0));
            }
            tagField.setCaseSensitive(attributes.contains(SearchCommandKeyword.CASESENSITIVE.name()));
        } else if (field.getType() == Field.Type.TEXT) {
            LettuceAssert.isTrue((boolean)SearchCommandKeyword.WEIGHT.name().equals(attributes.remove(0)), (String)"Wrong attribute name");
            TextField textField = (TextField)field;
            Object weight = attributes.remove(0);
            textField.setWeight(this.getDouble(weight));
            textField.setNoStem(attributes.contains(SearchCommandKeyword.NOSTEM.name()));
        }
        field.setNoIndex(attributes.contains(SearchCommandKeyword.NOINDEX.name()));
        field.setSortable(attributes.contains(SearchCommandKeyword.SORTABLE.name()));
        field.setUnNormalizedForm(attributes.contains(SearchCommandKeyword.UNF.name()));
    }

    private List<Field<String>> fieldsFromFields(List<Object> list) {
        ArrayList<Field<String>> fields = new ArrayList<Field<String>>();
        for (Object infoObject : list) {
            List info = (List)infoObject;
            Field<String> field = this.field((String)info.get(2), (String)info.get(0));
            this.populateField(field, info.subList(3, info.size()));
            fields.add(field);
        }
        return fields;
    }

    public IndexInfo indexInfo() {
        IndexInfo indexInfo = new IndexInfo();
        indexInfo.setIndexName(this.getString(this.map.get("index_name")));
        CreateOptions<String, String> options = this.createOptions();
        indexInfo.setIndexOptions(options);
        if (this.map.containsKey(FIELD_FIELDS)) {
            indexInfo.setFields(this.fieldsFromFields(this.map.getOrDefault(FIELD_FIELDS, new ArrayList())));
        }
        if (this.map.containsKey(FIELD_ATTRIBUTES)) {
            indexInfo.setFields(this.fieldsFromAttributes(this.map.getOrDefault(FIELD_ATTRIBUTES, new ArrayList())));
        }
        indexInfo.setNumDocs(this.getDouble(this.map.get("num_docs")));
        indexInfo.setMaxDocId(this.getString(this.map.get("max_doc_id")));
        indexInfo.setNumTerms(this.toLong(this.map, "num_terms"));
        indexInfo.setNumRecords(this.toLong(this.map, "num_records"));
        indexInfo.setInvertedSizeMb(this.getDouble(this.map.get("inverted_sz_mb")));
        indexInfo.setTotalInvertedIndexBlocks(this.toLong(this.map, "total_inverted_index_blocks"));
        indexInfo.setVectorIndexSizeMb(this.getDouble(this.map.get("vector_index_sz_mb")));
        indexInfo.setOffsetVectorsSizeMb(this.getDouble(this.map.get("offset_vectors_sz_mb")));
        indexInfo.setDocTableSizeMb(this.getDouble(this.map.get("doc_table_size_mb")));
        indexInfo.setSortableValuesSizeMb(this.getDouble(this.map.get("sortable_values_size_mb")));
        indexInfo.setKeyTableSizeMb(this.getDouble(this.map.get("key_table_size_mb")));
        indexInfo.setRecordsPerDocAvg(this.getDouble(this.map.get("records_per_doc_avg")));
        indexInfo.setBytesPerRecordAvg(this.getDouble(this.map.get("bytes_per_record_avg")));
        indexInfo.setOffsetsPerTermAvg(this.getDouble(this.map.get("offsets_per_term_avg")));
        indexInfo.setOffsetBitsPerRecordAvg(this.getDouble(this.map.get("offset_bits_per_record_avg")));
        indexInfo.setGcStats((List)this.map.get("gc_stats"));
        indexInfo.setCursorStats((List)this.map.get("cursor_stats"));
        return indexInfo;
    }

    private void matchOption(String key, SearchCommandKeyword keyword, Consumer<Boolean> setter) {
        if (key.toUpperCase().equals(keyword.name())) {
            setter.accept(true);
        }
    }

    private CreateOptions<String, String> createOptions() {
        CreateOptions.Builder<String, String> options = CreateOptions.builder();
        for (String key : (List)this.map.get("index_options")) {
            this.matchOption(key, SearchCommandKeyword.NOOFFSETS, options::noOffsets);
            this.matchOption(key, SearchCommandKeyword.NOHL, options::noHL);
            this.matchOption(key, SearchCommandKeyword.NOFIELDS, options::noFields);
            this.matchOption(key, SearchCommandKeyword.NOFREQS, options::noFreqs);
            this.matchOption(key, SearchCommandKeyword.MAXTEXTFIELDS, options::maxTextFields);
        }
        Iterator indexDefinition = ((List)this.map.get("index_definition")).iterator();
        while (indexDefinition.hasNext()) {
            String key = (String)indexDefinition.next();
            if (key.equals("key_type")) {
                options.on(CreateOptions.DataType.valueOf(((String)indexDefinition.next()).toUpperCase()));
                continue;
            }
            if (key.equals("prefixes")) {
                options.prefixes(((List)indexDefinition.next()).toArray(new String[0]));
                continue;
            }
            if (key.equals("filter")) {
                options.filter((String)indexDefinition.next());
                continue;
            }
            if (key.equals("default_language")) {
                options.defaultLanguage(Language.valueOf(((String)indexDefinition.next()).toUpperCase()));
                continue;
            }
            if (key.equals("language_field")) {
                options.languageField((String)indexDefinition.next());
                continue;
            }
            if (key.equals("default_score")) {
                options.defaultScore(this.getDouble(indexDefinition.next()));
                continue;
            }
            if (key.equals("score_field")) {
                options.scoreField((String)indexDefinition.next());
                continue;
            }
            if (!key.equals("payload_field")) continue;
            options.payloadField((String)indexDefinition.next());
        }
        return options.build();
    }

    private Long getLong(Object object) {
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    public Double getDouble(Object object) {
        if (object instanceof String) {
            return LettuceStrings.toDouble((String)((String)object));
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return null;
    }
}

