/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class KeyspaceToIndexMap {
    private Map<String, Class<?>> keyspaceToEntityClass = new ConcurrentHashMap();
    private Map<Class<?>, String> entityClassToKeySpace = new ConcurrentHashMap();
    private List<Class<?>> indexedEntityClasses = new ArrayList();

    public Optional<String> getIndexName(String keyspace) {
        Class<?> entityClass = this.keyspaceToEntityClass.get(this.getKey(keyspace));
        if (entityClass != null) {
            return Optional.of(entityClass.getName() + "Idx");
        }
        return Optional.empty();
    }

    public Optional<String> getIndexName(Class<?> entityClass) {
        if (this.entityClassToKeySpace.containsKey(entityClass)) {
            return Optional.of(entityClass.getName() + "Idx");
        }
        return Optional.empty();
    }

    public void addKeySpaceMapping(String keyspace, Class<?> entityClass, boolean isIndexed) {
        String key = this.getKey(keyspace);
        this.keyspaceToEntityClass.put(key, entityClass);
        this.entityClassToKeySpace.put(entityClass, key);
        if (isIndexed) {
            this.indexedEntityClasses.add(entityClass);
        }
    }

    public Class<?> getEntityClassForKeyspace(String keyspace) {
        return this.keyspaceToEntityClass.get(this.getKey(keyspace));
    }

    public String getKeyspaceForEntityClass(Class<?> entityClass) {
        return this.entityClassToKeySpace.get(entityClass);
    }

    public boolean indexExistsFor(Class<?> entityClass) {
        return this.indexedEntityClasses.contains(entityClass);
    }

    private String getKey(String keyspace) {
        return keyspace.endsWith(":") ? keyspace : keyspace + ":";
    }
}

