/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.google.gson.Gson;
import com.redis.om.spring.KeyspaceToIndexMap;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.convert.RedisOMCustomConversions;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RedisEnhancedKeyValueAdapter
extends RedisKeyValueAdapter {
    private static final int PHANTOM_KEY_TTL = 300;
    private RedisOperations<?, ?> redisOperations;
    private RedisConverter converter;
    @Nullable
    private RedisMessageListenerContainer messageListenerContainer;
    private final AtomicReference<KeyExpirationEventMessageListener> expirationListener = new AtomicReference<Object>(null);
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    private RedisKeyValueAdapter.EnableKeyspaceEvents enableKeyspaceEvents = RedisKeyValueAdapter.EnableKeyspaceEvents.OFF;
    @Nullable
    private String keyspaceNotificationsConfigParameter = null;
    private RedisKeyValueAdapter.ShadowCopy shadowCopy = RedisKeyValueAdapter.ShadowCopy.DEFAULT;
    private RedisModulesOperations<String> modulesOperations;
    private KeyspaceToIndexMap keyspaceToIndexMap;
    private static final Gson gson = GsonBuidlerFactory.getBuilder().create();

    public RedisEnhancedKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, KeyspaceToIndexMap keyspaceToIndexMap) {
        this(redisOps, rmo, new RedisMappingContext(), keyspaceToIndexMap);
    }

    public RedisEnhancedKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RedisMappingContext mappingContext, KeyspaceToIndexMap keyspaceToIndexMap) {
        this(redisOps, rmo, mappingContext, (CustomConversions)new RedisOMCustomConversions(), keyspaceToIndexMap);
    }

    public RedisEnhancedKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RedisMappingContext mappingContext, @Nullable CustomConversions customConversions, KeyspaceToIndexMap keyspaceToIndexMap) {
        super(redisOps, mappingContext, customConversions);
        Assert.notNull(redisOps, (String)"RedisOperations must not be null!");
        Assert.notNull((Object)mappingContext, (String)"RedisMappingContext must not be null!");
        MappingRedisOMConverter mappingConverter = new MappingRedisOMConverter(mappingContext, (ReferenceResolver)new ReferenceResolverImpl(redisOps));
        mappingConverter.setCustomConversions((CustomConversions)(customConversions == null ? new RedisOMCustomConversions() : customConversions));
        mappingConverter.afterPropertiesSet();
        this.converter = mappingConverter;
        this.redisOperations = redisOps;
        this.modulesOperations = rmo;
        this.keyspaceToIndexMap = keyspaceToIndexMap;
        this.initMessageListenerContainer();
    }

    public Object put(Object id, Object item, String keyspace) {
        RedisData rdo;
        if (item instanceof RedisData) {
            rdo = (RedisData)item;
        } else {
            byte[] redisKey = this.createKey(keyspace, (String)this.converter.getConversionService().convert(id, String.class));
            this.processAuditAnnotations(redisKey, item);
            rdo = new RedisData();
            this.converter.write(item, (Object)rdo);
        }
        if (org.springframework.util.ObjectUtils.nullSafeEquals((Object)RedisKeyValueAdapter.EnableKeyspaceEvents.ON_DEMAND, (Object)this.enableKeyspaceEvents) && this.expirationListener.get() == null && rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
            this.initKeyExpirationListener();
        }
        if (rdo.getId() == null) {
            rdo.setId((String)this.converter.getConversionService().convert(id, String.class));
        }
        byte[] objectKey = this.createKey(rdo.getKeyspace(), rdo.getId());
        boolean isNew = (Boolean)this.redisOperations.execute(connection -> connection.del((byte[][])new byte[][]{objectKey}) == 0L);
        this.redisOperations.executePipelined(connection -> {
            byte[] key = this.toBytes(rdo.getId());
            Map rawMap = rdo.getBucket().rawMap();
            connection.hMSet(objectKey, rawMap);
            if (isNew) {
                connection.sAdd(this.toBytes(rdo.getKeyspace()), (byte[][])new byte[][]{key});
            }
            if (this.expires(rdo)) {
                connection.expire(objectKey, rdo.getTimeToLive().longValue());
            }
            if (this.keepShadowCopy()) {
                byte[] phantomKey = ByteUtils.concat((byte[])objectKey, (byte[])MappingRedisOMConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                if (this.expires(rdo)) {
                    connection.del((byte[][])new byte[][]{phantomKey});
                    connection.hMSet(phantomKey, rawMap);
                    connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                } else if (!isNew) {
                    connection.del((byte[][])new byte[][]{phantomKey});
                }
            }
            return null;
        });
        return item;
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        String stringId = this.asString(id);
        String stringKeyspace = this.asString(keyspace);
        byte[] binId = this.createKey(stringKeyspace, stringId);
        Map raw = (Map)this.redisOperations.execute(connection -> connection.hGetAll(binId));
        if (CollectionUtils.isEmpty((Map)raw)) {
            return null;
        }
        RedisData data = new RedisData(raw);
        data.setId(stringId);
        data.setKeyspace(stringKeyspace);
        return (T)this.readBackTimeToLiveIfSet(binId, this.converter.read(type, (Object)data));
    }

    public void deleteAllOf(String keyspace) {
        this.redisOperations.execute(connection -> {
            connection.del((byte[][])new byte[][]{this.toBytes(keyspace)});
            return null;
        });
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type, long offset, int rows) {
        byte[] binKeyspace = this.toBytes(keyspace);
        Set ids = (Set)this.redisOperations.execute(connection -> connection.sMembers(binKeyspace));
        ArrayList<T> result = new ArrayList<T>();
        List keys = new ArrayList(ids);
        if (keys.isEmpty() || (long)keys.size() < offset) {
            return Collections.emptyList();
        }
        offset = Math.max(0L, offset);
        if (rows > 0) {
            keys = keys.subList((int)offset, Math.min((int)offset + rows, keys.size()));
        }
        for (byte[] key : keys) {
            result.add(this.get(key, keyspace, type));
        }
        return result;
    }

    public void update(PartialUpdate<?> update) {
        RedisPersistentEntity entity = (RedisPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(update.getTarget());
        String keyspace = entity.getKeySpace();
        Object id = update.getId();
        byte[] redisKey = this.createKey(keyspace, (String)this.converter.getConversionService().convert(id, String.class));
        RedisData rdo = new RedisData();
        this.converter.write(update, (Object)rdo);
        this.redisOperations.execute(connection -> {
            RedisUpdateObject redisUpdateObject = new RedisUpdateObject(redisKey);
            for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                String propertyPath = pUpdate.getPropertyPath();
                if (!PartialUpdate.UpdateCommand.DEL.equals((Object)pUpdate.getCmd()) && !(pUpdate.getValue() instanceof Collection) && !(pUpdate.getValue() instanceof Map) && (pUpdate.getValue() == null || !pUpdate.getValue().getClass().isArray()) && (pUpdate.getValue() == null || this.converter.getConversionService().canConvert(pUpdate.getValue().getClass(), byte[].class))) continue;
                redisUpdateObject = this.fetchDeletePathsFromHash(redisUpdateObject, propertyPath, connection);
            }
            if (!redisUpdateObject.fieldsToRemove.isEmpty()) {
                connection.hDel(redisKey, (byte[][])redisUpdateObject.fieldsToRemove.toArray((T[])new byte[redisUpdateObject.fieldsToRemove.size()][]));
            }
            if (!rdo.getBucket().isEmpty() && (rdo.getBucket().size() > 1 || rdo.getBucket().size() == 1 && !rdo.getBucket().asMap().containsKey("_class"))) {
                connection.hMSet(redisKey, rdo.getBucket().rawMap());
            }
            if (update.isRefreshTtl()) {
                if (this.expires(rdo)) {
                    connection.expire(redisKey, rdo.getTimeToLive().longValue());
                    if (this.keepShadowCopy()) {
                        byte[] phantomKey = ByteUtils.concat((byte[])redisKey, (byte[])MappingRedisOMConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                        connection.hMSet(phantomKey, rdo.getBucket().rawMap());
                        connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                    }
                } else {
                    connection.persist(redisKey);
                    if (this.keepShadowCopy()) {
                        connection.del((byte[][])new byte[][]{ByteUtils.concat((byte[])redisKey, (byte[])MappingRedisOMConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX)});
                    }
                }
            }
            return null;
        });
    }

    private RedisUpdateObject fetchDeletePathsFromHash(RedisUpdateObject redisUpdateObject, String path, RedisConnection connection) {
        redisUpdateObject.addFieldToRemove(this.toBytes(path));
        byte[] value = connection.hGet(redisUpdateObject.targetKey, this.toBytes(path));
        if (value != null && value.length > 0) {
            return redisUpdateObject;
        }
        Set existingFields = connection.hKeys(redisUpdateObject.targetKey);
        for (byte[] field : existingFields) {
            if (!this.asString(field).startsWith(path + ".")) continue;
            redisUpdateObject.addFieldToRemove(field);
            value = connection.hGet(redisUpdateObject.targetKey, this.toBytes(field));
        }
        return redisUpdateObject;
    }

    private String asString(Object value) {
        return value instanceof String ? (String)value : (String)this.getConverter().getConversionService().convert(value, String.class);
    }

    @Nullable
    private <T> T readBackTimeToLiveIfSet(@Nullable byte[] key, @Nullable T target) {
        if (target == null || key == null) {
            return target;
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(target.getClass());
        if (entity.hasExplictTimeToLiveProperty()) {
            RedisPersistentProperty ttlProperty = entity.getExplicitTimeToLiveProperty();
            if (ttlProperty == null) {
                return target;
            }
            TimeToLive ttl = (TimeToLive)ttlProperty.findAnnotation(TimeToLive.class);
            Long timeout = (Long)this.redisOperations.execute(connection -> {
                if (org.springframework.util.ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)ttl.unit()))) {
                    return connection.ttl(key);
                }
                return connection.pTtl(key, ttl.unit());
            });
            if (timeout != null || !ttlProperty.getType().isPrimitive()) {
                PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(target);
                propertyAccessor.setProperty((PersistentProperty)ttlProperty, this.converter.getConversionService().convert((Object)timeout, ttlProperty.getType()));
                target = propertyAccessor.getBean();
            }
        }
        return target;
    }

    private boolean expires(RedisData data) {
        return data.getTimeToLive() != null && data.getTimeToLive() > 0L;
    }

    private void initMessageListenerContainer() {
        this.messageListenerContainer = new RedisMessageListenerContainer();
        this.messageListenerContainer.setConnectionFactory(((RedisTemplate)this.redisOperations).getConnectionFactory());
        this.messageListenerContainer.afterPropertiesSet();
        this.messageListenerContainer.start();
    }

    private void initKeyExpirationListener() {
        if (this.expirationListener.get() == null) {
            MappingExpirationListener listener = new MappingExpirationListener(this.messageListenerContainer, this.redisOperations, this.converter);
            listener.setKeyspaceNotificationsConfigParameter(this.keyspaceNotificationsConfigParameter);
            if (this.eventPublisher != null) {
                listener.setApplicationEventPublisher(this.eventPublisher);
            }
            if (this.expirationListener.compareAndSet(null, listener)) {
                listener.init();
            }
        }
    }

    private void processAuditAnnotations(byte[] redisKey, Object item) {
        boolean isNew = (Boolean)this.redisOperations.execute(connection -> connection.exists(redisKey) == false);
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> RedisEnhancedKeyValueAdapter.lambda$processAuditAnnotations$8((PropertyAccessor)accessor, arg_0));
        }
    }

    private boolean keepShadowCopy() {
        switch (this.shadowCopy) {
            case OFF: {
                return false;
            }
            case ON: {
                return true;
            }
        }
        return this.expirationListener.get() != null;
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$8(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }

    static class RedisUpdateObject {
        private final byte[] targetKey;
        private final Set<byte[]> fieldsToRemove = new LinkedHashSet<byte[]>();

        RedisUpdateObject(byte[] targetKey) {
            this.targetKey = targetKey;
        }

        void addFieldToRemove(byte[] field) {
            this.fieldsToRemove.add(field);
        }
    }

    static class MappingExpirationListener
    extends KeyExpirationEventMessageListener {
        private final RedisOperations<?, ?> ops;
        private final RedisConverter converter;

        MappingExpirationListener(RedisMessageListenerContainer listenerContainer, RedisOperations<?, ?> ops, RedisConverter converter) {
            super(listenerContainer);
            this.ops = ops;
            this.converter = converter;
        }

        public void onMessage(Message message, @Nullable byte[] pattern) {
            if (!this.isKeyExpirationMessage(message)) {
                return;
            }
            byte[] key = message.getBody();
            byte[] phantomKey = ByteUtils.concat((byte[])key, (byte[])((byte[])this.converter.getConversionService().convert((Object)":phantom", byte[].class)));
            Map hash = (Map)this.ops.execute(connection -> {
                Map hash1 = connection.hGetAll(phantomKey);
                if (!CollectionUtils.isEmpty((Map)hash1)) {
                    connection.del((byte[][])new byte[][]{phantomKey});
                }
                return hash1;
            });
            Object value = CollectionUtils.isEmpty((Map)hash) ? null : this.converter.read(Object.class, (Object)new RedisData(hash));
            byte[] channelAsBytes = message.getChannel();
            String channel = !org.springframework.util.ObjectUtils.isEmpty((Object)channelAsBytes) ? (String)this.converter.getConversionService().convert((Object)channelAsBytes, String.class) : null;
            RedisKeyExpiredEvent event = new RedisKeyExpiredEvent(channel, key, value);
            this.ops.execute(connection -> {
                connection.sRem((byte[])this.converter.getConversionService().convert((Object)event.getKeyspace(), byte[].class), (byte[][])new byte[][]{event.getId()});
                return null;
            });
            this.publishEvent(event);
        }

        private boolean isKeyExpirationMessage(Message message) {
            return MappingRedisOMConverter.BinaryKeyspaceIdentifier.isValid(message.getBody());
        }
    }
}

