/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.redis.om.spring.convert.RedisOMCustomConversions;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.util.ObjectUtils;
import com.redislabs.modules.rejson.Path;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RedisJSONKeyValueAdapter
extends RedisKeyValueAdapter {
    private static final Log logger = LogFactory.getLog(RedisJSONKeyValueAdapter.class);
    private JSONOperations<?> redisJSONOperations;
    private RedisOperations<?, ?> redisOperations;
    private RedisMappingContext mappingContext;

    public RedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, JSONOperations<?> redisJSONOperations, RedisMappingContext mappingContext) {
        super(redisOps, mappingContext, (CustomConversions)new RedisOMCustomConversions());
        this.redisJSONOperations = redisJSONOperations;
        this.redisOperations = redisOps;
        this.mappingContext = mappingContext;
    }

    public Object put(Object id, Object item, String keyspace) {
        logger.debug((Object)String.format("%s, %s, %s", id, item, keyspace));
        JSONOperations<?> ops = this.redisJSONOperations;
        String key = this.getKey(keyspace, id);
        this.processAuditAnnotations(key, item);
        Optional<Long> maybeTtl = this.getTTLForEntity(item);
        ops.set(key, item);
        this.redisOperations.execute(connection -> {
            if (maybeTtl.isPresent()) {
                connection.expire(this.toBytes(key), ((Long)maybeTtl.get()).longValue());
            }
            connection.sAdd(this.toBytes(keyspace), (byte[][])new byte[][]{this.toBytes(id)});
            return null;
        });
        return item;
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        return this.get(this.getKey(keyspace, id), type);
    }

    @Nullable
    public <T> T get(String key, Class<T> type) {
        JSONOperations<?> ops = this.redisJSONOperations;
        return ops.get(key, type, new Path[0]);
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type, long offset, int rows) {
        JSONOperations<?> ops = this.redisJSONOperations;
        byte[] binKeyspace = this.toBytes(keyspace);
        Set ids = (Set)this.redisOperations.execute(connection -> connection.sMembers(binKeyspace));
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        String[] keys = (String[])ids.stream().map(b -> this.getKey(keyspace, new String((byte[])b, StandardCharsets.UTF_8))).toArray(String[]::new);
        if (keys.length == 0 || (long)keys.length < offset) {
            return Collections.emptyList();
        }
        offset = Math.max(0L, offset);
        if (rows > 0) {
            keys = Arrays.copyOfRange(keys, (int)offset, Math.min((int)offset + rows, keys.length));
        }
        return ops.mget(type, keys);
    }

    private void processAuditAnnotations(String key, Object item) {
        boolean isNew = (Boolean)this.redisOperations.execute(connection -> connection.exists(this.toBytes(key)) == false);
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> RedisJSONKeyValueAdapter.lambda$processAuditAnnotations$5((PropertyAccessor)accessor, arg_0));
        }
    }

    protected String getKey(String keyspace, Object id) {
        return String.format("%s:%s", keyspace, id);
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        block7: {
            KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
            if (keyspaceConfig.hasSettingsFor(entity.getClass())) {
                KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entity.getClass());
                if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                    try {
                        Field fld = ReflectionUtils.findField(entity.getClass(), (String)settings.getTimeToLivePropertyName());
                        Method ttlGetter = ObjectUtils.getGetterForField(entity.getClass(), fld);
                        Long ttlPropertyValue = ((Number)ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity)).longValue();
                        ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity);
                        if (ttlPropertyValue != null) {
                            TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                            if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                                return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                            }
                            return Optional.of(ttlPropertyValue);
                        }
                        break block7;
                    }
                    catch (IllegalArgumentException | SecurityException e) {
                        return Optional.empty();
                    }
                }
                if (settings != null && settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                    return Optional.of(settings.getTimeToLive());
                }
            }
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$5(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }
}

