/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.google.gson.annotations.JsonAdapter;
import com.redis.om.spring.CustomRedisKeyValueTemplate;
import com.redis.om.spring.KeyspaceToIndexMap;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.RedisJSONKeyValueAdapter;
import com.redis.om.spring.annotations.Bloom;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.DocumentScore;
import com.redis.om.spring.annotations.EnableRedisDocumentRepositories;
import com.redis.om.spring.annotations.EnableRedisEnhancedRepositories;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.pds.BloomOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.FieldName;
import io.redisearch.Schema;
import io.redisearch.client.Client;
import io.redisearch.client.IndexDefinition;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.util.ClassUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class})
@EnableAspectJAutoProxy
@ComponentScans(value={@ComponentScan(value={"com.redis.om.spring.bloom"}), @ComponentScan(value={"com.redis.om.spring.autocomplete"}), @ComponentScan(value={"com.redis.om.spring.metamodel"})})
public class RedisModulesConfiguration
extends CachingConfigurerSupport {
    private static final Log logger = LogFactory.getLog(RedisModulesConfiguration.class);

    @Bean(name={"redisModulesClient"})
    RedisModulesClient redisModulesClient(JedisConnectionFactory jedisConnectionFactory) {
        return new RedisModulesClient(jedisConnectionFactory);
    }

    @Bean(name={"redisModulesOperations"})
    @Primary
    @ConditionalOnMissingBean
    RedisModulesOperations<?> redisModulesOperations(RedisModulesClient rmc, RedisTemplate<?, ?> template) {
        return new RedisModulesOperations(rmc, template);
    }

    @Bean(name={"redisJSONOperations"})
    JSONOperations<?> redisJSONOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForJSON();
    }

    @Bean(name={"redisBloomOperations"})
    BloomOperations<?> redisBloomOperations(RedisModulesOperations<?> redisModulesOperations) {
        return redisModulesOperations.opsForBloom();
    }

    @Bean(name={"redisTemplate"})
    @Primary
    public RedisTemplate<?, ?> redisTemplate(JedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setDefaultSerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory((RedisConnectionFactory)connectionFactory);
        return template;
    }

    @Bean(name={"keyspaceToIndexMap"})
    public KeyspaceToIndexMap keyspaceToIndexMap() {
        return new KeyspaceToIndexMap();
    }

    @Bean(name={"redisJSONKeyValueAdapter"})
    RedisJSONKeyValueAdapter getRedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, JSONOperations<?> redisJSONOperations, RedisMappingContext mappingContext) {
        return new RedisJSONKeyValueAdapter(redisOps, redisJSONOperations, mappingContext);
    }

    @Bean(name={"redisJSONKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getRedisJSONKeyValueTemplate(RedisOperations<?, ?> redisOps, JSONOperations<?> redisJSONOperations, RedisMappingContext mappingContext) {
        return new CustomRedisKeyValueTemplate(this.getRedisJSONKeyValueAdapter(redisOps, redisJSONOperations, mappingContext), mappingContext);
    }

    @Bean(name={"redisCustomKeyValueTemplate"})
    public CustomRedisKeyValueTemplate getKeyValueTemplate(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> redisModulesOperations, RedisMappingContext mappingContext, KeyspaceToIndexMap keyspaceToIndexMap) {
        return new CustomRedisKeyValueTemplate(new RedisEnhancedKeyValueAdapter(redisOps, redisModulesOperations, mappingContext, keyspaceToIndexMap), mappingContext);
    }

    @Bean(name={"streamingQueryBuilder"})
    EntityStream streamingQueryBuilder(RedisModulesOperations<?> redisModulesOperations) {
        return new EntityStreamImpl(redisModulesOperations);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void ensureIndexesAreCreated(ContextRefreshedEvent cre) {
        logger.info((Object)"Creating Indexes......");
        ApplicationContext ac = cre.getApplicationContext();
        this.createIndicesFor(Document.class, ac);
        this.createIndicesFor(RedisHash.class, ac);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void processBloom(ContextRefreshedEvent cre) {
        ApplicationContext ac = cre.getApplicationContext();
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        Set<BeanDefinition> beanDefs = this.getBeanDefinitionsFor(ac, Document.class, RedisHash.class);
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                for (Field field : cl.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Bloom.class)) continue;
                    Bloom bloom = field.getAnnotation(Bloom.class);
                    BloomOperations<String> ops = rmo.opsForBloom();
                    String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bloom.name()) ? bloom.name() : String.format("bf:%s:%s", cl.getSimpleName(), field.getName());
                    ops.createFilter(filterName, bloom.capacity(), bloom.errorRate());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Error during processing of @Bloom annotation: ", (Throwable)e);
            }
        }
    }

    private void createIndicesFor(Class<?> cls, ApplicationContext ac) {
        RedisModulesOperations rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        RedisMappingContext mappingContext = (RedisMappingContext)ac.getBean("keyValueMappingContext");
        KeyspaceToIndexMap keyspaceToIndexMap = (KeyspaceToIndexMap)ac.getBean("keyspaceToIndexMap");
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>();
        beanDefs.addAll(this.getBeanDefinitionsFor(ac, cls));
        logger.info((Object)String.format("Found %s @%s annotated Beans...", beanDefs.size(), cls.getSimpleName()));
        for (BeanDefinition beanDef : beanDefs) {
            Object indexName = "";
            String scoreField = null;
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                indexName = cl.getName() + "Idx";
                logger.info((Object)String.format("Found @%s annotated class: %s", cls.getSimpleName(), cl.getName()));
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                for (Field field : cl.getDeclaredFields()) {
                    fields.addAll(this.findIndexFields(field, null, cls == Document.class));
                    if (!field.isAnnotationPresent(DocumentScore.class)) continue;
                    String fieldPrefix = cls == Document.class ? "$." : "";
                    scoreField = fieldPrefix + field.getName();
                }
                Object entityPrefix = cl.getName() + ":";
                if (!fields.isEmpty()) {
                    RedisHash hash;
                    Schema schema = new Schema();
                    SearchOperations<Object> opsForSearch = rmo.opsForSearch(indexName);
                    for (Schema.Field field2 : fields) {
                        schema.addField(field2);
                    }
                    IndexDefinition indexDefinition = new IndexDefinition(cls == Document.class ? IndexDefinition.Type.JSON : IndexDefinition.Type.HASH);
                    if (cl.isAnnotationPresent(Document.class)) {
                        Document document = cl.getAnnotation(Document.class);
                        indexDefinition.setAsync(document.async());
                        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.value())) {
                            entityPrefix = document.value();
                        }
                        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.filter())) {
                            indexDefinition.setFilter(document.filter());
                        }
                        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.language())) {
                            indexDefinition.setLanguage(document.language());
                        }
                        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.languageField())) {
                            indexDefinition.setLanguageField(document.languageField());
                        }
                        indexDefinition.setScore(document.score());
                        if (scoreField != null) {
                            indexDefinition.setScoreFiled(scoreField);
                        }
                    } else if (cl.isAnnotationPresent(RedisHash.class) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hash = cl.getAnnotation(RedisHash.class)).value())) {
                        entityPrefix = hash.value();
                    }
                    indexDefinition.setPrefixes(new String[]{entityPrefix});
                    Client.IndexOptions ops = Client.IndexOptions.defaultOptions().setDefinition(indexDefinition);
                    opsForSearch.createIndex(schema, ops);
                    keyspaceToIndexMap.addKeySpaceMapping((String)entityPrefix, cl, true);
                } else {
                    keyspaceToIndexMap.addKeySpaceMapping((String)entityPrefix, cl, false);
                }
                if (!cl.isAnnotationPresent(Document.class)) continue;
                KeyspaceConfiguration.KeyspaceSettings setting = new KeyspaceConfiguration.KeyspaceSettings(cl, cl.getName() + ":");
                Document document = cl.getAnnotation(Document.class);
                if (document.timeToLive() > 0L) {
                    setting.setTimeToLive(Long.valueOf(document.timeToLive()));
                }
                for (Field field : cl.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(TimeToLive.class)) continue;
                    setting.setTimeToLivePropertyName(field.getName());
                }
                mappingContext.getMappingConfiguration().getKeyspaceConfiguration().addKeyspaceSettings(setting);
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Skipping index creation for %s because %s", indexName, e.getMessage()));
            }
        }
    }

    private List<Schema.Field> findIndexFields(Field field, String prefix, boolean isDocument) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        if (field.isAnnotationPresent(Indexed.class)) {
            logger.info((Object)String.format("FOUND @Indexed annotation on field of type: %s", field.getType()));
            Indexed indexed = field.getAnnotation(Indexed.class);
            Class fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
            if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class) {
                fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex()));
            } else if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class) {
                fields.add(this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex()));
            } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementType(field);
                if (maybeCollectionType.isPresent()) {
                    Class<?> collectionType = maybeCollectionType.get();
                    if (CharSequence.class.isAssignableFrom(collectionType) || collectionType == Boolean.class) {
                        fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex()));
                    } else if (isDocument) {
                        logger.debug((Object)String.format("FOUND nested field on field of type: %s", field.getType()));
                        fields.addAll(this.indexAsNestedFieldFor(field, prefix));
                    }
                } else {
                    logger.debug((Object)String.format("Could not determine the type of elements in the collection %s in entity %s", field.getName(), field.getDeclaringClass().getSimpleName()));
                }
            } else if (fieldType == Point.class) {
                fields.add(this.indexAsGeoFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex()));
            } else {
                for (Field subfield : field.getType().getDeclaredFields()) {
                    fields.addAll(this.findIndexFields(subfield, field.getName(), isDocument));
                }
            }
        } else if (field.isAnnotationPresent(Searchable.class)) {
            logger.info((Object)String.format("FOUND @Searchable annotation on field of type: %s", field.getType()));
            Searchable searchable = field.getAnnotation(Searchable.class);
            fields.add(this.indexAsTextFieldFor(field, isDocument, prefix, searchable));
        } else if (field.isAnnotationPresent(TextIndexed.class)) {
            TextIndexed ti = field.getAnnotation(TextIndexed.class);
            fields.add(this.indexAsTextFieldFor(field, isDocument, prefix, ti));
        } else if (field.isAnnotationPresent(TagIndexed.class)) {
            TagIndexed ti = field.getAnnotation(TagIndexed.class);
            fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, ti));
        } else if (field.isAnnotationPresent(GeoIndexed.class)) {
            GeoIndexed gi = field.getAnnotation(GeoIndexed.class);
            fields.add(this.indexAsGeoFieldFor(field, isDocument, prefix, gi));
        } else if (field.isAnnotationPresent(NumericIndexed.class)) {
            NumericIndexed ni = field.getAnnotation(NumericIndexed.class);
            fields.add(this.indexAsNumericFieldFor(field, isDocument, prefix, ni));
        }
        return fields;
    }

    private Set<BeanDefinition> getBeanDefinitionsFor(ApplicationContext ac, Class ... classes) {
        Map annotatedBeans = ac.getBeansWithAnnotation(SpringBootApplication.class);
        Class<?> app = annotatedBeans.values().toArray()[0].getClass();
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        for (Class cls : classes) {
            provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(cls));
        }
        if (app.isAnnotationPresent(EnableRedisDocumentRepositories.class)) {
            EnableRedisDocumentRepositories edr = app.getAnnotation(EnableRedisDocumentRepositories.class);
            if (edr.basePackages().length > 0) {
                for (String string : edr.basePackages()) {
                    beanDefs.addAll(provider.findCandidateComponents(string));
                }
            } else if (edr.basePackageClasses().length > 0) {
                for (Class<?> clazz : edr.basePackageClasses()) {
                    beanDefs.addAll(provider.findCandidateComponents(clazz.getPackageName()));
                }
            } else {
                beanDefs.addAll(provider.findCandidateComponents(app.getPackageName()));
            }
        }
        if (app.isAnnotationPresent(EnableRedisEnhancedRepositories.class)) {
            EnableRedisEnhancedRepositories er = app.getAnnotation(EnableRedisEnhancedRepositories.class);
            if (er.basePackages().length > 0) {
                for (String string : er.basePackages()) {
                    beanDefs.addAll(provider.findCandidateComponents(string));
                }
            } else if (er.basePackageClasses().length > 0) {
                for (Class<?> clazz : er.basePackageClasses()) {
                    beanDefs.addAll(provider.findCandidateComponents(clazz.getPackageName()));
                }
            } else {
                beanDefs.addAll(provider.findCandidateComponents(app.getPackageName()));
            }
        }
        return beanDefs;
    }

    private Schema.Field indexAsTagFieldFor(Field field, boolean isDocument, String prefix, TagIndexed ti) {
        ClassTypeInformation typeInfo = ClassTypeInformation.from(field.getType());
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? "[*]" : "";
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName() + fieldPostfix));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? fieldName.as(ti.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.TagField(fieldName, ti.separator(), false);
    }

    private Schema.Field indexAsTagFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, String separator, int arrayIndex) {
        ClassTypeInformation typeInfo = ClassTypeInformation.from(field.getType());
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        Object index = arrayIndex != Integer.MIN_VALUE ? ".[" + arrayIndex + "]" : "[*]";
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? index : "";
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName() + fieldPostfix));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.TagField(fieldName, separator.isBlank() ? null : separator, sortable);
    }

    private Schema.Field indexAsTextFieldFor(Field field, boolean isDocument, String prefix, TextIndexed ti) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? fieldName.as(ti.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return new Schema.TextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic);
    }

    private Schema.Field indexAsTextFieldFor(Field field, boolean isDocument, String prefix, Searchable ti) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? fieldName.as(ti.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return new Schema.TextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic);
    }

    private Schema.Field indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, GeoIndexed gi) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)gi.alias()) ? fieldName.as(gi.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.Geo);
    }

    private Schema.Field indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, NumericIndexed ni) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName()));
        fieldName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ni.alias()) ? fieldName.as(ni.alias()) : fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.Numeric);
    }

    private Schema.Field indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName()));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.Numeric, sortable, noIndex);
    }

    private Schema.Field indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        Object fieldPrefix = isDocument ? "$." + chain : chain;
        FieldName fieldName = FieldName.of((String)((String)fieldPrefix + field.getName()));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(field, prefix));
        return new Schema.Field(fieldName, Schema.FieldType.Geo);
    }

    private List<Schema.Field> indexAsNestedFieldFor(Field field, String prefix) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        String fieldPrefix = "$." + chain;
        return this.getNestedField(fieldPrefix, field, prefix, null);
    }

    private List<Schema.Field> getNestedField(String fieldPrefix, Field field, String prefix, List<Schema.Field> fieldList) {
        Type genericType;
        if (fieldList == null) {
            fieldList = new ArrayList<Schema.Field>();
        }
        if ((genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
            Field[] subDeclaredFields = actualTypeArgument.getDeclaredFields();
            Object tempPrefix = "";
            prefix = prefix == null ? field.getName() : (String)prefix + "." + field.getName();
            for (Field subField : subDeclaredFields) {
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementType(subField);
                if (subField.isAnnotationPresent(TagIndexed.class)) {
                    TagIndexed ti = subField.getAnnotation(TagIndexed.class);
                    tempPrefix = field.getName() + "[0:].";
                    FieldName fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName()));
                    fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                    logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                    fieldList.add((Schema.Field)new Schema.TagField(fieldName, ti.separator(), false));
                    continue;
                }
                if (subField.isAnnotationPresent(Indexed.class)) {
                    boolean subFieldIsTagField;
                    boolean bl = subFieldIsTagField = subField.isAnnotationPresent(Indexed.class) && (CharSequence.class.isAssignableFrom(subField.getType()) || subField.getType() == Boolean.class || maybeCollectionType.isPresent() && (CharSequence.class.isAssignableFrom(maybeCollectionType.get()) || maybeCollectionType.get() == Boolean.class));
                    if (subFieldIsTagField) {
                        Indexed indexed = subField.getAnnotation(Indexed.class);
                        tempPrefix = field.getName() + "[0:].";
                        FieldName fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName()));
                        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add((Schema.Field)new Schema.TagField(fieldName, indexed.separator(), false));
                        continue;
                    }
                }
                this.getNestedField(fieldPrefix + (String)tempPrefix, subField, (String)prefix, fieldList);
            }
        }
        return fieldList;
    }
}

