/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.autocomplete;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redis.om.spring.annotations.AutoComplete;
import com.redis.om.spring.annotations.AutoCompletePayload;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import io.redisearch.Suggestion;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.Repository;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoCompleteAspect
implements Ordered {
    private RedisModulesOperations<String> rmo;
    private GsonBuilder gsonBuilder = GsonBuidlerFactory.getBuilder();

    public AutoCompleteAspect(RedisModulesOperations<String> rmo) {
        this.rmo = rmo;
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.save(..))")
    public void inCrudRepositorySave() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.save(..))")
    public void inRedisDocumentRepositorySave() {
    }

    @Pointcut(value="inCrudRepositorySave() || inRedisDocumentRepositorySave()")
    private void inSaveOperation() {
    }

    @AfterReturning(value="inSaveOperation() && args(entity,..)")
    public void addSuggestion(JoinPoint jp, Object entity) {
        this.processSuggestionsForEntity(entity);
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.saveAll(..))")
    public void inCrudRepositorySaveAll() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.saveAll(..))")
    public void inRedisDocumentRepositorySaveAll() {
    }

    @Pointcut(value="inCrudRepositorySaveAll() || inRedisDocumentRepositorySaveAll()")
    private void inSaveAllOperation() {
    }

    @AfterReturning(value="inSaveAllOperation() && args(entities,..)")
    public void addAllSuggestions(JoinPoint jp, List<Object> entities) {
        for (Object entity : entities) {
            this.processSuggestionsForEntity(entity);
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.delete(..))")
    public void inRedisDocumentRepositoryDelete() {
    }

    @AfterReturning(value="inRedisDocumentRepositoryDelete() && args(entity,..)")
    public void deleteSuggestion(JoinPoint jp, Object entity) {
        this.deleteSuggestionsForEntity(entity);
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAll())")
    public void inRedisDocumentRepositoryDeleteAll() {
    }

    @AfterReturning(value="inRedisDocumentRepositoryDeleteAll()")
    public void deleteAllSuggestions(JoinPoint jp) {
        Repository repository = (Repository)jp.getTarget();
        Class entityClass = GenericTypeResolver.resolveTypeArguments(repository.getClass(), Repository.class)[0];
        for (Field field : entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoComplete.class)) continue;
            String key = String.format("sugg:%s:%s", entityClass.getSimpleName(), field.getName());
            RedisTemplate<?, ?> template = this.rmo.getTemplate();
            template.delete((Object)key);
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAll(..))")
    public void inRedisDocumentRepositoryDeleteAllEntities() {
    }

    @AfterReturning(value="inRedisDocumentRepositoryDeleteAllEntities() && args(entities,..)")
    public void deleteAllSuggestionsFromEntities(JoinPoint jp, List<Object> entities) {
        for (Object entity : entities) {
            for (Field field : entity.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(AutoComplete.class)) continue;
                AutoComplete suggestable = field.getAnnotation(AutoComplete.class);
                String key = !ObjectUtils.isEmpty((Object)suggestable.name()) ? suggestable.name() : String.format("sugg:%s:%s", entity.getClass().getSimpleName(), field.getName());
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                    SearchOperations<String> ops = this.rmo.opsForSearch(key);
                    ops.deleteSuggestion(pd.getReadMethod().invoke(entity, new Object[0]).toString());
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteById(..))")
    public void inRedisDocumentRepositoryDeleteById() {
    }

    @Before(value="inRedisDocumentRepositoryDeleteById() && args(id)")
    public void deleteSuggestionById(JoinPoint jp, Object id) {
        CrudRepository repository = (CrudRepository)jp.getTarget();
        Optional maybeEntity = repository.findById((Object)id.toString());
        if (maybeEntity.isPresent()) {
            Object entity = maybeEntity.get();
            this.deleteSuggestionsForEntity(entity);
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAllById(..))")
    public void inRedisDocumentRepositoryDeleteAllById() {
    }

    @Before(value="inRedisDocumentRepositoryDeleteAllById() && args(ids,..)")
    public void deleteAllSuggestionByIds(JoinPoint jp, List<Object> ids) {
        CrudRepository repository = (CrudRepository)jp.getTarget();
        for (Object id : ids) {
            Optional maybeEntity = repository.findById((Object)id.toString());
            if (!maybeEntity.isPresent()) continue;
            Object entity = maybeEntity.get();
            this.deleteSuggestionsForEntity(entity);
        }
    }

    public int getOrder() {
        return 1;
    }

    private void processSuggestionsForEntity(Object entity) {
        Gson gson = this.gsonBuilder.create();
        for (Field field : entity.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoComplete.class)) continue;
            Suggestion.Builder builder = Suggestion.builder();
            HashMap<String, Object> payload = null;
            AutoComplete suggestable = field.getAnnotation(AutoComplete.class);
            String key = !ObjectUtils.isEmpty((Object)suggestable.name()) ? suggestable.name() : String.format("sugg:%s:%s", entity.getClass().getSimpleName(), field.getName());
            SearchOperations<String> ops = this.rmo.opsForSearch(key);
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                builder.str(pd.getReadMethod().invoke(entity, new Object[0]).toString());
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            for (Field field2 : entity.getClass().getDeclaredFields()) {
                boolean inPayload;
                if (!field2.isAnnotationPresent(AutoCompletePayload.class)) continue;
                AutoCompletePayload suggestablePayload = field2.getAnnotation(AutoCompletePayload.class);
                boolean bl = inPayload = !suggestablePayload.value().isBlank() && suggestablePayload.value().equalsIgnoreCase(field.getName()) || Arrays.asList(suggestablePayload.fields()).contains(field.getName());
                if (!inPayload) continue;
                try {
                    if (payload == null) {
                        payload = new HashMap<String, Object>();
                    }
                    PropertyDescriptor pd = new PropertyDescriptor(field2.getName(), entity.getClass());
                    payload.put(field2.getName(), pd.getReadMethod().invoke(entity, new Object[0]));
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (payload != null && !payload.isEmpty()) {
                builder.payload(gson.toJson((Object)payload));
            }
            ops.addSuggestion(builder.build(), false);
        }
    }

    private void deleteSuggestionsForEntity(Object entity) {
        for (Field field : entity.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoComplete.class)) continue;
            AutoComplete suggestable = field.getAnnotation(AutoComplete.class);
            String key = !ObjectUtils.isEmpty((Object)suggestable.name()) ? suggestable.name() : String.format("sugg:%s:%s", entity.getClass().getSimpleName(), field.getName());
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                SearchOperations<String> ops = this.rmo.opsForSearch(key);
                ops.deleteSuggestion(pd.getReadMethod().invoke(entity, new Object[0]).toString());
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

