/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel;

import com.google.auto.service.AutoService;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.metamodel.IllegalJavaBeanException;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.indexed.BooleanField;
import com.redis.om.spring.metamodel.indexed.DateField;
import com.redis.om.spring.metamodel.indexed.GeoField;
import com.redis.om.spring.metamodel.indexed.NumericField;
import com.redis.om.spring.metamodel.indexed.TagField;
import com.redis.om.spring.metamodel.indexed.TextField;
import com.redis.om.spring.metamodel.indexed.TextTagField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedBooleanField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedNumericField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedTagField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedTextField;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.Triple;
import com.redis.om.spring.tuple.Tuples;
import com.redis.om.spring.util.ObjectUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.util.ClassUtils;

@SupportedAnnotationTypes(value={"com.redis.om.spring.annotations.Document"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@AutoService(value={Processor.class})
public final class MetamodelGenerator
extends AbstractProcessor {
    protected static final String GET_PREFIX = "get";
    protected static final String IS_PREFIX = "is";
    private ProcessingEnvironment processingEnvironment;
    private Messager messager;
    private static final Set<String> DISALLOWED_ACCESS_LEVELS = Stream.of("PROTECTED", "PRIVATE", "NONE").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final Character REPLACEMENT_CHARACTER = Character.valueOf('_');
    static final Set<String> JAVA_LITERAL_WORDS = Collections.unmodifiableSet(Stream.of("true", "false", "null").collect(Collectors.toSet()));
    static final Set<String> JAVA_RESERVED_WORDS = Collections.unmodifiableSet(Stream.of("const", "goto", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while").collect(Collectors.toSet()));
    static final Set<Class<?>> JAVA_BUILT_IN_CLASSES = Collections.unmodifiableSet(Stream.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, BigDecimal.class, BigInteger.class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE).collect(Collectors.toSet()));
    private static final Set<String> JAVA_BUILT_IN_CLASS_WORDS = Collections.unmodifiableSet(JAVA_BUILT_IN_CLASSES.stream().map(Class::getSimpleName).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS = Collections.unmodifiableSet(Stream.of(JAVA_LITERAL_WORDS, JAVA_RESERVED_WORDS, JAVA_BUILT_IN_CLASS_WORDS).flatMap(Collection::stream).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS_LOWER_CASE = Collections.unmodifiableSet(JAVA_USED_WORDS.stream().map(String::toLowerCase).collect(Collectors.toSet()));

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.processingEnvironment = env;
        this.processingEnvironment.getElementUtils();
        this.processingEnvironment.getTypeUtils();
        this.messager = this.processingEnvironment.getMessager();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Redis OM Spring Field Generator Processor");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty() || roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> documentEntities = roundEnv.getElementsAnnotatedWith(Document.class);
        Set<? extends Element> hashEntities = roundEnv.getElementsAnnotatedWith(RedisHash.class);
        Set metamodelCandidates = Stream.of(documentEntities, hashEntities).flatMap(Collection::stream).collect(Collectors.toSet());
        metamodelCandidates.stream().filter(ae -> ae.getKind() == ElementKind.CLASS).forEach(ae -> {
            try {
                this.generateMetaModelClass((Element)ae);
            }
            catch (IOException ioe) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot generate metamodel class for " + ae.getClass().getName() + " because " + ioe.getMessage());
            }
        });
        return true;
    }

    void generateMetaModelClass(Element annotatedElement) throws IOException {
        String packageName;
        String qualifiedGenEntityName = annotatedElement.asType().toString() + "$";
        String entityName = ObjectUtils.shortName(annotatedElement.asType().toString());
        String genEntityName = entityName + "$";
        TypeName entity = TypeName.get((TypeMirror)annotatedElement.asType());
        Map getters = annotatedElement.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).filter(ee -> ee.getEnclosedElements().stream().noneMatch(eee -> eee.getKind() == ElementKind.PARAMETER)).collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity()));
        Set isGetters = getters.values().stream().map(Element::getSimpleName).map(Object::toString).filter(n -> n.startsWith(IS_PREFIX)).map(n -> n.substring(2)).map(ObjectUtils::lcfirst).collect(Collectors.toSet());
        Map enclosedFields = annotatedElement.getEnclosedElements().stream().filter(ee -> ee.getKind().isField() && !ee.getModifiers().contains((Object)Modifier.STATIC) && !ee.getModifiers().contains((Object)Modifier.FINAL)).collect(Collectors.toMap(Function.identity(), ee -> this.findGetter((Element)ee, getters, isGetters, entityName, this.lombokGetterAvailable(annotatedElement, (Element)ee))));
        PackageElement packageElement = this.processingEnvironment.getElementUtils().getPackageOf(annotatedElement);
        if (packageElement.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + entityName + " has an unnamed package.");
            packageName = "";
        } else {
            packageName = packageElement.getQualifiedName().toString();
        }
        ArrayList interceptors = new ArrayList();
        ArrayList fields = new ArrayList();
        ArrayList initCodeBlocks = new ArrayList();
        ArrayList nestedFieldsConstants = new ArrayList();
        ArrayList nestedFieldsConstantsInitCodeBlocks = new ArrayList();
        enclosedFields.forEach((field, getter) -> {
            Class targetCls;
            boolean fieldIsIndexed = field.getAnnotation(Searchable.class) != null || field.getAnnotation(Indexed.class) != null;
            String fieldName = field.getSimpleName().toString();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing " + entityName + "." + fieldName);
            TypeName entityField = TypeName.get((TypeMirror)field.asType());
            TypeMirror fieldType = field.asType();
            String fullTypeClassName = fieldType.toString();
            String cls = ObjectUtils.getTargetClassName(fullTypeClassName);
            if (field.asType().getKind().isPrimitive()) {
                Class primitive = ClassUtils.resolvePrimitiveClassName((String)cls);
                Class primitiveWrapper = ClassUtils.resolvePrimitiveIfNecessary((Class)primitive);
                entityField = TypeName.get((Type)primitiveWrapper);
                fullTypeClassName = entityField.toString();
                cls = ObjectUtils.getTargetClassName(fullTypeClassName);
            }
            Class<MetamodelField> targetInterceptor = MetamodelField.class;
            if (field.getAnnotation(Searchable.class) != null) {
                targetInterceptor = TextField.class;
            } else if (field.getAnnotation(Indexed.class) != null) {
                targetCls = null;
                try {
                    targetCls = ClassUtils.forName((String)cls, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could not resolve " + cls + " while checking for nested indexables");
                    List<Pair<FieldSpec, CodeBlock>> nestedFieldContants = this.extractNestedConstants((Element)field);
                    for (Pair<FieldSpec, CodeBlock> fieldConstants : nestedFieldContants) {
                        nestedFieldsConstants.add(fieldConstants.getFirst());
                        nestedFieldsConstantsInitCodeBlocks.add(fieldConstants.getSecond());
                    }
                }
                if (targetCls != null) {
                    if (CharSequence.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = TextTagField.class;
                    } else if (Number.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = NumericField.class;
                    } else if (targetCls == LocalDateTime.class || targetCls == LocalDate.class || targetCls == Date.class) {
                        targetInterceptor = DateField.class;
                    } else if (Set.class.isAssignableFrom(targetCls) || List.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = TagField.class;
                    } else if (targetCls == Point.class) {
                        targetInterceptor = GeoField.class;
                    } else if (targetCls == Boolean.class) {
                        targetInterceptor = BooleanField.class;
                    }
                }
            } else {
                try {
                    targetCls = ClassUtils.forName((String)cls, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                    if (CharSequence.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = NonIndexedTextField.class;
                    } else if (targetCls == Boolean.class) {
                        targetInterceptor = NonIndexedBooleanField.class;
                    } else if (Number.class.isAssignableFrom(targetCls) || targetCls == LocalDateTime.class || targetCls == LocalDate.class || targetCls == Date.class) {
                        targetInterceptor = NonIndexedNumericField.class;
                    } else if (Set.class.isAssignableFrom(targetCls) || List.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = NonIndexedTagField.class;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could not resolve " + cls);
                }
            }
            Triple<FieldSpec, FieldSpec, CodeBlock> fieldMetamodel = this.generateFieldMetamodel(entity, fieldName, entityField, targetInterceptor, fieldIsIndexed);
            fields.add(fieldMetamodel.getFirst());
            interceptors.add(fieldMetamodel.getSecond());
            initCodeBlocks.add(fieldMetamodel.getThird());
        });
        CodeBlock.Builder blockBuilder = CodeBlock.builder();
        blockBuilder.beginControlFlow("try", new Object[0]);
        for (FieldSpec fieldSpec : fields) {
            blockBuilder.addStatement("$L = $T.class.getDeclaredField(\"$L\")", new Object[]{fieldSpec.name, entity, fieldSpec.name});
        }
        for (CodeBlock initCodeBlock : initCodeBlocks) {
            blockBuilder.add(initCodeBlock);
        }
        for (CodeBlock nestedFieldsConstantsInitCodeBlock : nestedFieldsConstantsInitCodeBlocks) {
            blockBuilder.add(nestedFieldsConstantsInitCodeBlock);
        }
        blockBuilder.nextControlFlow("catch($T | $T e)", new Object[]{NoSuchFieldException.class, SecurityException.class});
        blockBuilder.addStatement("System.err.println(e.getMessage())", new Object[0]);
        blockBuilder.endControlFlow();
        CodeBlock staticBlock = blockBuilder.build();
        TypeSpec metaclass = TypeSpec.classBuilder((String)genEntityName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(fields).addFields(nestedFieldsConstants).addStaticBlock(staticBlock).addFields(interceptors).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)metaclass).build();
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedGenEntityName, new Element[0]);
        Writer writer = builderFile.openWriter();
        javaFile.writeTo((Appendable)writer);
        writer.close();
    }

    private List<Pair<FieldSpec, CodeBlock>> extractNestedConstants(Element fieldElement) {
        TypeMirror typeMirror = fieldElement.asType();
        DeclaredType asDeclaredType = (DeclaredType)typeMirror;
        Element entityField = asDeclaredType.asElement();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing constants for " + fieldElement + " of type " + entityField);
        String entityFieldName = fieldElement.toString();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "entityFieldName => " + entityFieldName);
        List<? extends Element> enclosed = entityField.getEnclosedElements();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "enclosed size() ==> " + enclosed.size());
        Map getters = entityField.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).filter(ee -> ee.getEnclosedElements().stream().noneMatch(eee -> eee.getKind() == ElementKind.PARAMETER)).collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity()));
        this.messager.printMessage(Diagnostic.Kind.NOTE, "getters size() ==> " + getters.size());
        Set isGetters = getters.values().stream().map(Element::getSimpleName).map(Object::toString).filter(n -> n.startsWith(IS_PREFIX)).map(n -> n.substring(2)).map(ObjectUtils::lcfirst).collect(Collectors.toSet());
        Map enclosedFields = entityField.getEnclosedElements().stream().filter(ee -> ee.getKind().isField() && !ee.getModifiers().contains((Object)Modifier.STATIC) && !ee.getModifiers().contains((Object)Modifier.FINAL)).collect(Collectors.toMap(Function.identity(), ee -> this.findGetter((Element)ee, getters, isGetters, entityFieldName, this.lombokGetterAvailable(entityField, (Element)ee))));
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Enclosed subfield size() ==> " + enclosedFields.size());
        ArrayList<Pair<FieldSpec, CodeBlock>> nestedFieldsConstants = new ArrayList<Pair<FieldSpec, CodeBlock>>();
        enclosedFields.forEach((field, getter) -> {
            boolean fieldIsIndexed;
            boolean bl = fieldIsIndexed = field.getAnnotation(Searchable.class) != null || field.getAnnotation(Indexed.class) != null;
            if (fieldIsIndexed) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing subfield ==> " + entityFieldName + "." + field.getSimpleName().toString());
                String subFieldName = field.getSimpleName().toString();
                Pair<FieldSpec, CodeBlock> nestedIndexedFieldDef = this.generateNestedIndexedFieldConstants(entityFieldName, subFieldName);
                nestedFieldsConstants.add(nestedIndexedFieldDef);
            }
        });
        return nestedFieldsConstants;
    }

    private boolean lombokGetterAvailable(Element classElement, Element fieldElement) {
        boolean globalEnable = this.isLombokAnnotated(classElement, "Data") || this.isLombokAnnotated(classElement, "Getter");
        boolean localEnable = this.isLombokAnnotated(fieldElement, "Getter");
        boolean disallowedAccessLevel = DISALLOWED_ACCESS_LEVELS.contains(this.getterAccessLevel(fieldElement).orElse("No access level defined"));
        return !disallowedAccessLevel && (globalEnable || localEnable);
    }

    private boolean isLombokAnnotated(Element annotatedElement, String lombokSimpleClassName) {
        try {
            String className = "lombok." + lombokSimpleClassName;
            Class<?> clazz = Class.forName(className);
            return annotatedElement.getAnnotation(clazz) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Optional<String> getterAccessLevel(Element fieldElement) {
        List<? extends AnnotationMirror> mirrors = fieldElement.getAnnotationMirrors();
        Map map = mirrors.stream().filter(am -> "lombok.Getter".equals(am.getAnnotationType().toString())).findFirst().map(AnnotationMirror::getElementValues).orElse(Collections.emptyMap());
        return map.values().stream().map(AnnotationValue::toString).map(v -> v.substring(v.lastIndexOf(46) + 1)).filter(this::isAccessLevel).findFirst();
    }

    private boolean isAccessLevel(String s) {
        Set validAccessLevels = Stream.of("PACKAGE", "NONE", "PRIVATE", "MODULE", "PROTECTED", "PUBLIC").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        return validAccessLevels.contains(s);
    }

    private String findGetter(Element field, Map<String, Element> getters, Set<String> isGetters, String entityName, boolean lombokGetterAvailable) {
        String standardJavaName;
        String fieldName = field.getSimpleName().toString();
        String getterPrefix = isGetters.contains(fieldName) ? IS_PREFIX : GET_PREFIX;
        String standardGetterName = getterPrefix + (standardJavaName = MetamodelGenerator.javaNameFromExternal(fieldName));
        Element standardGetter = getters.get(standardGetterName);
        if (standardGetter != null || lombokGetterAvailable) {
            return entityName + "::" + standardGetterName;
        }
        String lambdaName = ObjectUtils.lcfirst(entityName);
        if (!field.getModifiers().contains((Object)Modifier.PROTECTED) && !field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return lambdaName + " -> " + lambdaName + "." + fieldName;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Class " + entityName + " is not a proper JavaBean because " + field.getSimpleName().toString() + " has no standard getter.");
        return lambdaName + " -> {throw new " + IllegalJavaBeanException.class.getSimpleName() + "(" + entityName + ".class, \"" + fieldName + "\");}";
    }

    public static String staticField(String externalName) {
        Objects.requireNonNull(externalName);
        return ObjectUtils.toUnderscoreSeparated(MetamodelGenerator.javaNameFromExternal(externalName)).toUpperCase();
    }

    public static String javaNameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        return MetamodelGenerator.replaceIfIllegalJavaIdentifierCharacter(MetamodelGenerator.replaceIfJavaUsedWord(MetamodelGenerator.nameFromExternal(externalName)));
    }

    public static String nameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        String result = ObjectUtils.unQuote(externalName.trim());
        result = Stream.of(result.replaceAll("([\\p{Lu}]+)", "_$1").split("[^\\pL0-9]")).map(String::toLowerCase).map(ObjectUtils::ucfirst).collect(Collectors.joining());
        return result;
    }

    public static String replaceIfJavaUsedWord(String word) {
        Objects.requireNonNull(word);
        if (JAVA_USED_WORDS_LOWER_CASE.contains(word.toLowerCase())) {
            return word + "_";
        }
        return word;
    }

    private Triple<FieldSpec, FieldSpec, CodeBlock> generateFieldMetamodel(TypeName entity, String fieldName, TypeName entityField, Class<?> interceptorClass, boolean fieldIsIndexed) {
        String fieldAccessor = MetamodelGenerator.staticField(fieldName);
        FieldSpec objectField = FieldSpec.builder(Field.class, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        ParameterizedTypeName interceptor = ParameterizedTypeName.get((ClassName)ClassName.get(interceptorClass), (TypeName[])new TypeName[]{entity, entityField});
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)fieldAccessor, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T($L,$L)", new Object[]{fieldAccessor, interceptor, fieldName, fieldIsIndexed}).build();
        return Tuples.of(objectField, aField, aFieldInit);
    }

    private Pair<FieldSpec, CodeBlock> generateNestedIndexedFieldConstants(String fieldName, String subFieldName) {
        String staticConstantName = MetamodelGenerator.staticField(fieldName) + "_" + MetamodelGenerator.staticField(subFieldName);
        FieldSpec staticStringField = FieldSpec.builder(String.class, (String)staticConstantName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        CodeBlock staticStringFieldInit = CodeBlock.builder().addStatement("$L = new $T($L)", new Object[]{staticConstantName, String.class, String.format("\"%s_%s\"", fieldName, subFieldName)}).build();
        return Tuples.of(staticStringField, staticStringFieldInit);
    }

    public static String replaceIfIllegalJavaIdentifierCharacter(String word) {
        Objects.requireNonNull(word);
        if (word.isEmpty()) {
            return REPLACEMENT_CHARACTER.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(REPLACEMENT_CHARACTER).append(c);
                    continue;
                }
                sb.append(REPLACEMENT_CHARACTER);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append(REPLACEMENT_CHARACTER);
        }
        return sb.toString();
    }
}

