/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel.nonindexed;

import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.search.stream.actions.ArrayAppendAction;
import com.redis.om.spring.search.stream.actions.ArrayIndexOfAction;
import com.redis.om.spring.search.stream.actions.ArrayInsertAction;
import com.redis.om.spring.search.stream.actions.ArrayLengthAction;
import com.redis.om.spring.search.stream.actions.ArrayPopAction;
import com.redis.om.spring.search.stream.actions.ArrayTrimAction;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;

public class NonIndexedTagField<E, T>
extends MetamodelField<E, T> {
    public NonIndexedTagField(Field field, boolean indexed) {
        super(field, indexed);
    }

    public Consumer<? super E> add(Object value) {
        return new ArrayAppendAction(this.field, value);
    }

    public Consumer<? super E> insert(Object value, Long index) {
        return new ArrayInsertAction(this.field, value, index);
    }

    public Consumer<? super E> prepend(Object value) {
        return new ArrayInsertAction(this.field, value, 0L);
    }

    public ToLongFunction<? super E> length() {
        return new ArrayLengthAction(this.field);
    }

    public ToLongFunction<? super E> indexOf(Object element) {
        return new ArrayIndexOfAction(this.field, element);
    }

    public <R> ArrayPopAction<? super E, R> pop(Long index) {
        return new ArrayPopAction(this.field, index);
    }

    public <R> ArrayPopAction<? super E, R> pop() {
        return this.pop(-1L);
    }

    public <R> ArrayPopAction<? super E, R> removeFirst() {
        return this.pop(0L);
    }

    public <R> ArrayPopAction<? super E, R> removeLast() {
        return this.pop(-1L);
    }

    public <R> ArrayPopAction<? super E, R> remove(Long index) {
        return this.pop(index);
    }

    public Consumer<? super E> trimToRange(Long begin, Long end) {
        return new ArrayTrimAction(this.field, begin, end);
    }
}

