/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.json;

import com.google.gson.GsonBuilder;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.Command;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import com.redislabs.modules.rejson.JReJSON;
import com.redislabs.modules.rejson.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class JSONOperationsImpl<K>
implements JSONOperations<K> {
    RedisModulesClient client;
    GsonBuilder builder = GsonBuidlerFactory.getBuilder();

    public JSONOperationsImpl(RedisModulesClient client) {
        this.client = client;
    }

    @Override
    public Long del(K key, Path path) {
        return this.client.clientForJSON(this.builder).del(key.toString(), path);
    }

    @Override
    public <T> T get(K key) {
        return (T)this.client.clientForJSON(this.builder).get(key.toString());
    }

    @Override
    public <T> T get(K key, Class<T> clazz, Path ... paths) {
        return (T)this.client.clientForJSON(this.builder).get(key.toString(), clazz, paths);
    }

    @Override
    public <T> List<T> mget(Class<T> clazz, K ... keys) {
        String[] keysAsStrings = (String[])Arrays.asList(keys).stream().map(Object::toString).toArray(String[]::new);
        return this.client.clientForJSON(this.builder).mget(clazz, keysAsStrings);
    }

    @Override
    public <T> List<T> mget(Path path, Class<T> clazz, K ... keys) {
        String[] keysAsStrings = (String[])Arrays.asList(keys).stream().map(Object::toString).toArray(String[]::new);
        return this.client.clientForJSON(this.builder).mget(path, clazz, keysAsStrings);
    }

    @Override
    public void set(K key, Object object, JReJSON.ExistenceModifier flag) {
        this.client.clientForJSON(this.builder).set(key.toString(), object, flag);
    }

    @Override
    public void set(K key, Object object) {
        this.client.clientForJSON(this.builder).set(key.toString(), object);
    }

    @Override
    public void set(K key, Object object, Path path) {
        this.client.clientForJSON(this.builder).set(key.toString(), object, path);
    }

    @Override
    public void set(K key, Object object, JReJSON.ExistenceModifier flag, Path path) {
        this.client.clientForJSON(this.builder).set(key.toString(), object, flag, path);
    }

    @Override
    public Class<?> type(K key) {
        return this.client.clientForJSON(this.builder).type(key.toString());
    }

    @Override
    public Class<?> type(K key, Path path) {
        return this.client.clientForJSON(this.builder).type(key.toString(), path);
    }

    @Override
    public Long strAppend(K key, Path path, Object ... objects) {
        return this.client.clientForJSON(this.builder).strAppend(key.toString(), path, objects);
    }

    @Override
    public Long strLen(K key, Path path) {
        return this.client.clientForJSON(this.builder).strLen(key.toString(), path);
    }

    @Override
    public Long arrAppend(K key, Path path, Object ... objects) {
        return this.client.clientForJSON(this.builder).arrAppend(key.toString(), path, objects);
    }

    @Override
    public Long arrIndex(K key, Path path, Object scalar) {
        return this.client.clientForJSON(this.builder).arrIndex(key.toString(), path, scalar);
    }

    @Override
    public Long arrInsert(K key, Path path, Long index, Object ... objects) {
        return this.client.clientForJSON(this.builder).arrInsert(key.toString(), path, index, objects);
    }

    @Override
    public Long arrLen(K key, Path path) {
        return this.client.clientForJSON(this.builder).arrLen(key.toString(), path);
    }

    @Override
    public <T> T arrPop(K key, Class<T> clazz, Path path, Long index) {
        return (T)this.client.clientForJSON(this.builder).arrPop(key.toString(), clazz, path, index);
    }

    @Override
    public <T> T arrPop(K key, Class<T> clazz, Path path) {
        return (T)this.client.clientForJSON(this.builder).arrPop(key.toString(), clazz, path);
    }

    @Override
    public <T> T arrPop(K key, Class<T> clazz) {
        return (T)this.client.clientForJSON(this.builder).arrPop(key.toString(), clazz);
    }

    @Override
    public Long arrTrim(K key, Path path, Long start, Long stop) {
        return this.client.clientForJSON(this.builder).arrTrim(key.toString(), path, start, stop);
    }

    @Override
    public void toggle(K key, Path path) {
        this.client.clientForJSON(this.builder).toggle(key.toString(), path);
    }

    @Override
    public Long numIncrBy(K key, Path path, Long value) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key.toString()));
        args.add(SafeEncoder.encode((String)(path != null ? path.toString() : Path.ROOT_PATH.toString())));
        args.add(Protocol.toByteArray((long)value));
        Long results = -1L;
        try (Jedis conn = this.client.getJedis();){
            conn.getClient().sendCommand((ProtocolCommand)Command.JSON_NUMINCRBY, (byte[][])args.toArray((T[])new byte[args.size()][]));
            results = Long.parseLong(conn.getClient().getBulkReply());
        }
        return results;
    }
}

