/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.search;

import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.Command;
import com.redis.om.spring.ops.search.SearchOperations;
import io.redisearch.AggregationResult;
import io.redisearch.Document;
import io.redisearch.Query;
import io.redisearch.Schema;
import io.redisearch.SearchResult;
import io.redisearch.Suggestion;
import io.redisearch.aggregation.AggregationBuilder;
import io.redisearch.client.AddOptions;
import io.redisearch.client.Client;
import io.redisearch.client.ConfigOption;
import io.redisearch.client.SuggestionOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class SearchOperationsImpl<K>
implements SearchOperations<K> {
    io.redisearch.Client client;
    K index;

    public SearchOperationsImpl(K index, RedisModulesClient client) {
        this.index = index;
        this.client = client.clientForSearch(index.toString());
    }

    @Override
    public boolean createIndex(Schema schema, Client.IndexOptions options) {
        return this.client.createIndex(schema, options);
    }

    @Override
    public SearchResult search(Query q) {
        return this.client.search(q);
    }

    @Override
    public SearchResult[] searchBatch(Query ... queries) {
        return this.client.searchBatch(queries);
    }

    @Override
    public SearchResult search(Query q, boolean decode) {
        return this.client.search(q, decode);
    }

    @Override
    public AggregationResult aggregate(AggregationBuilder q) {
        return this.client.aggregate(q);
    }

    @Override
    public boolean cursorDelete(long cursorId) {
        return this.client.cursorDelete(cursorId);
    }

    @Override
    public AggregationResult cursorRead(long cursorId, int count) {
        return this.client.cursorRead(cursorId, count);
    }

    @Override
    public String explain(Query q) {
        return this.client.explain(q);
    }

    @Override
    public boolean addDocument(Document doc, AddOptions options) {
        return this.client.addDocument(doc, options);
    }

    @Override
    public boolean addDocument(String docId, double score, Map<String, Object> fields, boolean noSave, boolean replace, byte[] payload) {
        return this.client.addDocument(docId, score, fields, noSave, replace, payload);
    }

    @Override
    public boolean addDocument(Document doc) {
        return this.client.addDocument(doc);
    }

    @Override
    public boolean[] addDocuments(Document ... docs) {
        return this.client.addDocuments(docs);
    }

    @Override
    public boolean[] addDocuments(AddOptions options, Document ... docs) {
        return this.client.addDocuments(options, docs);
    }

    @Override
    public boolean addDocument(String docId, double score, Map<String, Object> fields) {
        return this.client.addDocument(docId, score, fields);
    }

    @Override
    public boolean addDocument(String docId, Map<String, Object> fields) {
        return this.client.addDocument(docId, fields);
    }

    @Override
    public boolean replaceDocument(String docId, double score, Map<String, Object> fields) {
        return this.client.replaceDocument(docId, score, fields);
    }

    @Override
    public boolean replaceDocument(String docId, double score, Map<String, Object> fields, String filter) {
        return this.client.replaceDocument(docId, score, fields, filter);
    }

    @Override
    public boolean updateDocument(String docId, double score, Map<String, Object> fields) {
        return this.client.updateDocument(docId, score, fields);
    }

    @Override
    public boolean updateDocument(String docId, double score, Map<String, Object> fields, String filter) {
        return this.client.updateDocument(docId, score, fields, filter);
    }

    @Override
    public Map<String, Object> getInfo() {
        return this.client.getInfo();
    }

    @Override
    public boolean deleteDocument(String docId) {
        return this.client.deleteDocument(docId);
    }

    @Override
    public boolean[] deleteDocuments(boolean deleteDocuments, String ... docIds) {
        return this.client.deleteDocuments(deleteDocuments, docIds);
    }

    @Override
    public boolean deleteDocument(String docId, boolean deleteDocument) {
        return this.client.deleteDocument(docId, deleteDocument);
    }

    @Override
    public Document getDocument(String docId) {
        return this.client.getDocument(docId);
    }

    @Override
    public Document getDocument(String docId, boolean decode) {
        return this.client.getDocument(docId, decode);
    }

    @Override
    public List<Document> getDocuments(String ... docIds) {
        return this.client.getDocuments(docIds);
    }

    @Override
    public List<Document> getDocuments(boolean decode, String ... docIds) {
        return this.client.getDocuments(decode, docIds);
    }

    @Override
    public boolean dropIndex() {
        return this.client.dropIndex();
    }

    @Override
    public boolean dropIndex(boolean missingOk) {
        return this.client.dropIndex(missingOk);
    }

    @Override
    public Long addSuggestion(Suggestion suggestion, boolean increment) {
        return this.client.addSuggestion(suggestion, increment);
    }

    @Override
    public List<Suggestion> getSuggestion(String prefix, SuggestionOptions suggestionOptions) {
        return this.client.getSuggestion(prefix, suggestionOptions);
    }

    @Override
    public Long deleteSuggestion(String entry) {
        return this.client.deleteSuggestion(entry);
    }

    @Override
    public Long getSuggestionLength() {
        return this.client.getSuggestionLength();
    }

    @Override
    public boolean alterIndex(Schema.Field ... fields) {
        return this.client.alterIndex(fields);
    }

    @Override
    public boolean setConfig(ConfigOption option, String value) {
        return this.client.setConfig(option, value);
    }

    @Override
    public String getConfig(ConfigOption option) {
        return this.client.getConfig(option);
    }

    @Override
    public Map<String, String> getAllConfig() {
        return this.client.getAllConfig();
    }

    @Override
    public boolean addAlias(String name) {
        return this.client.addAlias(name);
    }

    @Override
    public boolean updateAlias(String name) {
        return this.client.updateAlias(name);
    }

    @Override
    public boolean deleteAlias(String name) {
        return this.client.deleteAlias(name);
    }

    @Override
    public boolean updateSynonym(String synonymGroupId, String ... terms) {
        return this.client.updateSynonym(synonymGroupId, terms);
    }

    @Override
    public Map<String, List<String>> dumpSynonym() {
        return this.client.dumpSynonym();
    }

    @Override
    public List<String> tagVals(String field) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)this.index.toString()));
        args.add(SafeEncoder.encode((String)field));
        List<String> result = List.of();
        try (Jedis conn = this.client.connection();){
            Client bc = conn.getClient();
            bc.sendCommand((ProtocolCommand)Command.FT_TAGVALS, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List resp = bc.getObjectMultiBulkReply();
            result = resp.stream().map(x -> x instanceof Long ? String.valueOf(x) : SafeEncoder.encode((byte[])((byte[])x))).collect(Collectors.toList());
        }
        return result;
    }
}

