/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query;

import com.google.gson.Gson;
import com.redis.om.spring.annotations.Aggregation;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.Query;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.RediSearchQueryType;
import com.redis.om.spring.repository.query.autocomplete.AutoCompleteQueryExecutor;
import com.redis.om.spring.repository.query.bloom.BloomQueryExecutor;
import com.redis.om.spring.repository.query.clause.QueryClause;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.AggregationResult;
import io.redisearch.Document;
import io.redisearch.Schema;
import io.redisearch.SearchResult;
import io.redisearch.aggregation.AggregationBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Point;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Pair;
import org.springframework.util.ClassUtils;

public class RediSearchQuery
implements RepositoryQuery {
    private static final Log logger = LogFactory.getLog(RediSearchQuery.class);
    private final QueryMethod queryMethod;
    private final String searchIndex;
    private RediSearchQueryType type;
    private static final Gson gson = GsonBuidlerFactory.getBuilder().create();
    private String value;
    private RepositoryMetadata metadata;
    private String[] returnFields;
    private String[] load;
    private Map<String, String> apply;
    private List<List<Pair<String, QueryClause>>> queryOrParts = new ArrayList<List<Pair<String, QueryClause>>>();
    private List<String> paramNames = new ArrayList<String>();
    private Class<?> domainType;
    private RedisModulesOperations<String> modulesOperations;
    private KeyValueOperations keyValueOperations;
    private boolean isANDQuery = false;
    private BloomQueryExecutor bloomQueryExecutor;
    private AutoCompleteQueryExecutor autoCompleteQueryExecutor;

    public RediSearchQuery(QueryMethod queryMethod, RepositoryMetadata metadata, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        logger.info((Object)String.format("Creating %s query method", queryMethod.getName()));
        this.keyValueOperations = keyValueOperations;
        this.modulesOperations = rmo;
        this.queryMethod = queryMethod;
        this.searchIndex = this.queryMethod.getEntityInformation().getJavaType().getName() + "Idx";
        this.metadata = metadata;
        this.domainType = this.queryMethod.getEntityInformation().getJavaType();
        this.bloomQueryExecutor = new BloomQueryExecutor(this, this.modulesOperations);
        this.autoCompleteQueryExecutor = new AutoCompleteQueryExecutor(this, this.modulesOperations);
        Class repoClass = metadata.getRepositoryInterface();
        Object[] params = (Class[])queryMethod.getParameters().stream().map(Parameter::getType).toArray(Class[]::new);
        try {
            Method method = repoClass.getMethod(queryMethod.getName(), (Class<?>[])params);
            if (method.isAnnotationPresent(Query.class)) {
                Query queryAnnotation = method.getAnnotation(Query.class);
                this.type = RediSearchQueryType.QUERY;
                this.value = queryAnnotation.value();
                this.returnFields = queryAnnotation.returnFields();
            } else if (method.isAnnotationPresent(Aggregation.class)) {
                Aggregation aggregation = method.getAnnotation(Aggregation.class);
                this.type = RediSearchQueryType.AGGREGATION;
                this.value = aggregation.value();
                this.load = aggregation.load();
                this.apply = this.splitApplyArguments(aggregation.apply());
            } else if (queryMethod.getName().equalsIgnoreCase("search")) {
                this.type = RediSearchQueryType.QUERY;
                ArrayList<Pair> orPartParts = new ArrayList<Pair>();
                orPartParts.add(Pair.of((Object)"__ALL__", (Object)((Object)QueryClause.FullText_ALL)));
                this.queryOrParts.add(orPartParts);
                this.returnFields = new String[0];
            } else if (queryMethod.getName().startsWith("getAll")) {
                this.type = RediSearchQueryType.TAGVALS;
                this.value = ObjectUtils.lcfirst(queryMethod.getName().substring(6, queryMethod.getName().length()));
            } else if (queryMethod.getName().startsWith("autoComplete")) {
                this.type = RediSearchQueryType.AUTOCOMPLETE;
            } else {
                this.isANDQuery = QueryClause.hasContainingAllClause(queryMethod.getName());
                String methodName = this.isANDQuery ? QueryClause.getPostProcessMethodName(queryMethod.getName()) : queryMethod.getName();
                PartTree pt = new PartTree(methodName, metadata.getDomainType());
                this.processPartTree(pt);
                this.type = RediSearchQueryType.QUERY;
                this.returnFields = new String[0];
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug((Object)String.format("Could not resolved query method %s(%s): %s", queryMethod.getName(), Arrays.toString(params), e.getMessage()));
        }
    }

    private void processPartTree(PartTree pt) {
        pt.stream().forEach(orPart -> {
            ArrayList orPartParts = new ArrayList();
            orPart.iterator().forEachRemaining(part -> {
                PropertyPath propertyPath = part.getProperty();
                List<PropertyPath> path = StreamSupport.stream(propertyPath.spliterator(), false).collect(Collectors.toList());
                orPartParts.addAll(this.extractQueryFields(this.domainType, (Part)part, path));
            });
            this.queryOrParts.add(orPartParts);
        });
    }

    private List<Pair<String, QueryClause>> extractQueryFields(Class<?> type, Part part, List<PropertyPath> path) {
        return this.extractQueryFields(type, part, path, 0);
    }

    private List<Pair<String, QueryClause>> extractQueryFields(Class<?> type, Part part, List<PropertyPath> path, int level) {
        ArrayList<Pair<String, QueryClause>> qf = new ArrayList<Pair<String, QueryClause>>();
        String property = path.get(level).getSegment();
        String key = part.getProperty().toDotPath().replace(".", "_");
        try {
            Field field = type.getDeclaredField(property);
            if (field.isAnnotationPresent(TextIndexed.class)) {
                TextIndexed indexAnnotation = field.getAnnotation(TextIndexed.class);
                String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.FullText, part.getType()))));
            } else if (field.isAnnotationPresent(Searchable.class)) {
                Searchable indexAnnotation = field.getAnnotation(Searchable.class);
                String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.FullText, part.getType()))));
            } else if (field.isAnnotationPresent(TagIndexed.class)) {
                TagIndexed indexAnnotation = field.getAnnotation(TagIndexed.class);
                String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Tag, part.getType()))));
            } else if (field.isAnnotationPresent(GeoIndexed.class)) {
                GeoIndexed indexAnnotation = field.getAnnotation(GeoIndexed.class);
                String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Geo, part.getType()))));
            } else if (field.isAnnotationPresent(NumericIndexed.class)) {
                NumericIndexed indexAnnotation = field.getAnnotation(NumericIndexed.class);
                String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Numeric, part.getType()))));
            } else if (field.isAnnotationPresent(Indexed.class)) {
                Indexed indexAnnotation = field.getAnnotation(Indexed.class);
                String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
                Class fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
                if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class) {
                    qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Tag, part.getType()))));
                } else if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class) {
                    qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Numeric, part.getType()))));
                } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                    if (this.isANDQuery) {
                        qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.Tag_CONTAINING_ALL)));
                    } else {
                        qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Tag, part.getType()))));
                    }
                } else if (fieldType == Point.class) {
                    qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.Geo, part.getType()))));
                } else {
                    qf.addAll(this.extractQueryFields(fieldType, part, path, level + 1));
                }
            }
        }
        catch (NoSuchFieldException e) {
            logger.info((Object)String.format("Did not find a field named %s", key));
        }
        return qf;
    }

    public Object execute(Object[] parameters) {
        Optional<String> maybeBloomFilter = this.bloomQueryExecutor.getBloomFilter();
        if (maybeBloomFilter.isPresent()) {
            return this.bloomQueryExecutor.executeBloomQuery(parameters, maybeBloomFilter.get());
        }
        if (this.type == RediSearchQueryType.QUERY) {
            return this.executeQuery(parameters);
        }
        if (this.type == RediSearchQueryType.AGGREGATION) {
            return this.executeAggregation(parameters);
        }
        if (this.type == RediSearchQueryType.TAGVALS) {
            return this.executeFtTagVals();
        }
        if (this.type == RediSearchQueryType.AUTOCOMPLETE) {
            Optional<String> maybeAutoCompleteDictionaryKey = this.autoCompleteQueryExecutor.getAutoCompleteDictionaryKey();
            return maybeAutoCompleteDictionaryKey.isPresent() ? this.autoCompleteQueryExecutor.executeAutoCompleteQuery(parameters, maybeAutoCompleteDictionaryKey.get()) : null;
        }
        return null;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private Object executeQuery(Object[] parameters) {
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(this.searchIndex);
        String preparedQuery = this.prepareQuery(parameters);
        io.redisearch.Query query = new io.redisearch.Query(preparedQuery);
        query.returnFields(this.returnFields);
        Optional<Object> maybePageable = Optional.empty();
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable;
            maybePageable = Arrays.stream(parameters).filter(Pageable.class::isInstance).map(Pageable.class::cast).findFirst();
            if (maybePageable.isPresent() && !(pageable = (Pageable)maybePageable.get()).isUnpaged()) {
                query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
                if (pageable.getSort() != null) {
                    for (Sort.Order order : pageable.getSort()) {
                        query.setSortBy(order.getProperty(), order.isAscending());
                    }
                }
            }
        }
        if (this.queryMethod.isCollectionQuery() && !this.queryMethod.getParameters().isEmpty()) {
            List emptyCollectionParams = Arrays.asList(parameters).stream().filter(Collection.class::isInstance).map(p -> (Collection)p).filter(Collection::isEmpty).collect(Collectors.toList());
            if (!emptyCollectionParams.isEmpty()) {
                return Collections.emptyList();
            }
        }
        SearchResult searchResult = ops.search(query);
        Object result = null;
        if (this.queryMethod.getReturnedObjectType() == SearchResult.class) {
            result = searchResult;
        } else if (this.queryMethod.isPageQuery()) {
            List content = searchResult.docs.stream().map(d -> gson.fromJson(d.get("$").toString(), this.queryMethod.getReturnedObjectType())).collect(Collectors.toList());
            if (maybePageable.isPresent()) {
                Pageable pageable = (Pageable)maybePageable.get();
                result = new PageImpl(content, pageable, searchResult.totalResults);
            }
        } else if (this.queryMethod.isQueryForEntity() && !this.queryMethod.isCollectionQuery()) {
            if (!searchResult.docs.isEmpty()) {
                String jsonResult = ((Document)searchResult.docs.get(0)).get("$").toString();
                result = gson.fromJson(jsonResult, this.queryMethod.getReturnedObjectType());
            } else {
                result = null;
            }
        } else if (this.queryMethod.isQueryForEntity() && this.queryMethod.isCollectionQuery()) {
            result = searchResult.docs.stream().map(d -> gson.fromJson(d.get("$").toString(), this.queryMethod.getReturnedObjectType())).collect(Collectors.toList());
        }
        return result;
    }

    private Object executeAggregation(Object[] parameters) {
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(this.searchIndex);
        AggregationBuilder aggregation = new AggregationBuilder(this.value).load(this.load);
        for (Map.Entry<String, String> entry : this.apply.entrySet()) {
            aggregation.apply(entry.getKey(), entry.getValue());
        }
        AggregationResult aggregationResult = ops.aggregate(aggregation);
        Object result = null;
        if (this.queryMethod.getReturnedObjectType() == AggregationResult.class) {
            result = aggregationResult;
        } else if (this.queryMethod.isCollectionQuery()) {
            result = Collections.emptyList();
        }
        return result;
    }

    private Object executeFtTagVals() {
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(this.searchIndex);
        return ops.tagVals(this.value);
    }

    private String prepareQuery(Object[] parameters) {
        logger.debug((Object)String.format("parameters: %s", Arrays.toString(parameters)));
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(parameters));
        StringBuilder preparedQuery = new StringBuilder();
        boolean multipleOrParts = this.queryOrParts.size() > 1;
        logger.debug((Object)String.format("queryOrParts: %s", this.queryOrParts.size()));
        if (!this.queryOrParts.isEmpty()) {
            preparedQuery.append(this.queryOrParts.stream().map(qop -> {
                Object orPart = multipleOrParts ? "(" : "";
                orPart = (String)orPart + qop.stream().map(fieldClauses -> {
                    String fieldName = (String)fieldClauses.getFirst();
                    QueryClause queryClause = (QueryClause)((Object)((Object)((Object)fieldClauses.getSecond())));
                    int paramsCnt = queryClause.getValue().getNumberOfArguments();
                    Object[] ps = params.subList(0, paramsCnt).toArray();
                    params.subList(0, paramsCnt).clear();
                    return queryClause.prepareQuery(fieldName, ps);
                }).collect(Collectors.joining(" "));
                orPart = (String)orPart + (multipleOrParts ? ")" : "");
                return orPart;
            }).collect(Collectors.joining(" | ")));
        } else {
            Iterator iterator = this.queryMethod.getParameters().iterator();
            int index = 0;
            if (this.value != null && !this.value.isBlank()) {
                preparedQuery.append(this.value);
            }
            while (iterator.hasNext()) {
                String key;
                Parameter p = (Parameter)iterator.next();
                Optional maybeKey = p.getName();
                String string = maybeKey.isPresent() ? (String)maybeKey.get() : (key = this.paramNames.size() > index ? this.paramNames.get(index) : "");
                if (!key.isBlank()) {
                    String v = "";
                    if (parameters[index] instanceof Collection) {
                        Collection c = (Collection)parameters[index];
                        v = c.stream().map(Object::toString).collect(Collectors.joining(" | "));
                    } else {
                        v = parameters[index].toString();
                    }
                    preparedQuery = new StringBuilder(preparedQuery.toString().replace("$" + key, v));
                }
                ++index;
            }
        }
        logger.debug((Object)String.format("query: %s", preparedQuery.toString()));
        return preparedQuery.toString();
    }

    private Map<String, String> splitApplyArguments(String ... entries) {
        return IntStream.range(0, entries.length / 2).map(i -> i * 2).collect(HashMap::new, (m, i) -> m.put(entries[i], entries[i + 1]), Map::putAll);
    }
}

