/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query.autocomplete;

import io.redisearch.client.SuggestionOptions;

public class AutoCompleteOptions {
    private Boolean fuzzy = false;
    private Integer limit = null;
    private Boolean withPayload = false;
    private Boolean withScore = false;

    public static AutoCompleteOptions get() {
        return new AutoCompleteOptions();
    }

    public AutoCompleteOptions withPayload() {
        this.setWithPayload(true);
        return this;
    }

    public AutoCompleteOptions withScore() {
        this.setWithScore(true);
        return this;
    }

    public AutoCompleteOptions limit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public AutoCompleteOptions fuzzy() {
        this.setFuzzy(true);
        return this;
    }

    public SuggestionOptions toSuggestionOptions() {
        SuggestionOptions.Builder builder = SuggestionOptions.builder();
        if (Boolean.TRUE.equals(this.fuzzy)) {
            builder = builder.fuzzy();
        }
        if (Boolean.TRUE.equals(this.withPayload)) {
            builder = builder.with(SuggestionOptions.With.PAYLOAD);
        }
        if (Boolean.TRUE.equals(this.withScore)) {
            builder = builder.with(SuggestionOptions.With.SCORES);
        }
        if (this.limit != null) {
            builder = builder.max(this.limit.intValue());
        }
        return builder.build();
    }

    public void setFuzzy(Boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setWithPayload(Boolean withPayload) {
        this.withPayload = withPayload;
    }

    public void setWithScore(Boolean withScore) {
        this.withScore = withScore;
    }
}

