/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query.clause;

import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.repository.query.clause.QueryClauseTemplate;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.repository.query.parser.Part;

public enum QueryClause {
    FullText_ALL(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.SIMPLE_PROPERTY, "$param_0", 1)),
    FullText_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.SIMPLE_PROPERTY, "@$field:$param_0", 1)),
    FullText_NEGATING_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.SIMPLE_PROPERTY, "-@$field:$param_0", 1)),
    FullText_STARTING_WITH(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.STARTING_WITH, "@$field:$param_0*", 1)),
    FullText_ENDING_WITH(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.ENDING_WITH, "@$field:$param_0", 1)),
    FullText_LIKE(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.LIKE, "@$field:%%%$param_0%%%", 1)),
    FullText_NOT_LIKE(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.NOT_LIKE, "-@$field:%%%$param_0%%%", 1)),
    FullText_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.CONTAINING, "@$field:%%%$param_0%%%", 1)),
    FullText_NOT_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.FullText, Part.Type.NOT_CONTAINING, "-@$field:%%%$param_0%%%", 1)),
    Numeric_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.SIMPLE_PROPERTY, "@$field:[$param_0 $param_0]", 1)),
    Numeric_NEGATING_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.SIMPLE_PROPERTY, "@$field:-[$param_0 $param_0]", 1)),
    Numeric_BETWEEN(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.BETWEEN, "@$field:[$param_0 $param_1]", 2)),
    Numeric_LESS_THAN(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.LESS_THAN, "@$field:[-inf ($param_0]", 1)),
    Numeric_LESS_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.LESS_THAN_EQUAL, "@$field:[-inf $param_0]", 1)),
    Numeric_GREATER_THAN(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.GREATER_THAN, "@$field:[($param_0 inf]", 1)),
    Numeric_GREATER_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.GREATER_THAN_EQUAL, "@$field:[$param_0 inf]", 1)),
    Numeric_BEFORE(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.BEFORE, "@$field:[-inf ($param_0]", 1)),
    Numeric_AFTER(QueryClauseTemplate.of(Schema.FieldType.Numeric, Part.Type.AFTER, "@$field:[($param_0 inf]", 1)),
    Geo_NEAR(QueryClauseTemplate.of(Schema.FieldType.Geo, Part.Type.NEAR, "@$field:[$param_0 $param_1 $param_2]", 2)),
    Tag_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.Tag, Part.Type.SIMPLE_PROPERTY, "@$field:{$param_0}", 1)),
    Tag_NOT_IN(QueryClauseTemplate.of(Schema.FieldType.Tag, Part.Type.NOT_IN, "@$field:$param_0", 1)),
    Tag_IN(QueryClauseTemplate.of(Schema.FieldType.Tag, Part.Type.IN, "@$field:$param_0", 1)),
    Tag_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.Tag, Part.Type.CONTAINING, "@$field:$param_0", 1)),
    Tag_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.Tag, Part.Type.CONTAINING, "$param_0", 1));

    private final QueryClauseTemplate value;
    private final MappingRedisOMConverter converter = new MappingRedisOMConverter();
    public static final Map<String, String> methodNameMap;
    public static final Pattern CONTAINING_ALL_PATTERN;

    private QueryClause(QueryClauseTemplate value) {
        this.value = value;
    }

    public QueryClauseTemplate getValue() {
        return this.value;
    }

    public String prepareQuery(String field, Object ... params) {
        String prepared = field.equalsIgnoreCase("__ALL__") ? this.value.getQuerySegmentTemplate() : this.value.getQuerySegmentTemplate().replace("$field", field);
        Iterator<Object> iter = Arrays.asList(params).iterator();
        int i = 0;
        block8: while (iter.hasNext()) {
            String paramClass;
            Object param = iter.next();
            switch (paramClass = param.getClass().getName()) {
                case "org.springframework.data.geo.Point": {
                    Point point = (Point)param;
                    prepared = prepared.replace("$param_" + i++, Double.toString(point.getX()));
                    prepared = prepared.replace("$param_" + i++, Double.toString(point.getY()));
                    continue block8;
                }
                case "org.springframework.data.geo.Distance": {
                    Distance distance = (Distance)param;
                    prepared = prepared.replace("$param_" + i++, ObjectUtils.getDistanceAsRedisString(distance));
                    continue block8;
                }
            }
            if (param instanceof Collection) {
                Collection c = (Collection)param;
                String value = "";
                value = this == Tag_CONTAINING_ALL ? c.stream().map(n -> "@" + field + ":{" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "}").collect(Collectors.joining(" ")) : c.stream().map(n -> QueryUtils.escape(ObjectUtils.asString(n, this.converter), true)).collect(Collectors.joining("|"));
                prepared = prepared.replace("$param_" + i++, value);
                continue;
            }
            if (this.value.getIndexType() == Schema.FieldType.FullText) {
                prepared = prepared.replace("$param_" + i++, param.toString());
                continue;
            }
            prepared = prepared.replace("$param_" + i++, QueryUtils.escape(ObjectUtils.asString(param, this.converter)));
        }
        return prepared;
    }

    public static QueryClause get(Schema.FieldType fieldType, Part.Type partType) {
        try {
            return QueryClause.valueOf(fieldType.toString() + "_" + partType.name());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Tag_SIMPLE_PROPERTY;
        }
    }

    public static boolean hasContainingAllClause(String methodName) {
        return CONTAINING_ALL_PATTERN.matcher(methodName).find();
    }

    public static String getPostProcessMethodName(String methodName) {
        if (QueryClause.hasContainingAllClause(methodName)) {
            Optional<String> maybeMatchSubstring = CONTAINING_ALL_PATTERN.matcher(methodName).results().map(mr -> mr.group(1)).findFirst();
            if (maybeMatchSubstring.isPresent()) {
                String matchSubstring = maybeMatchSubstring.get();
                return methodName.replace(matchSubstring, methodNameMap.get(matchSubstring));
            }
            return methodName;
        }
        return methodName;
    }

    static {
        methodNameMap = Map.of("IsContainingAll", "IsContaining", "ContainingAll", "Containing", "ContainsAll", "Contains");
        CONTAINING_ALL_PATTERN = Pattern.compile("(IsContainingAll|ContainingAll|ContainsAll)");
    }
}

