/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redis.om.spring.KeyspaceToIndexMap;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.repository.RedisDocumentRepository;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import com.redis.om.spring.util.ObjectUtils;
import com.redislabs.modules.rejson.Path;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class SimpleRedisDocumentRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisDocumentRepository<T, ID> {
    GsonBuilder gsonBuilder = GsonBuidlerFactory.getBuilder();
    private final Gson gson;
    protected RedisModulesOperations<String> modulesOperations;
    protected EntityInformation<T, ID> metadata;
    protected KeyValueOperations operations;
    protected KeyspaceToIndexMap keyspaceToIndexMap;
    protected MappingRedisOMConverter mappingConverter;
    private final ULIDIdentifierGenerator generator;
    private RedisMappingContext mappingContext;

    public SimpleRedisDocumentRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, KeyspaceToIndexMap keyspaceToIndexMap, RedisMappingContext mappingContext) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.keyspaceToIndexMap = keyspaceToIndexMap;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl(this.modulesOperations.getTemplate()));
        this.generator = ULIDIdentifierGenerator.INSTANCE;
        this.gson = this.gsonBuilder.create();
        this.mappingContext = mappingContext;
    }

    @Override
    public Iterable<ID> getIds() {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        SetOperations setOps = template.opsForSet();
        return new ArrayList(setOps.members((Object)this.metadata.getJavaType().getName()));
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        SetOperations setOps = template.opsForSet();
        ArrayList ids = new ArrayList(setOps.members((Object)this.metadata.getJavaType().getName()));
        int fromIndex = Math.toIntExact(pageable.getOffset());
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void deleteById(ID id, Path path) {
        Long deletedCount = this.modulesOperations.opsForJSON().del(this.getKey(id), path);
        if (deletedCount > 0L && path.equals((Object)Path.ROOT_PATH)) {
            RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
            SetOperations setOps = template.opsForSet();
            setOps.remove((Object)org.apache.commons.lang3.StringUtils.chop((String)this.getKeyspace()), new Object[]{id});
        }
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        this.modulesOperations.opsForJSON().set(this.getKey(this.metadata.getId(entity)), value, Path.of((String)("$." + field.getField().getName())));
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(Path.of((String)("$." + field.getField().getName())), List.class, (String[])keys).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Long getExpiration(ID id) {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        return template.getExpire((Object)this.getKey(id));
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        try (Jedis jedis = this.modulesOperations.getClient().getJedis();){
            Pipeline pipeline = jedis.pipelined();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : (String)keyValueEntity.getPropertyAccessor(entity).getProperty(keyValueEntity.getIdProperty());
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, id.toString());
                this.processAuditAnnotations(objectKey, entity, isNew);
                Optional<Long> maybeTtl = this.getTTLForEntity(entity);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                pipeline.sadd(rdo.getKeyspace(), new String[]{id.toString()});
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(objectKey);
                args.add(SafeEncoder.encode((String)Path.ROOT_PATH.toString()));
                args.add(SafeEncoder.encode((String)this.gson.toJson(entity)));
                pipeline.sendCommand((ProtocolCommand)Command.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                if (maybeTtl.isPresent()) {
                    pipeline.expire(objectKey, maybeTtl.get().longValue());
                }
                saved.add(entity);
            }
            pipeline.sync();
        }
        return saved;
    }

    private String getKeyspace() {
        return this.keyspaceToIndexMap.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    private String getKey(Object id) {
        return this.getKeyspace() + id.toString();
    }

    public byte[] createKey(String keyspace, String id) {
        return this.mappingConverter.toBytes(keyspace + ":" + id);
    }

    private void processAuditAnnotations(byte[] redisKey, Object item, boolean isNew) {
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> SimpleRedisDocumentRepository.lambda$processAuditAnnotations$1((PropertyAccessor)accessor, arg_0));
        }
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        block7: {
            KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
            if (keyspaceConfig.hasSettingsFor(entity.getClass())) {
                KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entity.getClass());
                if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                    try {
                        Field fld = ReflectionUtils.findField(entity.getClass(), (String)settings.getTimeToLivePropertyName());
                        Method ttlGetter = ObjectUtils.getGetterForField(entity.getClass(), fld);
                        Long ttlPropertyValue = ((Number)ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity)).longValue();
                        ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity);
                        if (ttlPropertyValue != null) {
                            TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                            if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                                return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                            }
                            return Optional.of(ttlPropertyValue);
                        }
                        break block7;
                    }
                    catch (IllegalArgumentException | SecurityException e) {
                        return Optional.empty();
                    }
                }
                if (settings != null && settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                    return Optional.of(settings.getTimeToLive());
                }
            }
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$1(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }

    private static enum Command implements ProtocolCommand
    {
        SET("JSON.SET");

        private final byte[] raw;

        private Command(String alt) {
            this.raw = SafeEncoder.encode((String)alt);
        }

        public byte[] getRaw() {
            return this.raw;
        }
    }
}

