/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.redis.om.spring.KeyspaceToIndexMap;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.RedisEnhancedRepository;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.Query;
import io.redisearch.SearchResult;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class SimpleRedisEnhancedRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisEnhancedRepository<T, ID> {
    private static final Integer MAX_LIMIT = 10000;
    protected RedisModulesOperations<String> modulesOperations;
    protected EntityInformation<T, ID> metadata;
    protected KeyValueOperations operations;
    protected KeyspaceToIndexMap keyspaceToIndexMap;
    protected MappingRedisOMConverter mappingConverter;
    protected RedisEnhancedKeyValueAdapter enhancedKeyValueAdapter;
    private final ULIDIdentifierGenerator generator;

    public SimpleRedisEnhancedRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, KeyspaceToIndexMap keyspaceToIndexMap) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.keyspaceToIndexMap = keyspaceToIndexMap;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl(this.modulesOperations.getTemplate()));
        this.enhancedKeyValueAdapter = new RedisEnhancedKeyValueAdapter((RedisOperations<?, ?>)rmo.getTemplate(), rmo, keyspaceToIndexMap);
        this.generator = ULIDIdentifierGenerator.INSTANCE;
    }

    @Override
    public Iterable<ID> getIds() {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        SetOperations setOps = template.opsForSet();
        return new ArrayList(setOps.members((Object)this.metadata.getJavaType().getName()));
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        SetOperations setOps = template.opsForSet();
        ArrayList ids = new ArrayList(setOps.members((Object)this.metadata.getJavaType().getName()));
        int fromIndex = Math.toIntExact(pageable.getOffset());
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        PartialUpdate update = new PartialUpdate((Object)this.metadata.getId(entity).toString(), this.metadata.getJavaType()).set(field.getField().getName(), value);
        this.enhancedKeyValueAdapter.update(update);
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        List keys = StreamSupport.stream(ids.spliterator(), false).map(this::getKey).collect(Collectors.toList());
        return keys.stream().map(key -> template.opsForHash().get(key, (Object)field.getField().getName())).collect(Collectors.toList());
    }

    @Override
    public Long getExpiration(ID id) {
        RedisTemplate<?, ?> template = this.modulesOperations.getTemplate();
        return template.getExpire((Object)this.getKey(id));
    }

    public List<T> findAll() {
        return IterableConverter.toList((Iterable)this.operations.findAll(this.metadata.getJavaType()));
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        PageRequest pageRequest = PageRequest.of((int)0, (int)MAX_LIMIT, (Sort)sort);
        return this.findAll((Pageable)pageRequest);
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        if (this.keyspaceToIndexMap.indexExistsFor(this.metadata.getJavaType())) {
            Optional<String> maybeSearchIndex = this.keyspaceToIndexMap.getIndexName(this.metadata.getJavaType());
            if (maybeSearchIndex.isPresent()) {
                String searchIndex = maybeSearchIndex.get();
                SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
                Query query = new Query("*");
                query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
                if (pageable.getSort() != null) {
                    for (Sort.Order order : pageable.getSort()) {
                        query.setSortBy(order.getProperty(), order.isAscending());
                    }
                }
                SearchResult searchResult = searchOps.search(query);
                List content = searchResult.docs.stream().map(d -> ObjectUtils.documentToObject(d, this.metadata.getJavaType(), this.mappingConverter)).collect(Collectors.toList());
                return new PageImpl(content, pageable, searchResult.totalResults);
            }
            return Page.empty();
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.metadata.getJavaType());
        return new PageImpl(IterableConverter.toList((Iterable)content), pageable, this.operations.count(this.metadata.getJavaType()));
    }

    private String getKeyspace() {
        return this.keyspaceToIndexMap.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    private String getKey(Object id) {
        return this.getKeyspace() + id.toString();
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        try (Jedis jedis = this.modulesOperations.getClient().getJedis();){
            Pipeline pipeline = jedis.pipelined();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : (String)keyValueEntity.getPropertyAccessor(entity).getProperty(keyValueEntity.getIdProperty());
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, id.toString());
                this.processAuditAnnotations(objectKey, entity, isNew);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                pipeline.sadd(rdo.getKeyspace(), new String[]{id.toString()});
                pipeline.hmset(objectKey, rdo.getBucket().rawMap());
                if (this.expires(rdo)) {
                    pipeline.expire(objectKey, rdo.getTimeToLive().longValue());
                }
                saved.add(entity);
            }
            pipeline.sync();
        }
        return saved;
    }

    public byte[] createKey(String keyspace, String id) {
        return this.mappingConverter.toBytes(keyspace + ":" + id);
    }

    private boolean expires(RedisData data) {
        return data.getTimeToLive() != null && data.getTimeToLive() > 0L;
    }

    private void processAuditAnnotations(byte[] redisKey, Object item, boolean isNew) {
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> SimpleRedisEnhancedRepository.lambda$processAuditAnnotations$2((PropertyAccessor)accessor, arg_0));
        }
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$2(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }
}

