/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.google.gson.Gson;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.SearchStreamImpl;
import com.redis.om.spring.search.stream.WrapperSearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import com.redis.om.spring.tuple.Tuples;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.Query;
import io.redisearch.SearchResult;
import io.redisearch.aggregation.SortedField;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.geo.Point;
import org.springframework.util.ReflectionUtils;

public class ReturnFieldsSearchStreamImpl<E, T>
implements SearchStream<T> {
    private static final Log logger = LogFactory.getLog(ReturnFieldsSearchStreamImpl.class);
    private static final Gson gson = GsonBuidlerFactory.getBuilder().create();
    private SearchStreamImpl<E> entitySearchStream;
    private List<MetamodelField<E, ?>> returning = new ArrayList();
    private Stream<T> resolvedStream;
    private Runnable closeHandler;

    public ReturnFieldsSearchStreamImpl(SearchStreamImpl<E> entitySearchStream, List<MetamodelField<E, ?>> returning) {
        this.entitySearchStream = entitySearchStream;
        this.returning = returning;
    }

    @Override
    public Iterator<T> iterator() {
        return this.resolveStream().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.resolveStream().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.resolveStream().isParallel();
    }

    @Override
    public SearchStream<T> sequential() {
        return new WrapperSearchStream((Stream)this.resolveStream().sequential());
    }

    @Override
    public SearchStream<T> parallel() {
        return new WrapperSearchStream((Stream)this.resolveStream().parallel());
    }

    @Override
    public SearchStream<T> unordered() {
        return new WrapperSearchStream((Stream)this.resolveStream().unordered());
    }

    @Override
    public SearchStream<T> onClose(Runnable closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public void close() {
        if (this.closeHandler == null) {
            this.resolveStream().close();
        } else {
            this.resolveStream().onClose(this.closeHandler);
            this.resolveStream().close();
        }
    }

    @Override
    public SearchStream<T> filter(SearchFieldPredicate<? super T, ?> predicate) {
        throw new UnsupportedOperationException("Filter on a field predicate is not supported on mapped stream");
    }

    @Override
    public SearchStream<T> filter(Predicate<?> predicate) {
        return new WrapperSearchStream<T>(this.resolveStream().filter(predicate));
    }

    @Override
    public <R> SearchStream<R> map(Function<? super T, ? extends R> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.resolveStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.resolveStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.resolveStream().mapToDouble(mapper);
    }

    @Override
    public <R> SearchStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMapToDouble(mapper);
    }

    @Override
    public SearchStream<T> sorted(Comparator<? super T> comparator) {
        return new WrapperSearchStream<T>(this.resolveStream().sorted(comparator));
    }

    @Override
    public SearchStream<T> sorted(Comparator<? super T> comparator, SortedField.SortOrder order) {
        return this.sorted(comparator);
    }

    @Override
    public SearchStream<T> peek(Consumer<? super T> action) {
        return new WrapperSearchStream<T>(this.resolveStream().peek(action));
    }

    @Override
    public SearchStream<T> limit(long maxSize) {
        return new WrapperSearchStream<T>(this.resolveStream().limit(maxSize));
    }

    @Override
    public SearchStream<T> skip(long n) {
        return new WrapperSearchStream<T>(this.resolveStream().skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.resolveStream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.resolveStream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.resolveStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.resolveStream().toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.resolveStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.resolveStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.resolveStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.resolveStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.resolveStream().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.resolveStream().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.resolveStream().max(comparator);
    }

    @Override
    public long count() {
        return this.resolveStream().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.resolveStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.resolveStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.resolveStream().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.resolveStream().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.resolveStream().findAny();
    }

    private Stream<T> resolveStream() {
        if (this.resolvedStream == null) {
            List results = Collections.emptyList();
            Query query = this.entitySearchStream.prepareQuery();
            boolean resultSetHasNonIndexedFields = this.returning.stream().anyMatch((? super T foi) -> !foi.isIndexed());
            if (resultSetHasNonIndexedFields) {
                SearchResult searchResult = this.entitySearchStream.getOps().search(query);
                List entities = searchResult.docs.stream().map((? super T d) -> gson.fromJson(d.get("$").toString(), this.entitySearchStream.getEntityClass())).collect(Collectors.toList());
                results = this.toResultTuple(entities);
            } else {
                String[] returnFields = (String[])this.returning.stream().map((? super T foi) -> "$." + foi.getField().getName()).toArray(String[]::new);
                query.returnFields(returnFields);
                results = this.toResultTuple(this.entitySearchStream.getOps().search(query));
            }
            this.resolvedStream = results.stream();
        }
        return this.resolvedStream;
    }

    private List<T> toResultTuple(SearchResult searchResult) {
        ArrayList results = new ArrayList();
        searchResult.docs.stream().forEach((? super T doc) -> {
            Map<String, Object> props = StreamSupport.stream(doc.getProperties().spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList mappedResults = new ArrayList();
            this.returning.stream().forEach((? super T foi) -> {
                String field = foi.getField().getName();
                Object value = props.get("$." + field);
                Class<?> targetClass = foi.getField().getType();
                if (targetClass == Date.class) {
                    mappedResults.add(new Date(Long.valueOf(value.toString())));
                } else if (targetClass == Point.class) {
                    StringTokenizer st = new StringTokenizer(value.toString(), ",");
                    String lon = st.nextToken();
                    String lat = st.nextToken();
                    mappedResults.add(new Point(Double.parseDouble(lon), Double.parseDouble(lat)));
                } else {
                    mappedResults.add(gson.fromJson(value.toString(), targetClass));
                }
            });
            if (this.returning.size() > 1) {
                results.add(Tuples.ofArray(mappedResults.toArray()));
            } else {
                results.add(mappedResults.get(0));
            }
        });
        return results;
    }

    private List<T> toResultTuple(List<E> entities) {
        ArrayList results = new ArrayList();
        entities.stream().forEach((? super T entity) -> {
            ArrayList mappedResults = new ArrayList();
            this.returning.stream().forEach((? super T foi) -> {
                String getterName = "get" + ObjectUtils.ucfirst(foi.getField().getName());
                Method getter = ReflectionUtils.findMethod(this.entitySearchStream.getEntityClass(), (String)getterName);
                mappedResults.add(ReflectionUtils.invokeMethod((Method)getter, (Object)entity));
            });
            if (this.returning.size() > 1) {
                results.add(Tuples.ofArray(mappedResults.toArray()));
            } else {
                results.add(mappedResults.get(0));
            }
        });
        return results;
    }

    @Override
    public Stream<Long> map(ToLongFunction<? super T> mapper) {
        return this.resolveStream().mapToLong(mapper).boxed();
    }
}

