/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.google.gson.Gson;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.search.stream.ReturnFieldsSearchStreamImpl;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.WrapperSearchStream;
import com.redis.om.spring.search.stream.actions.TakesJSONOperations;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import com.redis.om.spring.serialization.gson.GsonBuidlerFactory;
import com.redis.om.spring.tuple.AbstractTupleMapper;
import com.redis.om.spring.tuple.TupleMapper;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.Query;
import io.redisearch.SearchResult;
import io.redisearch.aggregation.SortedField;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchStreamImpl<E>
implements SearchStream<E> {
    private static final Log logger = LogFactory.getLog(SearchStreamImpl.class);
    private static final Integer MAX_LIMIT = 10000;
    private RedisModulesOperations<String> modulesOperations;
    private SearchOperations<String> search;
    private JSONOperations<String> json;
    private String searchIndex;
    private Class<E> entityClass;
    private Node rootNode = QueryBuilder.union((Node[])new Node[0]);
    private static final Gson gson = GsonBuidlerFactory.getBuilder().create();
    private Optional<Long> limit = Optional.empty();
    private Optional<Long> skip = Optional.empty();
    private Optional<SortedField> sortBy = Optional.empty();
    private boolean onlyIds = false;
    private Field idField;
    private Runnable closeHandler;
    private Stream<E> resolvedStream;

    public SearchStreamImpl(Class<E> entityClass, RedisModulesOperations<String> modulesOperations) {
        this.modulesOperations = modulesOperations;
        this.entityClass = entityClass;
        this.searchIndex = entityClass.getName() + "Idx";
        this.search = modulesOperations.opsForSearch(this.searchIndex);
        this.json = modulesOperations.opsForJSON();
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(entityClass);
        if (!maybeIdField.isPresent()) {
            throw new IllegalArgumentException(entityClass.getName() + " does not appear to have an ID field");
        }
        this.idField = maybeIdField.get();
    }

    @Override
    public SearchStream<E> filter(SearchFieldPredicate<? super E, ?> predicate) {
        Node node;
        this.rootNode = node = this.processPredicate(predicate);
        return this;
    }

    @Override
    public SearchStream<E> filter(Predicate<?> predicate) {
        Node node;
        this.rootNode = node = this.processPredicate(predicate);
        return this;
    }

    public Node processPredicate(SearchFieldPredicate<? super E, ?> predicate) {
        return predicate.apply(this.rootNode);
    }

    private Node processPredicate(Predicate<?> predicate) {
        if (SearchFieldPredicate.class.isAssignableFrom(predicate.getClass())) {
            SearchFieldPredicate p = (SearchFieldPredicate)predicate;
            return this.processPredicate(p);
        }
        return this.rootNode;
    }

    @Override
    public <T> SearchStream<T> map(Function<? super E, ? extends T> mapper) {
        ArrayList returning = new ArrayList();
        if (MetamodelField.class.isAssignableFrom(mapper.getClass())) {
            MetamodelField foi = (MetamodelField)mapper;
            returning.add(foi);
        } else if (TupleMapper.class.isAssignableFrom(mapper.getClass())) {
            AbstractTupleMapper tm = (AbstractTupleMapper)mapper;
            IntStream.range(0, tm.degree()).forEach((int i) -> {
                MetamodelField foi = (MetamodelField)tm.get(i);
                returning.add(foi);
            });
        } else {
            if (TakesJSONOperations.class.isAssignableFrom(mapper.getClass())) {
                TakesJSONOperations tjo = (TakesJSONOperations)((Object)mapper);
                tjo.setJSONOperations(this.json);
            }
            return new WrapperSearchStream<T>(this.resolveStream().map(mapper));
        }
        return new ReturnFieldsSearchStreamImpl(this, returning);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super E> mapper) {
        return this.resolveStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super E> mapper) {
        return this.resolveStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super E> mapper) {
        return this.resolveStream().mapToDouble(mapper);
    }

    @Override
    public <R> SearchStream<R> flatMap(Function<? super E, ? extends Stream<? extends R>> mapper) {
        return new WrapperSearchStream(this.resolveStream().flatMap(mapper));
    }

    @Override
    public IntStream flatMapToInt(Function<? super E, ? extends IntStream> mapper) {
        return this.resolveStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super E, ? extends LongStream> mapper) {
        return this.resolveStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super E, ? extends DoubleStream> mapper) {
        return this.resolveStream().flatMapToDouble(mapper);
    }

    @Override
    public SearchStream<E> sorted(Comparator<? super E> comparator) {
        if (MetamodelField.class.isAssignableFrom(comparator.getClass())) {
            MetamodelField foi = (MetamodelField)comparator;
            this.sortBy = Optional.of(SortedField.asc((String)foi.getField().getName()));
        }
        return this;
    }

    @Override
    public SearchStream<E> sorted(Comparator<? super E> comparator, SortedField.SortOrder order) {
        if (MetamodelField.class.isAssignableFrom(comparator.getClass())) {
            MetamodelField foi = (MetamodelField)comparator;
            this.sortBy = Optional.of(new SortedField(foi.getField().getName(), order));
        }
        return this;
    }

    @Override
    public SearchStream<E> peek(Consumer<? super E> action) {
        return new WrapperSearchStream<E>(this.resolveStream().peek(action));
    }

    @Override
    public SearchStream<E> limit(long maxSize) {
        this.limit = Optional.of(maxSize);
        return this;
    }

    @Override
    public SearchStream<E> skip(long s) {
        this.skip = Optional.of(s);
        return this;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        if (TakesJSONOperations.class.isAssignableFrom(action.getClass())) {
            TakesJSONOperations tjo = (TakesJSONOperations)((Object)action);
            tjo.setJSONOperations(this.json);
        }
        this.resolveStream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super E> action) {
        this.resolveStream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.resolveStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.resolveStream().toArray(generator);
    }

    @Override
    public E reduce(E identity, BinaryOperator<E> accumulator) {
        return this.resolveStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<E> reduce(BinaryOperator<E> accumulator) {
        return this.resolveStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super E, U> accumulator, BinaryOperator<U> combiner) {
        return this.resolveStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super E> accumulator, BiConsumer<R, R> combiner) {
        return this.resolveStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super E, A, R> collector) {
        return this.resolveStream().collect(collector);
    }

    @Override
    public Optional<E> min(Comparator<? super E> comparator) {
        return this.resolveStream().min(comparator);
    }

    @Override
    public Optional<E> max(Comparator<? super E> comparator) {
        return this.resolveStream().max(comparator);
    }

    @Override
    public long count() {
        Query query = this.rootNode.toString().isBlank() ? new Query() : new Query(this.rootNode.toString());
        query.limit(Integer.valueOf(0), Integer.valueOf(0));
        SearchResult searchResult = this.search.search(query);
        return searchResult.totalResults;
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        return this.resolveStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        return this.resolveStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super E> predicate) {
        return this.resolveStream().noneMatch(predicate);
    }

    @Override
    public Optional<E> findFirst() {
        this.limit = Optional.of(1L);
        return this.resolveStream().findFirst();
    }

    @Override
    public Optional<E> findAny() {
        return this.findFirst();
    }

    @Override
    public Iterator<E> iterator() {
        return this.resolveStream().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.resolveStream().spliterator();
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public SearchStream<E> sequential() {
        return this;
    }

    @Override
    public SearchStream<E> parallel() {
        return this;
    }

    @Override
    public SearchStream<E> unordered() {
        return this;
    }

    @Override
    public SearchStream<E> onClose(Runnable closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public void close() {
        if (this.closeHandler == null) {
            this.resolveStream().close();
        } else {
            this.resolveStream().onClose(this.closeHandler);
            this.resolveStream().close();
        }
    }

    SearchOperations<String> getOps() {
        return this.search;
    }

    Query prepareQuery() {
        Query query = this.rootNode.toString().isBlank() ? new Query() : new Query(this.rootNode.toString());
        query.limit(Integer.valueOf(this.skip.isPresent() ? this.skip.get().intValue() : 0), Integer.valueOf(this.limit.isPresent() ? this.limit.get().intValue() : MAX_LIMIT.intValue()));
        if (this.sortBy.isPresent()) {
            SortedField sortField = this.sortBy.get();
            query.setSortBy(sortField.getField(), sortField.getOrder().equals("ASC"));
        }
        if (this.onlyIds) {
            query.returnFields(new String[]{this.idField.getName()});
        }
        return query;
    }

    private SearchResult executeQuery() {
        return this.search.search(this.prepareQuery());
    }

    private List<E> toEntityList(SearchResult searchResult) {
        return searchResult.docs.stream().map((? super T d) -> gson.fromJson(d.get("$").toString(), this.entityClass)).collect(Collectors.toList());
    }

    private Stream<E> resolveStream() {
        if (this.resolvedStream == null) {
            this.resolvedStream = this.toEntityList(this.executeQuery()).stream();
        }
        return this.resolvedStream;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Stream<Long> map(ToLongFunction<? super E> mapper) {
        Stream<Long> result = Stream.empty();
        if (TakesJSONOperations.class.isAssignableFrom(mapper.getClass())) {
            TakesJSONOperations tjo = (TakesJSONOperations)((Object)mapper);
            tjo.setJSONOperations(this.json);
            this.onlyIds = true;
            Method idSetter = ObjectUtils.getSetterForField(this.entityClass, this.idField);
            Stream<Object> wrappedIds = this.executeQuery().docs.stream().map((? super T d) -> {
                try {
                    String key = this.idField.getType().getDeclaredConstructor(this.idField.getType()).newInstance(d.getId()).toString();
                    return key.substring(key.indexOf(":") + 1);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).map((? super T id) -> {
                Object entity;
                try {
                    entity = this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    idSetter.invoke(entity, id);
                }
                catch (Exception e) {
                    entity = null;
                }
                return entity;
            });
            result = wrappedIds.mapToLong(mapper).boxed();
        }
        return result;
    }
}

