/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.actions;

import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.search.stream.actions.TakesJSONOperations;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.Optional;

public abstract class BaseAbstractAction
implements TakesJSONOperations {
    protected Field field;
    protected JSONOperations<String> json;
    private Field idField;

    protected BaseAbstractAction(Field field) {
        this.field = field;
        Class<?> entityClass = field.getDeclaringClass();
        Optional<Field> maybeId = ObjectUtils.getIdFieldForEntityClass(entityClass);
        if (!maybeId.isPresent()) {
            throw new NullPointerException(String.format("Entity Class %s does not have an ID field", entityClass.getSimpleName()));
        }
        this.idField = maybeId.get();
    }

    @Override
    public void setJSONOperations(JSONOperations<String> json) {
        this.json = json;
    }

    protected String getKey(Object entity) {
        String id = ObjectUtils.getIdFieldForEntity(this.idField, entity).toString();
        return this.field.getDeclaringClass().getName() + ":" + id;
    }
}

