/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates;

import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import io.redisearch.Schema;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.data.geo.Point;

public abstract class BaseAbstractPredicate<E, T>
implements SearchFieldPredicate<E, T> {
    private Schema.FieldType fieldType;
    private Field field;

    protected BaseAbstractPredicate() {
    }

    protected BaseAbstractPredicate(Field field) {
        this.field = field;
        this.fieldType = BaseAbstractPredicate.getFieldTypeFor(field);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Schema.FieldType getSearchFieldType() {
        return this.fieldType;
    }

    private static Schema.FieldType getFieldTypeFor(Field field) {
        Schema.FieldType result = Schema.FieldType.Tag;
        if (field.isAnnotationPresent(Searchable.class)) {
            result = Schema.FieldType.Geo;
        } else if (field.isAnnotationPresent(TextIndexed.class)) {
            result = Schema.FieldType.FullText;
        } else if (field.isAnnotationPresent(TagIndexed.class)) {
            result = Schema.FieldType.Tag;
        } else if (field.isAnnotationPresent(GeoIndexed.class)) {
            result = Schema.FieldType.Geo;
        } else if (field.isAnnotationPresent(NumericIndexed.class)) {
            result = Schema.FieldType.Numeric;
        } else if (field.isAnnotationPresent(Indexed.class)) {
            if (CharSequence.class.isAssignableFrom(field.getType())) {
                result = Schema.FieldType.Tag;
            } else if (Number.class.isAssignableFrom(field.getType()) || field.getType() == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class) {
                result = Schema.FieldType.Numeric;
            } else if (Set.class.isAssignableFrom(field.getType()) || List.class.isAssignableFrom(field.getType())) {
                result = Schema.FieldType.Tag;
            } else if (field.getType() == Point.class) {
                result = Schema.FieldType.Geo;
            }
        }
        return result;
    }

    @Override
    public boolean test(T t) {
        return false;
    }
}

