/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.geo;

import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.util.ObjectUtils;
import io.redisearch.querybuilder.GeoValue;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import io.redisearch.querybuilder.Value;
import java.lang.reflect.Field;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;

public class NearPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private Point point;
    private Distance distance;

    public NearPredicate(Field field, Point point, Distance distance) {
        super(field);
        this.point = point;
        this.distance = distance;
    }

    public Point getPoint() {
        return this.point;
    }

    public Distance getDistance() {
        return this.distance;
    }

    @Override
    public Node apply(Node root) {
        GeoValue geoValue = new GeoValue(this.getPoint().getX(), this.getPoint().getY(), this.getDistance().getValue(), ObjectUtils.getDistanceUnit(this.getDistance()));
        return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{geoValue});
    }
}

