/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.geo;

import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import io.redisearch.querybuilder.Value;
import io.redisearch.querybuilder.Values;
import java.lang.reflect.Field;
import org.springframework.data.geo.Point;

public class NotEqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private T value;
    private Double x;
    private Double y;

    public NotEqualPredicate(Field field, T value) {
        super(field);
        this.value = value;
        if (value.getClass() == Point.class) {
            Point point = (Point)value;
            this.x = point.getX();
            this.y = point.getY();
        }
    }

    public NotEqualPredicate(Field field, String xy) {
        super(field);
        String[] coordinates = xy.split(",");
        this.x = Double.parseDouble(coordinates[0]);
        this.y = Double.parseDouble(coordinates[1]);
    }

    public NotEqualPredicate(Field field, Double x, Double y) {
        super(field);
        this.x = x;
        this.y = y;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        return QueryBuilder.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilder.disjunct((String)this.getField().getName(), (Value[])new Value[]{Values.value((String)String.format("[%s %s 0.0001 mi]", this.x, this.y))})});
    }
}

