/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import io.redisearch.querybuilder.Value;
import io.redisearch.querybuilder.Values;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class BetweenPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private T min;
    private T max;

    public BetweenPredicate(Field field, T min, T max) {
        super(field);
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public Node apply(Node root) {
        Class<?> cls = this.min.getClass();
        if (cls == LocalDate.class) {
            LocalDate minLocalDate = (LocalDate)this.min;
            LocalDate maxLocalDate = (LocalDate)this.max;
            Instant minInstant = minLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Instant maxInstant = maxLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Long minUnixTime = minInstant.getEpochSecond();
            Long maxUnixTime = maxInstant.getEpochSecond();
            return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{Values.between((double)Double.valueOf(minUnixTime.toString()), (double)Double.valueOf(maxUnixTime.toString()))});
        }
        if (cls == Integer.class) {
            return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{Values.between((int)Integer.valueOf(this.getMin().toString()), (int)Integer.valueOf(this.getMax().toString()))});
        }
        if (cls == Double.class) {
            return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{Values.between((double)Double.valueOf(this.getMin().toString()), (double)Double.valueOf(this.getMax().toString()))});
        }
        return root;
    }
}

