/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import io.redisearch.querybuilder.Value;
import io.redisearch.querybuilder.Values;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class LessThanOrEqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private T value;

    public LessThanOrEqualPredicate(Field field, T value) {
        super(field);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        Class<?> cls = this.value.getClass();
        if (cls == LocalDate.class) {
            LocalDate localDate = (LocalDate)this.getValue();
            Instant instant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Long unixTime = instant.getEpochSecond();
            return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{Values.le((double)unixTime.longValue())});
        }
        if (cls == Integer.class) {
            return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{Values.le((int)Integer.valueOf(this.getValue().toString()))});
        }
        if (cls == Double.class) {
            return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new Value[]{Values.le((double)Double.valueOf(this.getValue().toString()))});
        }
        return root;
    }
}

