/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import io.redisearch.querybuilder.QueryNode;
import java.lang.reflect.Field;

public class EqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private T value;

    public EqualPredicate(Field field, T value) {
        super(field);
        this.value = QueryUtils.escape(value);
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        if (Iterable.class.isAssignableFrom(this.getValue().getClass())) {
            Iterable values = (Iterable)this.getValue();
            QueryNode and = QueryBuilder.intersect((Node[])new Node[0]);
            for (Object v : values) {
                and.add(this.getField().getName(), new String[]{"{" + v.toString() + "}"});
            }
            return QueryBuilder.intersect((Node[])new Node[]{root, and});
        }
        return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new String[]{"{" + this.value.toString() + "}"});
    }
}

