/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import io.redisearch.querybuilder.Node;
import io.redisearch.querybuilder.QueryBuilder;
import java.lang.reflect.Field;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class InPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private List<String> values;

    public InPredicate(Field field, List<String> list) {
        super(field);
        this.values = list.stream().map(QueryUtils::escape).collect(Collectors.toList());
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public Node apply(Node root) {
        StringJoiner sj = new StringJoiner(" | ");
        for (String value : this.getValues()) {
            sj.add(value.toString());
        }
        return QueryBuilder.intersect((Node[])new Node[]{root}).add(this.getField().getName(), new String[]{"{" + sj.toString() + "}"});
    }
}

