/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;

public class SetToStringAdapter
extends TypeAdapter<Set<?>> {
    public void write(JsonWriter writer, Set<?> value) throws IOException {
        if (value == null || value.isEmpty()) {
            writer.nullValue();
            return;
        }
        writer.value(value.stream().map(Object::toString).collect(Collectors.joining("|")));
    }

    public Set read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String csv = reader.nextString();
        String[] parts = csv.split("\\|");
        return Set.of(parts);
    }
}

