/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.tuple;

import com.redis.om.spring.tuple.Tuple;
import com.redis.om.spring.tuple.accessor.FirstAccessor;
import com.redis.om.spring.tuple.accessor.SecondAccessor;
import com.redis.om.spring.tuple.accessor.ThirdAccessor;

public interface Triple<E1, E2, E3>
extends Tuple {
    public E1 getFirst();

    public E2 getSecond();

    public E3 getThird();

    @Override
    default public int size() {
        return 3;
    }

    @Override
    default public Object get(int index) {
        switch (index) {
            case 0: {
                return this.getFirst();
            }
            case 1: {
                return this.getSecond();
            }
            case 2: {
                return this.getThird();
            }
        }
        throw new IndexOutOfBoundsException(String.format("Index %d is outside bounds of tuple of degree %s", index, this.size()));
    }

    public static <E1, E2, E3> FirstAccessor<Triple<E1, E2, E3>, E1> getFirstGetter() {
        return Triple::getFirst;
    }

    public static <E1, E2, E3> SecondAccessor<Triple<E1, E2, E3>, E2> getSecondGetter() {
        return Triple::getSecond;
    }

    public static <E1, E2, E3> ThirdAccessor<Triple<E1, E2, E3>, E3> getThirdGetter() {
        return Triple::getThird;
    }
}

