/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.util;

import com.redis.om.spring.convert.MappingRedisOMConverter;
import io.redisearch.Document;
import io.redisearch.querybuilder.GeoValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Distance;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.ReflectionUtils;

public class ObjectUtils {
    public static String getDistanceAsRedisString(Distance distance) {
        return String.format("%s %s", Double.toString(distance.getValue()), distance.getUnit());
    }

    public static List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(annotationClass)).collect(Collectors.toList());
    }

    public static GeoValue.Unit getDistanceUnit(Distance distance) {
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.MILES.getAbbreviation())) {
            return GeoValue.Unit.MILES;
        }
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.FEET.getAbbreviation())) {
            return GeoValue.Unit.FEET;
        }
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.KILOMETERS.getAbbreviation())) {
            return GeoValue.Unit.KILOMETERS;
        }
        return GeoValue.Unit.METERS;
    }

    public static String getTargetClassName(String fullTypeClassName) {
        String[] splitted = fullTypeClassName.split(" ");
        String cls = splitted[splitted.length - 1];
        if (cls.contains("<")) {
            cls = cls.substring(0, cls.indexOf("<"));
        }
        return cls;
    }

    public static String firstToLowercase(String string) {
        char[] c = string.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static Optional<Class<?>> getCollectionElementType(Field field) {
        if (Collection.class.isAssignableFrom(field.getType()) || Iterable.class.isAssignableFrom(field.getType())) {
            ResolvableType collectionType = ResolvableType.forField((Field)field);
            Class elementType = collectionType.getGeneric(new int[]{0}).getRawClass();
            return Optional.of(elementType);
        }
        return Optional.empty();
    }

    public static Optional<Field> getIdFieldForEntityClass(Class<?> cl) {
        return Arrays.stream(cl.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Id.class)).findFirst();
    }

    public static Optional<?> getIdFieldForEntity(Object entity) {
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(entity.getClass());
        if (maybeIdField.isPresent()) {
            Field idField = maybeIdField.get();
            String getterName = "get" + ObjectUtils.ucfirst(idField.getName());
            Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
            Object id = ReflectionUtils.invokeMethod((Method)getter, (Object)entity);
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public static Object getIdFieldForEntity(Field idField, Object entity) {
        String getterName = "get" + ObjectUtils.ucfirst(idField.getName());
        Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
        return ReflectionUtils.invokeMethod((Method)getter, (Object)entity);
    }

    public static Method getGetterForField(Class<?> cls, Field field) {
        String getterName = "get" + ObjectUtils.ucfirst(field.getName());
        return ReflectionUtils.findMethod(cls, (String)getterName);
    }

    public static Method getSetterForField(Class<?> cls, Field field) {
        String setterName = "set" + ObjectUtils.ucfirst(field.getName());
        return ReflectionUtils.findMethod(cls, (String)setterName, (Class[])new Class[]{field.getType()});
    }

    public static String ucfirst(String input) {
        return ObjectUtils.withFirst(input, first -> String.valueOf(Character.toUpperCase(first.charValue())));
    }

    public static String withFirst(String input, Function<Character, String> callback) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return "";
        }
        return String.join((CharSequence)"", callback.apply(Character.valueOf(input.charAt(0))), input.subSequence(1, input.length()));
    }

    public static boolean isFirstLowerCase(String string) {
        String first = string.substring(0, 1);
        return Character.isLetter(first.charAt(0)) && first.toLowerCase().equals(first);
    }

    public static String lcfirst(String input) {
        return ObjectUtils.withFirst(input, first -> String.valueOf(Character.toLowerCase(first.charValue())));
    }

    public static String unQuote(String s) {
        Objects.requireNonNull(s);
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String toUnderscoreSeparated(String javaName) {
        Objects.requireNonNull(javaName);
        StringBuilder result = new StringBuilder();
        String input = ObjectUtils.unQuote(javaName.trim());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (result.length() == 0) {
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String shortName(String longName) {
        String temp = longName.replace('$', '.');
        int openBrPos = temp.indexOf(60);
        String parameters = "";
        if (openBrPos > 0) {
            parameters = temp.substring(openBrPos);
            temp = temp.substring(0, openBrPos);
        }
        if (temp.contains(".")) {
            temp = temp.substring(temp.lastIndexOf(46) + 1);
        }
        return temp + parameters;
    }

    public static boolean isPropertyAnnotatedWith(Class<?> cls, String property, Class<? extends Annotation> annotationClass) {
        try {
            Field field = cls.getDeclaredField(property);
            return field.isAnnotationPresent(annotationClass);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    public static Object documentToObject(Document document, Class<?> returnedObjectType, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        document.getProperties().forEach(p -> b.put((String)p.getKey(), StringRedisSerializer.UTF_8.serialize(p.getValue().toString())));
        return mappingConverter.read(returnedObjectType, new RedisData(b));
    }

    public static <T> T documentToEntity(Document document, Class<T> classOfT, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        document.getProperties().forEach(p -> b.put((String)p.getKey(), StringRedisSerializer.UTF_8.serialize(p.getValue().toString())));
        return mappingConverter.read(classOfT, new RedisData(b));
    }

    public static String asString(Object value, MappingRedisOMConverter mappingConverter) {
        return value instanceof String ? (String)value : (String)mappingConverter.getConversionService().convert(value, String.class);
    }

    private ObjectUtils() {
    }
}

