/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.google.gson.Gson;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.search.stream.AggregationPageable;
import com.redis.om.spring.search.stream.AggregationStream;
import com.redis.om.spring.util.ObjectUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.util.SafeEncoder;

public class AggregationPage<E>
implements Slice<E>,
Serializable {
    private List<E> content;
    private final transient Pageable pageable;
    private transient AggregationStream<E> aggregationStream;
    private long cursorId = -1L;
    private AggregationResult aggregationResult;
    private final transient Gson gson;
    private final Class<E> entityClass;
    private final boolean isDocument;
    private final transient MappingRedisOMConverter mappingConverter;

    public AggregationPage(AggregationStream<E> aggregationStream, Pageable pageable, Class<E> entityClass, Gson gson, MappingRedisOMConverter mappingConverter, boolean isDocument) {
        this.aggregationStream = aggregationStream;
        this.pageable = pageable;
        this.entityClass = entityClass;
        this.gson = gson;
        this.isDocument = isDocument;
        this.mappingConverter = mappingConverter;
    }

    public AggregationPage(AggregationResult aggregationResult, Pageable pageable, Class<E> entityClass, Gson gson, MappingRedisOMConverter mappingConverter, boolean isDocument) {
        this.aggregationResult = aggregationResult;
        this.pageable = pageable;
        this.entityClass = entityClass;
        this.gson = gson;
        this.cursorId = aggregationResult.getCursorId();
        this.isDocument = isDocument;
        this.mappingConverter = mappingConverter;
    }

    public int getNumber() {
        return this.pageable.getPageNumber();
    }

    public int getSize() {
        return this.resolveAggregation().getResults().size();
    }

    public int getNumberOfElements() {
        return this.getSize();
    }

    @NonNull
    public List<E> getContent() {
        return this.resolveContent();
    }

    public boolean hasContent() {
        return !this.resolveContent().isEmpty();
    }

    @NonNull
    public Sort getSort() {
        return this.pageable.getSort();
    }

    public boolean isFirst() {
        return this.getNumber() == 0;
    }

    public boolean isLast() {
        return this.resolveCursorId() == 0L;
    }

    public boolean hasNext() {
        return this.cursorId == -1L || this.resolveCursorId() != 0L;
    }

    @NonNull
    public Pageable nextPageable() {
        PageRequest next = PageRequest.of((int)(this.getNumber() + 1), (int)this.pageable.getPageSize(), (Sort)this.pageable.getSort());
        return this.hasNext() ? new AggregationPageable((Pageable)next, this.resolveAggregation().getCursorId()) : Pageable.unpaged();
    }

    @NonNull
    public <U> Slice<U> map(Function<? super E, ? extends U> converter) {
        return new SliceImpl(this.getConvertedContent(converter), this.pageable, this.hasNext());
    }

    @NonNull
    public Iterator<E> iterator() {
        return this.resolveContent().iterator();
    }

    public boolean hasPrevious() {
        return false;
    }

    @NonNull
    public Pageable previousPageable() {
        return Pageable.unpaged();
    }

    private AggregationResult resolveAggregation() {
        if (this.aggregationResult == null) {
            this.aggregationResult = this.aggregationStream.aggregate();
        }
        return this.aggregationResult;
    }

    private List<E> resolveContent() {
        if (this.content == null) {
            this.content = this.toEntityList(this.resolveAggregation());
        }
        return this.content;
    }

    private long resolveCursorId() {
        if (this.cursorId != -1L) {
            this.cursorId = this.resolveAggregation().getCursorId();
        }
        return this.cursorId;
    }

    protected <U> List<U> getConvertedContent(Function<? super E, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null");
        return this.stream().map(converter::apply).toList();
    }

    List<E> toEntityList(AggregationResult aggregationResult) {
        if (this.isDocument) {
            return aggregationResult.getResults().stream().map((? super T d) -> this.gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), this.entityClass)).toList();
        }
        return aggregationResult.getResults().stream().map((? super T h) -> ObjectUtils.mapToObject(h, this.entityClass, this.mappingConverter)).toList();
    }
}

