/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class EqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T value;

    public EqualPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        Class<?> cls = this.getValue().getClass();
        if (cls == LocalDate.class) {
            LocalDate localDate = (LocalDate)this.getValue();
            Instant instant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            long unixTime = instant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
        }
        if (cls == Date.class) {
            Date date = (Date)this.getValue();
            Instant instant = date.toInstant();
            long unixTime = instant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
        }
        if (cls == LocalDateTime.class) {
            LocalDateTime localDateTime = (LocalDateTime)this.getValue();
            Instant instant = localDateTime.toInstant(ZoneOffset.of(ZoneId.systemDefault().getId()));
            long unixTime = instant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
        }
        if (cls == Instant.class) {
            Instant instant = (Instant)this.getValue();
            long unixTime = instant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((double)unixTime)});
        }
        if (cls == Integer.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((int)Integer.parseInt(this.getValue().toString()))});
        }
        if (cls == Long.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((double)Long.parseLong(this.getValue().toString()))});
        }
        if (cls == Double.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.eq((double)Double.parseDouble(this.getValue().toString()))});
        }
        return root;
    }
}

