/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;

public class EndsWithPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T value;

    public EndsWithPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        if (Iterable.class.isAssignableFrom(this.getValue().getClass())) {
            Iterable values = (Iterable)this.getValue();
            QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
            for (Object v : values) {
                and.add(this.getSearchAlias(), new String[]{"{*" + QueryUtils.escape(v.toString(), true) + "}"});
            }
            return QueryBuilders.intersect((Node[])new Node[]{root, and});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new String[]{"{*" + QueryUtils.escape(this.value.toString(), true) + "}"});
    }
}

