/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.RedisDocumentRepository;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.search.stream.FluentQueryByExample;
import com.redis.om.spring.serialization.gson.GsonListOfType;
import com.redis.om.spring.util.ObjectUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Version;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.json.JsonProtocol;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.SafeEncoder;

public class SimpleRedisDocumentRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisDocumentRepository<T, ID> {
    private final GsonBuilder gsonBuilder;
    protected final RedisModulesOperations<String> modulesOperations;
    protected final EntityInformation<T, ID> metadata;
    protected final KeyValueOperations operations;
    protected final RediSearchIndexer indexer;
    protected final MappingRedisOMConverter mappingConverter;
    private final ULIDIdentifierGenerator generator;
    private final RedisOMProperties properties;
    private final RedisMappingContext mappingContext;
    private final EntityStream entityStream;

    public SimpleRedisDocumentRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, RediSearchIndexer indexer, RedisMappingContext mappingContext, GsonBuilder gsonBuilder, RedisOMProperties properties) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.indexer = indexer;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl((RedisOperations)this.modulesOperations.getTemplate()));
        this.generator = ULIDIdentifierGenerator.INSTANCE;
        this.gsonBuilder = gsonBuilder;
        this.mappingContext = mappingContext;
        this.properties = properties;
        this.entityStream = new EntityStreamImpl(this.modulesOperations, this.modulesOperations.getGsonBuilder(), indexer);
    }

    @Override
    public Iterable<ID> getIds() {
        Gson gson = this.gsonBuilder.create();
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(this.metadata.getJavaType());
        String idField = maybeIdField.map(Field::getName).orElse("id");
        Query query = new Query("*");
        query.limit(Integer.valueOf(0), Integer.valueOf(this.properties.getRepository().getQuery().getLimit()));
        query.returnFields(new String[]{idField});
        SearchResult searchResult = this.getSearchOps().search(query);
        return searchResult.getDocuments().stream().map(d -> gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get(idField))), this.metadata.getIdType())).toList();
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        ArrayList ids = Lists.newArrayList(this.getIds());
        int fromIndex = Math.toIntExact(pageable.getOffset());
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void deleteById(ID id, Path path) {
        this.modulesOperations.opsForJSON().del(this.getKey(id), path);
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        this.modulesOperations.opsForJSON().set(this.getKey(Objects.requireNonNull(this.metadata.getId(entity))), value, Path.of((String)field.getJSONPath()));
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(Path2.of((String)field.getJSONPath()), List.class, (K[])keys).stream().flatMap(Collection::stream).toList();
    }

    @Override
    public Long getExpiration(ID id) {
        StringRedisTemplate template = this.modulesOperations.getTemplate();
        return template.getExpire((Object)this.getKey(id));
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        try (Jedis jedis = this.modulesOperations.getClient().getJedis().get();){
            Pipeline pipeline = jedis.pipelined();
            Gson gson = this.gsonBuilder.create();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(Objects.requireNonNull((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : keyValueEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)Objects.requireNonNull((KeyValuePersistentProperty)keyValueEntity.getIdProperty()));
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, Objects.requireNonNull(id).toString());
                this.processAuditAnnotations(entity, isNew);
                Optional<Long> maybeTtl = this.getTTLForEntity(entity);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(objectKey);
                args.add(SafeEncoder.encode((String)Path.ROOT_PATH.toString()));
                args.add(SafeEncoder.encode((String)gson.toJson(entity)));
                pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                this.processReferenceAnnotations(objectKey, entity, pipeline);
                maybeTtl.ifPresent(aLong -> pipeline.expire(objectKey, aLong.longValue()));
                saved.add(entity);
            }
            pipeline.sync();
        }
        return saved;
    }

    @Override
    public Iterable<T> bulkLoad(String file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(file, new String[0]));){
            Gson gson = this.gsonBuilder.create();
            List entities = (List)gson.fromJson((Reader)reader, new GsonListOfType(this.metadata.getJavaType()));
            Iterable iterable = this.saveAll((Iterable)entities);
            return iterable;
        }
    }

    @Override
    public <S extends T> S update(S entity) {
        return (S)this.operations.update(this.metadata.getRequiredId(entity), entity);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        this.checkVersion(entity);
        this.operations.delete(entity);
    }

    public List<T> findAllById(Iterable<ID> ids) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(this.metadata.getJavaType(), (K[])keys).stream().toList();
    }

    private String getKeyspace() {
        return this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    private String getKey(Object id) {
        return this.getKeyspace() + id.toString();
    }

    public byte[] createKey(String keyspace, String id) {
        return this.mappingConverter.toBytes(keyspace + ":" + id);
    }

    private void processAuditAnnotations(Object item, boolean isNew) {
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> SimpleRedisDocumentRepository.lambda$processAuditAnnotations$4((PropertyAccessor)accessor, arg_0));
        }
    }

    private void processReferenceAnnotations(byte[] objectKey, Object entity, Pipeline pipeline) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(entity.getClass(), Reference.class);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
            fields.forEach(arg_0 -> this.lambda$processReferenceAnnotations$6((PropertyAccessor)accessor, objectKey, pipeline, arg_0));
        }
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
        if (keyspaceConfig.hasSettingsFor(entity.getClass())) {
            KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entity.getClass());
            if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                try {
                    Field fld = ReflectionUtils.findField(entity.getClass(), (String)settings.getTimeToLivePropertyName());
                    Method ttlGetter = ObjectUtils.getGetterForField(entity.getClass(), Objects.requireNonNull(fld));
                    long ttlPropertyValue = ((Number)Objects.requireNonNull(ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity))).longValue();
                    ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity);
                    TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                    if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                        return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                    }
                    return Optional.of(ttlPropertyValue);
                }
                catch (IllegalArgumentException | SecurityException e) {
                    return Optional.empty();
                }
            }
            if (settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                return Optional.of(settings.getTimeToLive());
            }
        }
        return Optional.empty();
    }

    private void checkVersion(T entity) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(entity.getClass(), Version.class);
        if (fields.size() == 1) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
            Field versionField = fields.get(0);
            String property = versionField.getName();
            if (versionField.getType() == Integer.class || ObjectUtils.isPrimitiveOfType(versionField.getType(), Integer.class) || versionField.getType() == Long.class || ObjectUtils.isPrimitiveOfType(versionField.getType(), Long.class)) {
                Number version = (Number)wrapper.getPropertyValue(property);
                Number dbVersion = this.getEntityVersion(this.getKey(this.metadata.getRequiredId(entity)), property);
                if (dbVersion != null && version != null && dbVersion.longValue() != version.longValue()) {
                    throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s as it is outdated", entity, version));
                }
            }
        }
    }

    private Number getEntityVersion(String key, String versionProperty) {
        Class type;
        JSONOperations<String> ops = this.modulesOperations.opsForJSON();
        Long[] dbVersionArray = (Long[])ops.get(key, type = new TypeToken<Long[]>(){}.getRawType(), Path.of((String)("$." + versionProperty)));
        return dbVersionArray != null ? dbVersionArray[0] : null;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).findFirst();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).collect(Collectors.toList());
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.entityStream.of(example.getProbeType()).filter(example).sorted(sort).collect(Collectors.toList());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        return ObjectUtils.pageFromSlice(this.entityStream.of(example.getProbeType()).filter(example).getSlice(pageable));
    }

    public <S extends T> long count(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).count();
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new FluentQueryByExample<S>(example, example.getProbeType(), this.entityStream, this.getSearchOps()));
    }

    private SearchOperations<String> getSearchOps() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        return this.modulesOperations.opsForSearch(maybeSearchIndex.get());
    }

    private /* synthetic */ void lambda$processReferenceAnnotations$6(PropertyAccessor accessor, byte[] objectKey, Pipeline pipeline, Field f) {
        Object referencedValue = accessor.getPropertyValue(f.getName());
        if (referencedValue != null) {
            Gson gson = this.gsonBuilder.create();
            if (referencedValue instanceof Collection) {
                Collection referenceValues = (Collection)referencedValue;
                ArrayList referenceKeys = new ArrayList();
                referenceValues.forEach(r -> {
                    Object id = ObjectUtils.getIdFieldForEntity(r);
                    if (id != null) {
                        String referenceKey = this.indexer.getKeyspaceForEntityClass(r.getClass()) + id;
                        referenceKeys.add(referenceKey);
                    }
                });
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(objectKey);
                args.add(SafeEncoder.encode((String)Path.of((String)("$." + f.getName())).toString()));
                args.add(SafeEncoder.encode((String)gson.toJson(referenceKeys)));
                pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
            } else {
                Object id = ObjectUtils.getIdFieldForEntity(referencedValue);
                if (id != null) {
                    String referenceKey = this.indexer.getKeyspaceForEntityClass(f.getType()) + id;
                    ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                    args.add(objectKey);
                    args.add(SafeEncoder.encode((String)Path.of((String)("$." + f.getName())).toString()));
                    args.add(SafeEncoder.encode((String)gson.toJson((Object)referenceKey)));
                    pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$4(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }
}

