/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.common.collect.Lists;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.RedisEnhancedKeyValueAdapter;
import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.audit.EntityAuditor;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.RedisEnhancedRepository;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.EntityStreamImpl;
import com.redis.om.spring.search.stream.FluentQueryByExample;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.FeatureExtractor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;

public class SimpleRedisEnhancedRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisEnhancedRepository<T, ID> {
    protected final RedisModulesOperations<String> modulesOperations;
    protected final EntityInformation<T, ID> metadata;
    protected final KeyValueOperations operations;
    protected final RediSearchIndexer indexer;
    protected final MappingRedisOMConverter mappingConverter;
    protected final RedisEnhancedKeyValueAdapter enhancedKeyValueAdapter;
    protected final EntityAuditor auditor;
    protected final FeatureExtractor featureExtractor;
    private final ULIDIdentifierGenerator generator;
    private final RedisOMProperties properties;
    private final EntityStream entityStream;

    public SimpleRedisEnhancedRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, RediSearchIndexer indexer, FeatureExtractor featureExtractor, RedisOMProperties properties) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.indexer = indexer;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl((RedisOperations)this.modulesOperations.template()));
        this.enhancedKeyValueAdapter = new RedisEnhancedKeyValueAdapter((RedisOperations<?, ?>)rmo.template(), rmo, indexer, featureExtractor, properties);
        this.generator = ULIDIdentifierGenerator.INSTANCE;
        this.auditor = new EntityAuditor((RedisOperations<?, ?>)this.modulesOperations.template());
        this.featureExtractor = featureExtractor;
        this.properties = properties;
        this.entityStream = new EntityStreamImpl(this.modulesOperations, this.modulesOperations.gsonBuilder(), indexer);
    }

    @Override
    public Iterable<ID> getIds() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        List<Object> result = List.of();
        if (maybeSearchIndex.isPresent()) {
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(maybeSearchIndex.get());
            Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(this.metadata.getJavaType());
            String idField = maybeIdField.map(Field::getName).orElse("id");
            Query query = new Query("*");
            query.limit(Integer.valueOf(0), Integer.valueOf(10000));
            query.returnFields(new String[]{idField});
            SearchResult searchResult = searchOps.search(query);
            result = searchResult.getDocuments().stream().map(d -> ObjectUtils.documentToObject(d, this.metadata.getJavaType(), this.mappingConverter)).map(e -> ObjectUtils.getIdFieldForEntity((Field)maybeIdField.get(), e)).toList();
        }
        return result;
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        ArrayList ids = Lists.newArrayList(this.getIds());
        int fromIndex = Long.valueOf(pageable.getOffset()).intValue();
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        PartialUpdate update = new PartialUpdate((Object)this.metadata.getId(entity).toString(), this.metadata.getJavaType()).set(field.getSearchAlias(), value);
        this.enhancedKeyValueAdapter.update(update);
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        StringRedisTemplate template = this.modulesOperations.template();
        List<String> keys = StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toList();
        return keys.stream().map(arg_0 -> SimpleRedisEnhancedRepository.lambda$getFieldsByIds$2((RedisTemplate)template, field, arg_0)).collect(Collectors.toList());
    }

    @Override
    public Long getExpiration(ID id) {
        StringRedisTemplate template = this.modulesOperations.template();
        return template.getExpire((Object)this.getKey(id));
    }

    public List<T> findAll() {
        return IterableConverter.toList((Iterable)this.operations.findAll(this.metadata.getJavaType()));
    }

    public List<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.properties.getRepository().getQuery().getLimit(), (Sort)sort);
        return this.findAll((Pageable)pageRequest).toList();
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        if (this.indexer.indexExistsFor(this.metadata.getJavaType())) {
            Optional<String> maybeSearchIndex = this.indexer.getIndexName(this.metadata.getJavaType());
            if (maybeSearchIndex.isPresent()) {
                String searchIndex = maybeSearchIndex.get();
                SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
                Query query = new Query("*");
                query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
                pageable.getSort();
                for (Sort.Order order : pageable.getSort()) {
                    query.setSortBy(order.getProperty(), order.isAscending());
                }
                SearchResult searchResult = searchOps.search(query);
                List<Object> content = searchResult.getDocuments().stream().map(d -> ObjectUtils.documentToObject(d, this.metadata.getJavaType(), this.mappingConverter)).toList();
                return new PageImpl(content, pageable, searchResult.getTotalResults());
            }
            return Page.empty();
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.metadata.getJavaType());
        return new PageImpl(IterableConverter.toList((Iterable)content), pageable, this.operations.count(this.metadata.getJavaType()));
    }

    private String getKeyspace() {
        return this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    private String getKey(Object id) {
        return this.getKeyspace() + id.toString();
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        try (Jedis jedis = this.modulesOperations.client().getJedis().get();){
            Pipeline pipeline = jedis.pipelined();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : (String)keyValueEntity.getPropertyAccessor(entity).getProperty(keyValueEntity.getIdProperty());
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, id.toString());
                this.auditor.processEntity(entity, isNew);
                this.featureExtractor.processEntity(entity);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                pipeline.hmset(objectKey, rdo.getBucket().rawMap());
                if (this.expires(rdo)) {
                    pipeline.expire(objectKey, rdo.getTimeToLive().longValue());
                }
                saved.add(entity);
            }
            pipeline.sync();
        }
        return saved;
    }

    public byte[] createKey(String keyspace, String id) {
        return this.mappingConverter.toBytes(keyspace + ":" + id);
    }

    private boolean expires(RedisData data) {
        return data.getTimeToLive() != null && data.getTimeToLive() > 0L;
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).findFirst();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).collect(Collectors.toList());
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.entityStream.of(example.getProbeType()).filter(example).sorted(sort).collect(Collectors.toList());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        return ObjectUtils.pageFromSlice(this.entityStream.of(example.getProbeType()).filter(example).getSlice(pageable));
    }

    public <S extends T> long count(Example<S> example) {
        return this.entityStream.of(example.getProbeType()).filter(example).count();
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new FluentQueryByExample<S>(example, example.getProbeType(), this.entityStream, this.getSearchOps()));
    }

    private SearchOperations<String> getSearchOps() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        return this.modulesOperations.opsForSearch(maybeSearchIndex.get());
    }

    private static /* synthetic */ Object lambda$getFieldsByIds$2(RedisTemplate template, MetamodelField field, String key) {
        return template.opsForHash().get((Object)key, (Object)field.getSearchAlias());
    }
}

