/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.MetamodelUtils;
import com.redis.om.spring.metamodel.indexed.NumericField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.search.stream.AggregationPage;
import com.redis.om.spring.search.stream.AggregationPageable;
import com.redis.om.spring.search.stream.AggregationStream;
import com.redis.om.spring.search.stream.AggregationStreamImpl;
import com.redis.om.spring.search.stream.ExampleToNodeConverter;
import com.redis.om.spring.search.stream.ReturnFieldsSearchStreamImpl;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.SummarizeParams;
import com.redis.om.spring.search.stream.WrapperSearchStream;
import com.redis.om.spring.search.stream.actions.TakesJSONOperations;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import com.redis.om.spring.search.stream.predicates.vector.KNNPredicate;
import com.redis.om.spring.tuple.AbstractTupleMapper;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.TupleMapper;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.util.SearchResultRawResponseToObjectConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.aggr.SortedField;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.util.SafeEncoder;

public class SearchStreamImpl<E>
implements SearchStream<E> {
    private static final Log logger = LogFactory.getLog(SearchStreamImpl.class);
    private static final Integer MAX_LIMIT = 10000;
    private final RedisModulesOperations<String> modulesOperations;
    private final SearchOperations<String> search;
    private final JSONOperations<String> json;
    private final String searchIndex;
    private final Class<E> entityClass;
    private Node rootNode = QueryBuilders.union((Node[])new Node[0]);
    private final GsonBuilder gsonBuilder;
    private Gson gson;
    private Long limit;
    private Long skip;
    private SortedField sortBy;
    private boolean onlyIds = false;
    private final Field idField;
    private Runnable closeHandler;
    private Stream<E> resolvedStream;
    private KNNPredicate<E, ?> knnPredicate;
    private final boolean isDocument;
    private final MappingRedisOMConverter mappingConverter;
    private int dialect = 1;
    private final List<MetamodelField<E, ?>> projections = new ArrayList();
    private final List<MetamodelField<E, ?>> summaryFields = new ArrayList();
    private SummarizeParams summarizeParams;
    private final List<MetamodelField<E, ?>> highlightFields = new ArrayList();
    private Pair<String, String> highlightTags;
    private final ExampleToNodeConverter<E> exampleToNodeConverter;

    public SearchStreamImpl(Class<E> entityClass, RedisModulesOperations<String> modulesOperations, GsonBuilder gsonBuilder, RediSearchIndexer indexer) {
        this.modulesOperations = modulesOperations;
        this.entityClass = entityClass;
        this.searchIndex = entityClass.getName() + "Idx";
        this.search = modulesOperations.opsForSearch(this.searchIndex);
        this.json = modulesOperations.opsForJSON();
        this.gsonBuilder = gsonBuilder;
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(entityClass);
        if (!maybeIdField.isPresent()) {
            throw new IllegalArgumentException(entityClass.getName() + " does not appear to have an ID field");
        }
        this.idField = maybeIdField.get();
        this.isDocument = entityClass.isAnnotationPresent(Document.class);
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl((RedisOperations)modulesOperations.template()));
        this.exampleToNodeConverter = new ExampleToNodeConverter(indexer);
    }

    @Override
    public SearchStream<E> filter(SearchFieldPredicate<? super E, ?> predicate) {
        if (predicate instanceof KNNPredicate) {
            this.knnPredicate = (KNNPredicate)predicate;
        } else {
            this.rootNode = this.processPredicate(predicate);
        }
        return this;
    }

    @Override
    public SearchStream<E> filter(Predicate<?> predicate) {
        this.rootNode = this.processPredicate(predicate);
        return this;
    }

    @Override
    public SearchStream<E> filter(final String freeText) {
        Node freeTextNode = new Node(){

            public String toString() {
                return freeText;
            }

            public String toString(Node.Parenthesize mode) {
                return switch (mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case Node.Parenthesize.NEVER -> this.toString();
                    case Node.Parenthesize.ALWAYS, Node.Parenthesize.DEFAULT -> String.format("(%s)", this);
                };
            }
        };
        this.rootNode = this.rootNode.toString().isBlank() ? freeTextNode : QueryBuilders.intersect((Node[])new Node[]{this.rootNode, freeTextNode});
        return this;
    }

    @Override
    public SearchStream<E> filter(Example<E> example) {
        this.rootNode = this.exampleToNodeConverter.processExample(example, this.rootNode);
        return this;
    }

    public Node processPredicate(SearchFieldPredicate<? super E, ?> predicate) {
        return predicate.apply(this.rootNode);
    }

    private Node processPredicate(Predicate<?> predicate) {
        if (SearchFieldPredicate.class.isAssignableFrom(predicate.getClass())) {
            SearchFieldPredicate p = (SearchFieldPredicate)predicate;
            return this.processPredicate(p);
        }
        return this.rootNode;
    }

    @Override
    public <T> SearchStream<T> map(Function<? super E, ? extends T> mapper) {
        ArrayList returning = new ArrayList();
        if (MetamodelField.class.isAssignableFrom(mapper.getClass())) {
            MetamodelField foi = (MetamodelField)mapper;
            returning.add(foi);
        } else if (TupleMapper.class.isAssignableFrom(mapper.getClass())) {
            AbstractTupleMapper tm = (AbstractTupleMapper)mapper;
            IntStream.range(0, tm.degree()).forEach((int i) -> {
                MetamodelField foi = (MetamodelField)tm.get(i);
                returning.add(foi);
            });
        } else {
            if (TakesJSONOperations.class.isAssignableFrom(mapper.getClass())) {
                TakesJSONOperations tjo = (TakesJSONOperations)((Object)mapper);
                tjo.setJSONOperations(this.json);
            }
            return new WrapperSearchStream<T>(this.resolveStream().map(mapper));
        }
        return new ReturnFieldsSearchStreamImpl(this, returning, this.mappingConverter, this.getGson(), this.isDocument);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super E> mapper) {
        return this.resolveStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super E> mapper) {
        return this.resolveStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super E> mapper) {
        return this.resolveStream().mapToDouble(mapper);
    }

    @Override
    public <R> SearchStream<R> flatMap(Function<? super E, ? extends Stream<? extends R>> mapper) {
        return new WrapperSearchStream(this.resolveStream().flatMap(mapper));
    }

    @Override
    public IntStream flatMapToInt(Function<? super E, ? extends IntStream> mapper) {
        return this.resolveStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super E, ? extends LongStream> mapper) {
        return this.resolveStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super E, ? extends DoubleStream> mapper) {
        return this.resolveStream().flatMapToDouble(mapper);
    }

    @Override
    public SearchStream<E> sorted(Comparator<? super E> comparator) {
        if (MetamodelField.class.isAssignableFrom(comparator.getClass())) {
            MetamodelField foi = (MetamodelField)comparator;
            this.sortBy = SortedField.asc((String)foi.getSearchAlias());
        }
        return this;
    }

    @Override
    public SearchStream<E> sorted(Comparator<? super E> comparator, SortedField.SortOrder order) {
        if (MetamodelField.class.isAssignableFrom(comparator.getClass())) {
            MetamodelField foi = (MetamodelField)comparator;
            this.sortBy = new SortedField(foi.getSearchAlias(), order);
        }
        return this;
    }

    @Override
    public SearchStream<E> sorted(Sort sort) {
        Optional maybeOrder = sort.stream().sorted().findFirst();
        if (maybeOrder.isPresent()) {
            Sort.Order order = (Sort.Order)maybeOrder.get();
            this.sortBy = new SortedField(order.getProperty(), order.isAscending() ? SortedField.SortOrder.ASC : SortedField.SortOrder.DESC);
        }
        return this;
    }

    @Override
    public SearchStream<E> peek(Consumer<? super E> action) {
        return new WrapperSearchStream<E>(this.resolveStream().peek(action));
    }

    @Override
    public SearchStream<E> limit(long maxSize) {
        this.limit = maxSize;
        return this;
    }

    @Override
    public SearchStream<E> skip(long s) {
        this.skip = s;
        return this;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        if (TakesJSONOperations.class.isAssignableFrom(action.getClass())) {
            TakesJSONOperations tjo = (TakesJSONOperations)((Object)action);
            tjo.setJSONOperations(this.json);
        }
        this.resolveStream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super E> action) {
        this.resolveStream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.resolveStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.resolveStream().toArray(generator);
    }

    @Override
    public E reduce(E identity, BinaryOperator<E> accumulator) {
        return this.resolveStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<E> reduce(BinaryOperator<E> accumulator) {
        return this.resolveStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super E, U> accumulator, BinaryOperator<U> combiner) {
        return this.resolveStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super E> accumulator, BiConsumer<R, R> combiner) {
        return this.resolveStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super E, A, R> collector) {
        return this.resolveStream().collect(collector);
    }

    @Override
    public Optional<E> min(Comparator<? super E> comparator) {
        return this.resolveStream().min(comparator);
    }

    @Override
    public Optional<E> max(Comparator<? super E> comparator) {
        return this.resolveStream().max(comparator);
    }

    @Override
    public long count() {
        Query query = this.rootNode.toString().isBlank() ? new Query() : new Query(this.rootNode.toString());
        query.limit(Integer.valueOf(0), Integer.valueOf(0));
        SearchResult searchResult = this.search.search(query);
        return searchResult.getTotalResults();
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        return this.resolveStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        return this.resolveStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super E> predicate) {
        return this.resolveStream().noneMatch(predicate);
    }

    @Override
    public Optional<E> findFirst() {
        this.limit = 1L;
        return this.resolveStream().findFirst();
    }

    @Override
    public Optional<E> findAny() {
        return this.findFirst();
    }

    @Override
    public Iterator<E> iterator() {
        return this.resolveStream().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.resolveStream().spliterator();
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public SearchStream<E> sequential() {
        return this;
    }

    @Override
    public SearchStream<E> parallel() {
        return this;
    }

    @Override
    public SearchStream<E> unordered() {
        return this;
    }

    @Override
    public SearchStream<E> onClose(Runnable closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public void close() {
        if (this.closeHandler == null) {
            this.resolveStream().close();
        } else {
            ((Stream)this.resolveStream().onClose(this.closeHandler)).close();
        }
    }

    SearchOperations<String> getOps() {
        return this.search;
    }

    Query prepareQuery() {
        ArrayList fields;
        Query query;
        if (this.knnPredicate != null) {
            query = new Query(this.knnPredicate.apply(this.rootNode).toString());
            query.addParam(this.knnPredicate.getBlobAttributeName(), (Object)(this.knnPredicate.getBlobAttribute() != null ? this.knnPredicate.getBlobAttribute() : ObjectUtils.floatArrayToByteArray(this.knnPredicate.getDoublesAttribute())));
            query.addParam("K", (Object)this.knnPredicate.getK());
            query.dialect(2);
        } else {
            query = this.rootNode.toString().isBlank() ? new Query() : new Query(this.rootNode.toString());
            query.dialect(this.dialect);
        }
        query.limit(Integer.valueOf(this.skip != null ? this.skip.intValue() : 0), Integer.valueOf(this.limit != null ? this.limit.intValue() : MAX_LIMIT.intValue()));
        if (this.sortBy != null) {
            SortedField sortField = this.sortBy;
            query.setSortBy(sortField.getField(), sortField.getOrder().equals("ASC"));
        }
        if (!this.summaryFields.isEmpty()) {
            fields = this.summaryFields.stream().map((? super T foi) -> ObjectUtils.isCollection(foi.getTargetClass()) ? "$." + foi.getSearchAlias() : foi.getSearchAlias()).collect(Collectors.toCollection(ArrayList::new));
            if (this.summarizeParams == null) {
                query.summarizeFields((String[])fields.toArray(String[]::new));
            } else {
                query.summarizeFields(this.summarizeParams.getFragSize().intValue(), this.summarizeParams.getFragsNum().intValue(), this.summarizeParams.getSeparator(), (String[])fields.toArray(String[]::new));
            }
        }
        if (!this.highlightFields.isEmpty()) {
            fields = this.highlightFields.stream().map((? super T foi) -> ObjectUtils.isCollection(foi.getTargetClass()) ? "$." + foi.getSearchAlias() : foi.getSearchAlias()).collect(Collectors.toCollection(ArrayList::new));
            if (this.highlightTags == null) {
                query.highlightFields((String[])fields.toArray(String[]::new));
            } else {
                Query.HighlightTags tags = new Query.HighlightTags(this.highlightTags.getFirst(), this.highlightTags.getSecond());
                query.highlightFields(tags, (String[])fields.toArray(String[]::new));
            }
        }
        if (this.onlyIds) {
            query.returnFields(new String[]{this.idField.getName()});
        } else if (!this.projections.isEmpty()) {
            ArrayList returnFields = this.projections.stream().map((? super T foi) -> ObjectUtils.isCollection(foi.getTargetClass()) ? "$." + foi.getSearchAlias() : foi.getSearchAlias()).collect(Collectors.toCollection(ArrayList::new));
            returnFields.add(this.idField.getName());
            query.returnFields((String[])returnFields.toArray(String[]::new));
        }
        return query;
    }

    private SearchResult executeQuery() {
        return this.search.search(this.prepareQuery());
    }

    private List<E> toEntityList(SearchResult searchResult) {
        if (this.projections.isEmpty()) {
            if (this.isDocument) {
                Gson g = this.getGson();
                return searchResult.getDocuments().stream().map((? super T d) -> g.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), this.entityClass)).toList();
            }
            return searchResult.getDocuments().stream().map((? super T d) -> ObjectUtils.documentToObject(d, this.entityClass, this.mappingConverter)).toList();
        }
        ArrayList projectedEntities = new ArrayList();
        searchResult.getDocuments().forEach((? super T doc) -> {
            Map<String, Object> props = StreamSupport.stream(doc.getProperties().spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Object entity = BeanUtils.instantiateClass(this.entityClass);
            this.projections.forEach((? super T foi) -> {
                String field = foi.getSearchAlias();
                Class<?> targetClass = foi.getTargetClass();
                Object rawValue = props.get(ObjectUtils.isCollection(targetClass) ? "$." + field : field);
                Object processValue = SearchResultRawResponseToObjectConverter.process(rawValue, targetClass, this.getGson());
                if (processValue != null) {
                    try {
                        foi.getSearchFieldAccessor().getField().set(entity, processValue);
                    }
                    catch (IllegalAccessException e) {
                        logger.debug((Object)("\ud83e\udde8 couldn't set value on " + field), (Throwable)e);
                    }
                }
            });
            projectedEntities.add(entity);
        });
        return projectedEntities;
    }

    private Stream<E> resolveStream() {
        if (this.resolvedStream == null) {
            this.resolvedStream = this.toEntityList(this.executeQuery()).stream();
        }
        return this.resolvedStream;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Stream<Long> map(ToLongFunction<? super E> mapper) {
        Stream<Long> result = Stream.empty();
        if (TakesJSONOperations.class.isAssignableFrom(mapper.getClass())) {
            TakesJSONOperations tjo = (TakesJSONOperations)((Object)mapper);
            tjo.setJSONOperations(this.json);
            this.onlyIds = true;
            Method idSetter = ObjectUtils.getSetterForField(this.entityClass, this.idField);
            Stream<Object> wrappedIds = this.executeQuery().getDocuments().stream().map((? super T d) -> {
                try {
                    String key = this.idField.getType().getDeclaredConstructor(this.idField.getType()).newInstance(d.getId()).toString();
                    return key.substring(key.indexOf(":") + 1);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).map((? super T id) -> {
                Object entity;
                try {
                    entity = this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    idSetter.invoke(entity, id);
                }
                catch (Exception e) {
                    entity = null;
                }
                return entity;
            });
            result = wrappedIds.mapToLong(mapper).boxed();
        }
        return result;
    }

    @Override
    public Stream<Map<String, Object>> mapToLabelledMaps() {
        throw new UnsupportedOperationException("mapToLabelledMaps is not supported on a SearchStream");
    }

    @Override
    @SafeVarargs
    public final <R> AggregationStream<R> groupBy(MetamodelField<E, ?> ... fields) {
        String query = this.rootNode.toString().isBlank() ? "*" : this.rootNode.toString();
        return new AggregationStreamImpl(this.searchIndex, this.modulesOperations, this.getGson(), this.entityClass, query, fields);
    }

    @Override
    public <R> AggregationStream<R> apply(String expression, String alias) {
        String query = this.rootNode.toString().isBlank() ? "*" : this.rootNode.toString();
        AggregationStreamImpl aggregationStream = new AggregationStreamImpl(this.searchIndex, this.modulesOperations, this.getGson(), this.entityClass, query, new MetamodelField[0]);
        aggregationStream.apply(expression, alias);
        return aggregationStream;
    }

    @Override
    @SafeVarargs
    public final <R> AggregationStream<R> load(MetamodelField<E, ?> ... fields) {
        String query = this.rootNode.toString().isBlank() ? "*" : this.rootNode.toString();
        AggregationStreamImpl aggregationStream = new AggregationStreamImpl(this.searchIndex, this.modulesOperations, this.getGson(), this.entityClass, query, new MetamodelField[0]);
        aggregationStream.load(fields);
        return aggregationStream;
    }

    @Override
    public <R> AggregationStream<R> loadAll() {
        String query = this.rootNode.toString().isBlank() ? "*" : this.rootNode.toString();
        AggregationStreamImpl aggregationStream = new AggregationStreamImpl(this.searchIndex, this.modulesOperations, this.getGson(), this.entityClass, query, new MetamodelField[0]);
        aggregationStream.loadAll();
        return aggregationStream;
    }

    @Override
    public <R> AggregationStream<R> cursor(int count, Duration timeout) {
        String query = this.rootNode.toString().isBlank() ? "*" : this.rootNode.toString();
        AggregationStreamImpl aggregationStream = new AggregationStreamImpl(this.searchIndex, this.modulesOperations, this.getGson(), this.entityClass, query, new MetamodelField[0]);
        aggregationStream.cursor(count, timeout);
        return aggregationStream;
    }

    @Override
    public Optional<E> min(NumericField<E, ?> field) {
        List minByField = this.load(new MetamodelField("__key", String.class)).sorted(Sort.Order.asc((String)("@" + field.getSearchAlias()))).limit(1).toList(String.class, Double.class);
        return minByField.isEmpty() ? Optional.empty() : Optional.ofNullable(this.json.get((String)((Pair)minByField.get(0)).getFirst(), this.entityClass));
    }

    @Override
    public Optional<E> max(NumericField<E, ?> field) {
        List maxByField = this.load(new MetamodelField("__key", String.class)).sorted(1, Sort.Order.desc((String)("@" + field.getSearchAlias()))).limit(1).toList(String.class, Double.class);
        return maxByField.isEmpty() ? Optional.empty() : Optional.ofNullable(this.json.get((String)((Pair)maxByField.get(0)).getFirst(), this.entityClass));
    }

    @Override
    public SearchStream<E> dialect(int dialect) {
        this.dialect = dialect;
        return this;
    }

    @Override
    public SearchOperations<String> getSearchOperations() {
        return this.search;
    }

    @Override
    public Slice<E> getSlice(Pageable pageable) {
        if (pageable.getClass().isAssignableFrom(AggregationPageable.class)) {
            AggregationPageable ap = (AggregationPageable)pageable;
            AggregationResult ar = this.search.cursorRead(ap.getCursorId(), pageable.getPageSize());
            return new AggregationPage<E>(ar, pageable, this.entityClass, this.getGson(), this.mappingConverter, this.isDocument);
        }
        return Page.empty((Pageable)pageable);
    }

    @Override
    public <R> SearchStream<E> project(Function<? super E, ? extends R> field) {
        if (MetamodelField.class.isAssignableFrom(field.getClass())) {
            MetamodelField foi = (MetamodelField)field;
            this.projections.add(foi);
        } else if (TupleMapper.class.isAssignableFrom(field.getClass())) {
            AbstractTupleMapper tm = (AbstractTupleMapper)field;
            IntStream.range(0, tm.degree()).forEach((int i) -> {
                MetamodelField foi = (MetamodelField)tm.get(i);
                this.projections.add(foi);
            });
        }
        this.projections.add(MetamodelUtils.getMetamodelForIdField(this.entityClass));
        return this;
    }

    @Override
    public <R> SearchStream<E> project(MetamodelField<? super E, ? extends R> ... fields) {
        for (MetamodelField<? super E, ? extends R> field : fields) {
            this.projections.add(field);
        }
        return this;
    }

    @Override
    public String backingQuery() {
        return this.rootNode.toString();
    }

    @Override
    public <R> SearchStream<E> summarize(Function<? super E, ? extends R> field) {
        if (MetamodelField.class.isAssignableFrom(field.getClass())) {
            MetamodelField foi = (MetamodelField)field;
            this.summaryFields.add(foi);
        } else if (TupleMapper.class.isAssignableFrom(field.getClass())) {
            AbstractTupleMapper tm = (AbstractTupleMapper)field;
            IntStream.range(0, tm.degree()).forEach((int i) -> {
                MetamodelField foi = (MetamodelField)tm.get(i);
                this.summaryFields.add(foi);
            });
        }
        return this;
    }

    @Override
    public <R> SearchStream<E> summarize(Function<? super E, ? extends R> field, SummarizeParams summarizeParams) {
        this.summarizeParams = summarizeParams;
        return this.summarize(field);
    }

    @Override
    public <R> SearchStream<E> highlight(Function<? super E, ? extends R> field) {
        if (MetamodelField.class.isAssignableFrom(field.getClass())) {
            MetamodelField foi = (MetamodelField)field;
            this.highlightFields.add(foi);
        } else if (TupleMapper.class.isAssignableFrom(field.getClass())) {
            AbstractTupleMapper tm = (AbstractTupleMapper)field;
            IntStream.range(0, tm.degree()).forEach((int i) -> {
                MetamodelField foi = (MetamodelField)tm.get(i);
                this.highlightFields.add(foi);
            });
        }
        return this;
    }

    @Override
    public <R> SearchStream<E> highlight(Function<? super E, ? extends R> field, Pair<String, String> tags) {
        this.highlightTags = tags;
        return this.highlight(field);
    }

    public boolean isDocument() {
        return this.isDocument;
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = this.gsonBuilder.create();
        }
        return this.gson;
    }
}

