/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReferenceDeserializer
implements JsonDeserializer<Object> {
    private static final Log logger = LogFactory.getLog(ReferenceDeserializer.class);
    private final Class<?> type;
    private final ObjectConstructor<?> objectConstructor;
    private final JSONOperations<String> ops;

    public ReferenceDeserializer(Field field, JSONOperations<?> ops) {
        Optional<Class<?>> collectionType;
        this.ops = ops;
        HashMap instanceCreators = new HashMap();
        ConstructorConstructor constructorConstructor = new ConstructorConstructor(instanceCreators, true, Collections.emptyList());
        this.type = ObjectUtils.isCollection(field) ? ((collectionType = ObjectUtils.getCollectionElementClass(field)).isPresent() ? collectionType.get() : field.getType()) : field.getType();
        this.objectConstructor = constructorConstructor.get(TypeToken.get(this.type));
    }

    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object reference = null;
        if (json.isJsonPrimitive()) {
            String referenceKey = ObjectUtils.unQuote(json.toString());
            String referenceJSON = this.ops.get(referenceKey);
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(referenceJSON, JsonObject.class);
            reference = this.deserializeEntity(jsonObject, context);
        } else if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            reference = this.deserializeEntity(jsonObject, context);
        } else if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            reference = ObjectUtils.instantiateCollection(typeOfT);
            String[] keys = (String[])jsonArray.asList().stream().filter(JsonElement::isJsonPrimitive).map(jsonElement -> ObjectUtils.unQuote(jsonElement.toString())).toArray(String[]::new);
            if (keys.length > 0) {
                List<String> values = this.ops.mget((String[])keys);
                ((Collection)reference).addAll(values.stream().map(raw -> (JsonObject)new Gson().fromJson(raw, JsonObject.class)).map(jo -> this.deserializeEntity((JsonObject)jo, context)).toList());
            }
        }
        return reference;
    }

    private Object deserializeEntity(JsonObject jsonObject, JsonDeserializationContext context) {
        Object reference = this.objectConstructor.construct();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            try {
                Field field = this.type.getDeclaredField(key);
                Method setter = ObjectUtils.getSetterForField(this.type, field);
                Class<?> fieldType = field.getType();
                Object elementValue = context.deserialize(value, fieldType);
                if (setter != null) {
                    setter.invoke(reference, elementValue);
                    continue;
                }
                field.setAccessible(true);
                field.set(reference, elementValue);
            }
            catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
                logger.error((Object)String.format("Error while deserializing reference of type %s", this.type), (Throwable)e);
            }
        }
        return reference;
    }
}

