/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.mapping;

import jakarta.persistence.IdClass;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.mapping.BasicRedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class RedisEnhancedPersistentEntity<T>
extends BasicRedisPersistentEntity<T>
implements RedisPersistentEntity<T> {
    private final List<RedisPersistentProperty> idProperties = new ArrayList<RedisPersistentProperty>();
    private final boolean hasIdClass;

    public RedisEnhancedPersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver keySpaceResolver, TimeToLiveAccessor timeToLiveAccessor) {
        super(information, keySpaceResolver, timeToLiveAccessor);
        this.hasIdClass = information.getType().isAnnotationPresent(IdClass.class);
    }

    public void addPersistentProperty(RedisPersistentProperty property) {
        if (property.isIdProperty()) {
            if (this.hasIdClass) {
                this.idProperties.add(property);
            } else {
                RedisPersistentProperty existingIdProperty = this.getIdProperty();
                if (existingIdProperty != null) {
                    throw new MappingException(String.format("Attempt to add explicit id property %s but already have a property %s registered as explicit id; Check your mapping configuration", property.getField(), existingIdProperty.getField()));
                }
            }
        }
        super.addPersistentProperty((PersistentProperty)property);
    }

    protected RedisPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(RedisPersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (this.hasIdClass) {
            return property;
        }
        return super.returnPropertyIfBetterIdPropertyCandidateOrNull(property);
    }

    @Nullable
    public RedisPersistentProperty getIdProperty() {
        return this.idProperties.isEmpty() ? (RedisPersistentProperty)super.getIdProperty() : this.idProperties.get(0);
    }

    public List<RedisPersistentProperty> getIdProperties() {
        return this.idProperties;
    }

    public boolean isIdClassComposite() {
        return this.hasIdClass;
    }
}

