/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel.indexed;

import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.actions.ArrayAppendAction;
import com.redis.om.spring.search.stream.actions.ArrayIndexOfAction;
import com.redis.om.spring.search.stream.actions.ArrayInsertAction;
import com.redis.om.spring.search.stream.actions.ArrayLengthAction;
import com.redis.om.spring.search.stream.actions.ArrayPopAction;
import com.redis.om.spring.search.stream.actions.ArrayTrimAction;
import com.redis.om.spring.search.stream.predicates.tag.ContainsAllPredicate;
import com.redis.om.spring.search.stream.predicates.tag.EqualPredicate;
import com.redis.om.spring.search.stream.predicates.tag.InPredicate;
import com.redis.om.spring.search.stream.predicates.tag.NotEqualPredicate;
import com.redis.om.spring.util.ObjectUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;

public class TagField<E, T>
extends MetamodelField<E, T> {
    public TagField(SearchFieldAccessor field, boolean indexed) {
        super(field, indexed);
    }

    public TagField(Class<E> targetClass, String fieldName) {
        super(targetClass, fieldName);
    }

    public EqualPredicate<E, T> eq(T value) {
        return new EqualPredicate(this.searchFieldAccessor, value);
    }

    public NotEqualPredicate<E, T> notEq(T value) {
        return new NotEqualPredicate(this.searchFieldAccessor, value);
    }

    public NotEqualPredicate<E, T> notEq(String ... values) {
        return new NotEqualPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }

    public NotEqualPredicate<E, T> notEq(Object ... values) {
        return new NotEqualPredicate(this.searchFieldAccessor, Arrays.stream(values).map(Object::toString).toList());
    }

    public InPredicate<E, ?> in(String ... values) {
        return new InPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }

    public InPredicate<E, ?> in(Object ... values) {
        return new InPredicate(this.searchFieldAccessor, Arrays.stream(values).map(Object::toString).toList());
    }

    public ContainsAllPredicate<E, ?> containsAll(String ... values) {
        return new ContainsAllPredicate(this.searchFieldAccessor, Arrays.asList(values));
    }

    public ContainsAllPredicate<E, ?> containsAll(Object ... values) {
        return new ContainsAllPredicate(this.searchFieldAccessor, Arrays.stream(values).map(Object::toString).toList());
    }

    public NotEqualPredicate<E, T> containsNone(T value) {
        return new NotEqualPredicate(this.searchFieldAccessor, value);
    }

    public NotEqualPredicate<E, ?> containsNone(String value) {
        if (!ObjectUtils.isCollection(value.getClass())) {
            return new NotEqualPredicate(this.searchFieldAccessor, Set.of(value));
        }
        return new NotEqualPredicate(this.searchFieldAccessor, value);
    }

    public Consumer<E> add(Object value) {
        return new ArrayAppendAction(this.searchFieldAccessor, value);
    }

    public Consumer<E> insert(Object value, Integer index) {
        return new ArrayInsertAction(this.searchFieldAccessor, value, index);
    }

    public Consumer<E> prepend(Object value) {
        return new ArrayInsertAction(this.searchFieldAccessor, value, 0);
    }

    public ToLongFunction<E> length() {
        return new ArrayLengthAction(this.searchFieldAccessor);
    }

    public ToLongFunction<E> indexOf(Object element) {
        return new ArrayIndexOfAction(this.searchFieldAccessor, element);
    }

    public <R> ArrayPopAction<E, R> pop(Integer index) {
        return new ArrayPopAction(this.searchFieldAccessor, index);
    }

    public <R> ArrayPopAction<E, R> pop() {
        return this.pop(-1);
    }

    public <R> ArrayPopAction<E, R> removeFirst() {
        return this.pop(0);
    }

    public <R> ArrayPopAction<E, R> removeLast() {
        return this.pop(-1);
    }

    public <R> ArrayPopAction<E, R> remove(Integer index) {
        return this.pop(index);
    }

    public Consumer<E> trimToRange(Integer begin, Integer end) {
        return new ArrayTrimAction(this.searchFieldAccessor, begin, end);
    }
}

