/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.json.JSONOperations;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.springframework.lang.Nullable;
import redis.clients.jedis.json.JsonSetParams;
import redis.clients.jedis.json.Path2;

public class JSONOperationsImpl<K>
implements JSONOperations<K> {
    private final GsonBuilder builder;
    private final RedisModulesClient client;
    private Gson gson;

    public JSONOperationsImpl(RedisModulesClient client, GsonBuilder builder) {
        this.client = client;
        this.builder = builder;
    }

    @Override
    public Long del(K key, Path2 path) {
        return this.client.clientForJSON().jsonDel(key.toString(), path);
    }

    @Override
    @Nullable
    public String get(K key) {
        Object result = this.client.clientForJSON().jsonGet(key.toString(), new Path2[]{Path2.ROOT_PATH});
        if (result instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)result;
            return !jsonArray.isEmpty() ? jsonArray.get(0).toString() : null;
        }
        if (result instanceof LinkedTreeMap) {
            LinkedTreeMap linkedTreeMap = (LinkedTreeMap)result;
            return this.getGson().toJson((Object)linkedTreeMap);
        }
        return result.toString();
    }

    @Override
    public <T> T get(K key, Class<T> clazz) {
        return this.get(key, clazz, Path2.ROOT_PATH);
    }

    @Override
    public <T> T get(K key, Class<T> clazz, Path2 path) {
        String asString;
        Object result = this.client.clientForJSON().jsonGet(key.toString(), new Path2[]{path});
        if (result instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)result;
            return this.extractValueAsClassFromJSONArray(jsonArray, clazz);
        }
        if (result instanceof LinkedTreeMap) {
            LinkedTreeMap linkedTreeMap = (LinkedTreeMap)result;
            asString = this.getGson().toJson((Object)linkedTreeMap);
        } else {
            asString = result != null ? result.toString() : null;
        }
        return (T)(result != null ? this.getGson().fromJson(asString, clazz) : null);
    }

    @Override
    @SafeVarargs
    public final List<String> mget(K ... keys) {
        return keys.length > 0 ? this.client.clientForJSON().jsonMGet(this.getKeysAsString(keys)).stream().filter(Objects::nonNull).map(jsonArr -> jsonArr.get(0)).map(Object::toString).toList() : List.of();
    }

    @Override
    @SafeVarargs
    public final <T> List<T> mget(Class<T> clazz, K ... keys) {
        Gson g = this.getGson();
        return keys.length > 0 ? this.client.clientForJSON().jsonMGet(this.getKeysAsString(keys)).stream().filter(Objects::nonNull).map(jsonArr -> jsonArr.get(0)).map(Object::toString).map(str -> g.fromJson(str, clazz)).toList() : List.of();
    }

    @Override
    @SafeVarargs
    public final <T> List<T> mget(Path2 path, Class<T> clazz, K ... keys) {
        Gson g = this.getGson();
        return keys.length > 0 ? this.client.clientForJSON().jsonMGet(path, this.getKeysAsString(keys)).stream().map(Object::toString).map(str -> g.fromJson(str, clazz)).toList() : List.of();
    }

    @Override
    public void set(K key, Object object) {
        this.client.clientForJSON().jsonSet(key.toString(), Path2.ROOT_PATH, (Object)this.getGson().toJson(object));
    }

    @Override
    public void set(K key, Object object, Path2 path) {
        this.client.clientForJSON().jsonSet(key.toString(), path, (Object)this.getGson().toJson(object));
    }

    @Override
    public void set(K key, Object object, JsonSetParams params) {
        this.client.clientForJSON().jsonSet(key.toString(), object, params);
    }

    @Override
    public void set(K key, Object object, JsonSetParams params, Path2 path) {
        this.client.clientForJSON().jsonSet(key.toString(), path, object, params);
    }

    @Override
    public void setEscaped(K key, Object object, JsonSetParams params, Path2 path) {
        this.client.clientForJSON().jsonSetWithEscape(key.toString(), path, object, params);
    }

    @Override
    public List<Class<?>> type(K key) {
        return this.type(key, Path2.ROOT_PATH);
    }

    @Override
    public List<Class<?>> type(K key, Path2 path) {
        return this.client.clientForJSON().jsonType(key.toString(), path);
    }

    @Override
    public List<Long> strAppend(K key, Path2 path, Object object) {
        return this.client.clientForJSON().jsonStrAppend(key.toString(), path, object);
    }

    @Override
    public List<Long> strLen(K key, Path2 path) {
        return this.client.clientForJSON().jsonStrLen(key.toString(), path);
    }

    @Override
    public List<Long> arrAppend(K key, Path2 path, Object ... objects) {
        return this.client.clientForJSON().jsonArrAppendWithEscape(key.toString(), path, objects);
    }

    @Override
    public List<Long> arrIndex(K key, Path2 path, Object scalar) {
        return this.client.clientForJSON().jsonArrIndexWithEscape(key.toString(), path, scalar);
    }

    @Override
    public List<Long> arrInsert(K key, Path2 path, Integer index, Object ... objects) {
        return this.client.clientForJSON().jsonArrInsertWithEscape(key.toString(), path, index.intValue(), objects);
    }

    @Override
    public List<Long> arrLen(K key, Path2 path) {
        return this.client.clientForJSON().jsonArrLen(key.toString(), path);
    }

    @Override
    public <T> List<T> arrPop(K key, Class<T> clazz, Path2 path, Integer index) {
        return this.client.clientForJSON().jsonArrPop(key.toString(), path, index.intValue()).stream().map(Object::toString).map(str -> this.getGson().fromJson(str, clazz)).toList();
    }

    @Override
    public <T> List<T> arrPop(K key, Class<T> clazz, Path2 path) {
        return this.client.clientForJSON().jsonArrPop(key.toString(), path).stream().map(Object::toString).map(str -> this.getGson().fromJson(str, clazz)).toList();
    }

    @Override
    public <T> List<T> arrPop(K key, Class<T> clazz) {
        return this.arrPop(key, clazz, Path2.ROOT_PATH);
    }

    @Override
    public List<Long> arrTrim(K key, Path2 path, Integer start, Integer stop) {
        return this.client.clientForJSON().jsonArrTrim(key.toString(), path, start.intValue(), stop.intValue());
    }

    @Override
    public void toggle(K key, Path2 path) {
        this.client.clientForJSON().jsonToggle(key.toString(), path);
    }

    @Override
    public List<Double> numIncrBy(K key, Path2 path, Long value) {
        JSONArray result = (JSONArray)this.client.clientForJSON().jsonNumIncrBy(key.toString(), path, (double)value.longValue());
        return result.toList().stream().map(e -> Double.valueOf(e.toString())).toList();
    }

    @SafeVarargs
    private String[] getKeysAsString(K ... keys) {
        return (String[])Arrays.stream(keys).map(Object::toString).toArray(String[]::new);
    }

    private <T> T extractValueAsClassFromJSONArray(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray != null && !jsonArray.isEmpty()) {
            String element = jsonArray.get(0).toString();
            return (T)(switch (clazz.getSimpleName()) {
                case "String" -> element.equals("null") ? null : element;
                case "Integer" -> Integer.valueOf(element);
                case "Long" -> Long.valueOf(element);
                case "Long[]" -> jsonArray.toList().stream().map(e -> Long.valueOf(e.toString())).toArray(Long[]::new);
                case "Double" -> Double.valueOf(element);
                case "Boolean" -> Boolean.valueOf(element);
                default -> this.getGson().fromJson(element, clazz);
            });
        }
        return null;
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = this.builder.create();
        }
        return this.gson;
    }
}

