/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query;

import java.lang.reflect.Field;
import java.util.Set;

public class QueryUtils {
    public static final Set<Character> TAG_ESCAPE_CHARS = Set.of(Character.valueOf(','), Character.valueOf('.'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('~'), Character.valueOf('|'), Character.valueOf('/'));

    private QueryUtils() {
    }

    public static String escape(String text) {
        return QueryUtils.escape(text, false);
    }

    public static String escape(String text, boolean querying) {
        char[] chars;
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = text.toCharArray()) {
            if (TAG_ESCAPE_CHARS.contains(Character.valueOf(c))) {
                sb.append("\\");
            }
            if (querying && c == ' ') {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescape(String text) {
        return text.replace("\\", "");
    }

    public static <T> T escape(T maybeText) {
        return (T)(CharSequence.class.isAssignableFrom(maybeText.getClass()) ? QueryUtils.escape(maybeText.toString()) : maybeText);
    }

    public static String searchIndexFieldAliasFor(Field field, String prefix) {
        Object alias = field.getName();
        if (prefix != null && !prefix.isBlank()) {
            alias = prefix.replace(".", "_") + "_" + (String)alias;
        }
        return alias;
    }
}

