/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.vectorize;

import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.translator.ImageFeatureExtractor;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import com.azure.ai.openai.OpenAIClient;
import com.redis.om.spring.RedisOMAiProperties;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.EmbeddingProvider;
import com.redis.om.spring.annotations.EmbeddingType;
import com.redis.om.spring.annotations.Vectorize;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import com.redis.om.spring.vectorize.FieldData;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingModel;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingOptions;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingModel;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingModel;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.ollama.OllamaEmbeddingModel;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.ai.ollama.api.OllamaModel;
import org.springframework.ai.ollama.api.OllamaOptions;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.transformers.TransformersEmbeddingModel;
import org.springframework.ai.vertexai.embedding.VertexAiEmbeddingConnectionDetails;
import org.springframework.ai.vertexai.embedding.text.VertexAiTextEmbeddingModel;
import org.springframework.ai.vertexai.embedding.text.VertexAiTextEmbeddingOptions;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class DefaultEmbedder
implements Embedder {
    private static final Log logger = LogFactory.getLog(DefaultEmbedder.class);
    public final Pipeline imagePipeline;
    public final TransformersEmbeddingModel transformersEmbeddingModel;
    private final ZooModel<Image, float[]> imageEmbeddingModel;
    private final ZooModel<Image, float[]> faceEmbeddingModel;
    private final ImageFactory imageFactory;
    private final ApplicationContext applicationContext;
    private final ImageFeatureExtractor imageFeatureExtractor;
    private final OpenAiEmbeddingModel defaultOpenAITextVectorizer;
    private final OllamaEmbeddingModel defaultOllamaEmbeddingModel;
    private final RedisOMAiProperties properties;
    private final OllamaApi ollamaApi;
    private final OpenAIClient azureOpenAIClient;
    private final VertexAiTextEmbeddingModel vertexAiTextEmbeddingModel;
    private final BedrockCohereEmbeddingModel bedrockCohereEmbeddingModel;
    private final BedrockTitanEmbeddingModel bedrockTitanEmbeddingModel;

    public DefaultEmbedder(ApplicationContext applicationContext, ZooModel<Image, float[]> imageEmbeddingModel, ZooModel<Image, float[]> faceEmbeddingModel, ImageFactory imageFactory, Pipeline imagePipeline, TransformersEmbeddingModel transformersEmbeddingModel, OpenAiEmbeddingModel openAITextVectorizer, OpenAIClient azureOpenAIClient, VertexAiTextEmbeddingModel vertexAiTextEmbeddingModel, BedrockCohereEmbeddingModel bedrockCohereEmbeddingModel, BedrockTitanEmbeddingModel bedrockTitanEmbeddingModel, RedisOMAiProperties properties) {
        this.applicationContext = applicationContext;
        this.imageEmbeddingModel = imageEmbeddingModel;
        this.faceEmbeddingModel = faceEmbeddingModel;
        this.imageFactory = imageFactory;
        this.imagePipeline = imagePipeline;
        this.transformersEmbeddingModel = transformersEmbeddingModel;
        this.imageFeatureExtractor = ((ImageFeatureExtractor.Builder)ImageFeatureExtractor.builder().setPipeline(imagePipeline)).build();
        this.defaultOpenAITextVectorizer = openAITextVectorizer;
        this.azureOpenAIClient = azureOpenAIClient;
        this.vertexAiTextEmbeddingModel = vertexAiTextEmbeddingModel;
        this.bedrockCohereEmbeddingModel = bedrockCohereEmbeddingModel;
        this.bedrockTitanEmbeddingModel = bedrockTitanEmbeddingModel;
        this.properties = properties;
        this.ollamaApi = new OllamaApi(properties.getOllama().getBaseUrl());
        this.defaultOllamaEmbeddingModel = OllamaEmbeddingModel.builder().ollamaApi(this.ollamaApi).defaultOptions(OllamaOptions.builder().model(OllamaModel.MISTRAL.id()).build()).build();
    }

    private List<byte[]> getImageEmbeddingsAsByteArrayFor(List<InputStream> isList) {
        List<Image> imgs = isList.stream().map(is -> {
            try {
                return this.imageFactory.fromInputStream(is);
            }
            catch (IOException e) {
                logger.warn((Object)"Error generating image embedding", (Throwable)e);
                return null;
            }
        }).toList();
        try {
            if (!imgs.contains(null)) {
                Predictor predictor = this.imageEmbeddingModel.newPredictor((Translator)this.imageFeatureExtractor);
                return predictor.batchPredict(imgs).stream().map(ObjectUtils::floatArrayToByteArray).toList();
            }
        }
        catch (TranslateException e) {
            logger.warn((Object)"Error generating image embedding", (Throwable)e);
        }
        return List.of();
    }

    private byte[] getImageEmbeddingsAsByteArrayFor(InputStream is) {
        try {
            Image img = this.imageFactory.fromInputStream(is);
            Predictor predictor = this.imageEmbeddingModel.newPredictor((Translator)this.imageFeatureExtractor);
            return ObjectUtils.floatArrayToByteArray((float[])predictor.predict((Object)img));
        }
        catch (TranslateException | IOException e) {
            logger.warn((Object)"Error generating image embedding", e);
            return new byte[0];
        }
    }

    private List<float[]> getImageEmbeddingsAsFloatArrayFor(List<InputStream> isList) {
        return this.getImageEmbeddingsAsByteArrayFor(isList).stream().map(ObjectUtils::byteArrayToFloatArray).toList();
    }

    private float[] getImageEmbeddingsAsFloatArrayFor(InputStream is) {
        return ObjectUtils.byteArrayToFloatArray(this.getImageEmbeddingsAsByteArrayFor(is));
    }

    private List<byte[]> getFacialImageEmbeddingsAsByteArrayFor(List<InputStream> isList) {
        return this.getFacialImageEmbeddingsAsFloatArrayFor(isList).stream().map(ObjectUtils::floatArrayToByteArray).toList();
    }

    private byte[] getFacialImageEmbeddingsAsByteArrayFor(InputStream is) throws IOException, TranslateException {
        return ObjectUtils.floatArrayToByteArray(this.getFacialImageEmbeddingsAsFloatArrayFor(is));
    }

    private List<float[]> getFacialImageEmbeddingsAsFloatArrayFor(List<InputStream> isList) {
        List<Image> imgs = isList.stream().map(is -> {
            try {
                return this.imageFactory.fromInputStream(is);
            }
            catch (IOException e) {
                logger.warn((Object)"Error generating face embedding", (Throwable)e);
                return null;
            }
        }).toList();
        if (!imgs.contains(null)) {
            List list;
            block9: {
                Predictor predictor = this.faceEmbeddingModel.newPredictor();
                try {
                    list = predictor.batchPredict(imgs);
                    if (predictor == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (predictor != null) {
                            try {
                                predictor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (TranslateException e) {
                        logger.warn((Object)"Error generating face embedding", (Throwable)e);
                    }
                }
                predictor.close();
            }
            return list;
        }
        return List.of();
    }

    private float[] getFacialImageEmbeddingsAsFloatArrayFor(InputStream is) throws IOException, TranslateException {
        try (Predictor predictor = this.faceEmbeddingModel.newPredictor();){
            Image img = this.imageFactory.fromInputStream(is);
            float[] fArray = (float[])predictor.predict((Object)img);
            return fArray;
        }
    }

    private List<byte[]> getSentenceEmbeddingsAsByteArrayFor(List<String> texts) {
        List encodings = this.transformersEmbeddingModel.embed(texts);
        return encodings.stream().map(ObjectUtils::floatArrayToByteArray).toList();
    }

    private List<byte[]> getEmbeddingsAsByteArrayFor(List<String> texts, EmbeddingModel model) {
        return model.embed(texts).stream().map(ObjectUtils::floatArrayToByteArray).toList();
    }

    private List<float[]> getEmbeddingAsFloatArrayFor(List<String> texts, EmbeddingModel model) {
        return model.embed(texts);
    }

    private byte[] getEmbeddingsAsByteArrayFor(String text, EmbeddingModel model) {
        return ObjectUtils.floatArrayToByteArray(model.embed(text));
    }

    private float[] getEmbeddingAsFloatArrayFor(String text, EmbeddingModel model) {
        return model.embed(text);
    }

    @Override
    public void processEntity(Object item) {
        if (!this.isReady()) {
            return;
        }
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Vectorize.class);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> this.lambda$processEntity$2((PropertyAccessor)accessor, item, arg_0));
        }
    }

    @Override
    public <S> void processEntities(Iterable<S> items) {
        if (!this.isReady()) {
            return;
        }
        int batchSize = this.properties.getEmbeddingBatchSize();
        ArrayList<FieldData> batch = new ArrayList<FieldData>(batchSize);
        for (S item : items) {
            List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Vectorize.class);
            if (fields.isEmpty()) continue;
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess(item);
            boolean isDocument = item.getClass().isAnnotationPresent(Document.class);
            for (Field field : fields) {
                Vectorize vectorize = field.getAnnotation(Vectorize.class);
                Object fieldValue = accessor.getPropertyValue(field.getName());
                if (fieldValue != null) {
                    batch.add(new FieldData(vectorize, item, field, (PropertyAccessor)accessor, fieldValue, isDocument));
                }
                if (batch.size() < batchSize) continue;
                this.processBatch(batch);
                batch.clear();
            }
        }
        if (!batch.isEmpty()) {
            this.processBatch(batch);
        }
    }

    private void processBatch(List<FieldData> batch) {
        batch.stream().collect(Collectors.groupingBy(fd -> fd.vectorize().embeddingType())).forEach(this::vectorizeBatch);
    }

    private void vectorizeBatch(EmbeddingType embeddingType, List<FieldData> fieldDataList) {
        switch (embeddingType) {
            case IMAGE: {
                this.processImageEmbedding(fieldDataList);
                break;
            }
            case WORD: {
                break;
            }
            case FACE: {
                this.processFaceEmbedding(fieldDataList);
                break;
            }
            case SENTENCE: {
                this.processSentencesEmbedding(fieldDataList);
            }
        }
    }

    private void processImageEmbedding(List<FieldData> fieldDataList) {
        fieldDataList.stream().collect(Collectors.groupingBy(FieldData::isDocument)).forEach((isDocument, groupedByIsDocument) -> groupedByIsDocument.stream().collect(Collectors.groupingBy(FieldData::vectorize)).forEach((vectorize, groupedByVectorize) -> {
            List<float[]> embeddings;
            List<Object[]> list = embeddings = isDocument != false ? this.getImageEmbeddingsAsFloatArrayFor(this.mapValuesToResources((List<FieldData>)groupedByVectorize)) : this.getImageEmbeddingsAsByteArrayFor(this.mapValuesToResources((List<FieldData>)groupedByVectorize));
            if (embeddings != null) {
                this.applyEmbeddings((List<FieldData>)groupedByVectorize, embeddings, (Vectorize)vectorize);
            }
        }));
    }

    private List<InputStream> mapValuesToResources(List<FieldData> fieldDataList) {
        List<InputStream> resources = fieldDataList.stream().map(it -> {
            try {
                return this.applicationContext.getResource(it.value().toString()).getInputStream();
            }
            catch (IOException e) {
                logger.info((Object)("Error embedding image: ()" + String.valueOf(it.value())));
                return null;
            }
        }).toList();
        return resources.contains(null) ? List.of() : resources;
    }

    private void processImageEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        Resource resource = this.applicationContext.getResource(fieldValue.toString());
        try {
            if (isDocument) {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getImageEmbeddingsAsFloatArrayFor(resource.getInputStream()));
            } else {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getImageEmbeddingsAsByteArrayFor(resource.getInputStream()));
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error generating image embedding", (Throwable)e);
        }
    }

    private void processFaceEmbedding(List<FieldData> fieldDataList) {
        fieldDataList.stream().collect(Collectors.groupingBy(FieldData::isDocument)).forEach((isDocument, groupedByIsDocument) -> groupedByIsDocument.stream().collect(Collectors.groupingBy(FieldData::vectorize)).forEach((vectorize, groupedByVectorize) -> {
            List<float[]> embeddings;
            List<Object[]> list = embeddings = isDocument != false ? this.getFacialImageEmbeddingsAsFloatArrayFor(this.mapValuesToResources((List<FieldData>)groupedByVectorize)) : this.getFacialImageEmbeddingsAsByteArrayFor(this.mapValuesToResources((List<FieldData>)groupedByVectorize));
            if (embeddings != null) {
                this.applyEmbeddings((List<FieldData>)groupedByVectorize, embeddings, (Vectorize)vectorize);
            }
        }));
    }

    private void processFaceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        Resource resource = this.applicationContext.getResource(fieldValue.toString());
        try {
            if (isDocument) {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getFacialImageEmbeddingsAsFloatArrayFor(resource.getInputStream()));
            } else {
                accessor.setPropertyValue(vectorize.destination(), (Object)this.getFacialImageEmbeddingsAsByteArrayFor(resource.getInputStream()));
            }
        }
        catch (TranslateException | IOException e) {
            logger.warn((Object)"Error generating facial image embedding", e);
        }
    }

    private void processSentencesEmbedding(List<FieldData> fieldDataList) {
        fieldDataList.stream().collect(Collectors.groupingBy(it -> it.vectorize().provider())).forEach((provider, groupedFieldDataList) -> {
            switch (provider) {
                case TRANSFORMERS: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getTransformersEmbeddingModel);
                    break;
                }
                case DJL: {
                    break;
                }
                case OPENAI: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getOpenAiEmbeddingModel);
                    break;
                }
                case OLLAMA: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getOllamaEmbeddingModel);
                    break;
                }
                case AZURE_OPENAI: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getAzureOpenAiEmbeddingModel);
                    break;
                }
                case VERTEX_AI: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getVertexAiPaLm2EmbeddingModel);
                    break;
                }
                case AMAZON_BEDROCK_COHERE: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getBedrockCohereEmbeddingModel);
                    break;
                }
                case AMAZON_BEDROCK_TITAN: {
                    this.processSentenceEmbedding((List<FieldData>)groupedFieldDataList, this::getBedrockTitanEmbeddingModel);
                }
            }
        });
    }

    private void processSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument) {
        switch (vectorize.provider()) {
            case TRANSFORMERS: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getTransformersEmbeddingModel);
                break;
            }
            case DJL: {
                break;
            }
            case OPENAI: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getOpenAiEmbeddingModel);
                break;
            }
            case OLLAMA: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getOllamaEmbeddingModel);
                break;
            }
            case AZURE_OPENAI: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getAzureOpenAiEmbeddingModel);
                break;
            }
            case VERTEX_AI: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getVertexAiPaLm2EmbeddingModel);
                break;
            }
            case AMAZON_BEDROCK_COHERE: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getBedrockCohereEmbeddingModel);
                break;
            }
            case AMAZON_BEDROCK_TITAN: {
                this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument, this::getBedrockTitanEmbeddingModel);
            }
        }
    }

    private List<String> mapValues(List<FieldData> fieldDataList) {
        return fieldDataList.stream().map(it -> it.value().toString()).toList();
    }

    private void applyEmbeddings(List<FieldData> fieldDataList, List<?> embeddings, Vectorize vectorize) {
        for (int i = 0; i < fieldDataList.size() && i < embeddings.size(); ++i) {
            fieldDataList.get(i).accessor().setPropertyValue(vectorize.destination(), embeddings.get(i));
        }
    }

    private void processSentenceEmbedding(List<FieldData> fieldDataList, Function<Vectorize, EmbeddingModel> modelFunction) {
        fieldDataList.stream().collect(Collectors.groupingBy(FieldData::isDocument)).forEach((isDocument, groupedByIsDocument) -> groupedByIsDocument.stream().collect(Collectors.groupingBy(FieldData::vectorize)).forEach((vectorize, groupedByVectorize) -> {
            List<float[]> embeddings;
            EmbeddingModel model = (EmbeddingModel)modelFunction.apply((Vectorize)vectorize);
            List<Object[]> list = embeddings = isDocument != false ? this.getEmbeddingAsFloatArrayFor(this.mapValues((List<FieldData>)groupedByVectorize), model) : this.getEmbeddingsAsByteArrayFor(this.mapValues((List<FieldData>)groupedByVectorize), model);
            if (embeddings != null) {
                this.applyEmbeddings((List<FieldData>)groupedByVectorize, embeddings, (Vectorize)vectorize);
            }
        }));
    }

    private void processSentenceEmbedding(PropertyAccessor accessor, Vectorize vectorize, Object fieldValue, boolean isDocument, Function<Vectorize, EmbeddingModel> modelFunction) {
        EmbeddingModel model = modelFunction.apply(vectorize);
        if (isDocument) {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingAsFloatArrayFor(fieldValue.toString(), model));
        } else {
            accessor.setPropertyValue(vectorize.destination(), (Object)this.getEmbeddingsAsByteArrayFor(fieldValue.toString(), model));
        }
    }

    private TransformersEmbeddingModel getTransformersEmbeddingModel(Vectorize vectorize) {
        return this.transformersEmbeddingModel;
    }

    private OpenAiEmbeddingModel getOpenAiEmbeddingModel(Vectorize vectorize) {
        if (vectorize.openAiEmbeddingModel() != OpenAiApi.EmbeddingModel.TEXT_EMBEDDING_ADA_002) {
            OpenAiApi openAiApi = new OpenAiApi(this.properties.getOpenAi().getApiKey());
            return new OpenAiEmbeddingModel(openAiApi, MetadataMode.EMBED, OpenAiEmbeddingOptions.builder().model(vectorize.openAiEmbeddingModel().getValue()).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
        }
        return this.defaultOpenAITextVectorizer;
    }

    private OllamaEmbeddingModel getOllamaEmbeddingModel(Vectorize vectorize) {
        if (!vectorize.ollamaEmbeddingModel().id().equals(OllamaModel.MISTRAL.id())) {
            OllamaOptions options = OllamaOptions.builder().model(vectorize.ollamaEmbeddingModel()).truncate(Boolean.valueOf(false)).build();
            return OllamaEmbeddingModel.builder().ollamaApi(this.ollamaApi).defaultOptions(options).build();
        }
        return this.defaultOllamaEmbeddingModel;
    }

    private AzureOpenAiEmbeddingModel getAzureOpenAiEmbeddingModel(Vectorize vectorize) {
        AzureOpenAiEmbeddingOptions options = AzureOpenAiEmbeddingOptions.builder().deploymentName(vectorize.azureOpenAiDeploymentName()).build();
        return new AzureOpenAiEmbeddingModel(this.azureOpenAIClient, MetadataMode.EMBED, options);
    }

    private VertexAiTextEmbeddingModel getVertexAiPaLm2EmbeddingModel(Vectorize vectorize) {
        if (!vectorize.vertexAiPaLm2ApiModel().equals(VertexAiTextEmbeddingOptions.DEFAULT_MODEL_NAME)) {
            VertexAiEmbeddingConnectionDetails connectionDetails = VertexAiEmbeddingConnectionDetails.builder().projectId(this.properties.getVertexAi().getProjectId()).location(this.properties.getVertexAi().getLocation()).build();
            VertexAiTextEmbeddingOptions options = VertexAiTextEmbeddingOptions.builder().model(VertexAiTextEmbeddingOptions.DEFAULT_MODEL_NAME).build();
            return new VertexAiTextEmbeddingModel(connectionDetails, options);
        }
        return this.vertexAiTextEmbeddingModel;
    }

    private BedrockCohereEmbeddingModel getBedrockCohereEmbeddingModel(Vectorize vectorize) {
        if (!vectorize.cohereEmbeddingModel().equals((Object)CohereEmbeddingBedrockApi.CohereEmbeddingModel.COHERE_EMBED_MULTILINGUAL_V3)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.properties.getBedrockCohere().getAccessKey(), (String)this.properties.getBedrockCohere().getSecretKey());
            CohereEmbeddingBedrockApi cohereEmbeddingApi = new CohereEmbeddingBedrockApi(vectorize.cohereEmbeddingModel().id(), (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials), this.properties.getBedrockCohere().getRegion(), ModelOptionsUtils.OBJECT_MAPPER);
            return new BedrockCohereEmbeddingModel(cohereEmbeddingApi);
        }
        return this.bedrockCohereEmbeddingModel;
    }

    private BedrockTitanEmbeddingModel getBedrockTitanEmbeddingModel(Vectorize vectorize) {
        if (!vectorize.titanEmbeddingModel().equals((Object)TitanEmbeddingBedrockApi.TitanEmbeddingModel.TITAN_EMBED_IMAGE_V1)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.properties.getBedrockCohere().getAccessKey(), (String)this.properties.getBedrockCohere().getSecretKey());
            TitanEmbeddingBedrockApi titanEmbeddingApi = new TitanEmbeddingBedrockApi(vectorize.cohereEmbeddingModel().id(), (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials), this.properties.getBedrockTitan().getRegion(), ModelOptionsUtils.OBJECT_MAPPER, Duration.ofMinutes(5L));
            return new BedrockTitanEmbeddingModel(titanEmbeddingApi);
        }
        return this.bedrockTitanEmbeddingModel;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public List<byte[]> getTextEmbeddingsAsBytes(List<String> texts, Field field) {
        if (field.isAnnotationPresent(Vectorize.class)) {
            Vectorize vectorize = field.getAnnotation(Vectorize.class);
            return vectorize.embeddingType() == EmbeddingType.SENTENCE ? this.getSentenceEmbeddingAsBytes(texts, vectorize) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<byte[]> getSentenceEmbeddingAsBytes(List<String> texts, Vectorize vectorize) {
        return switch (vectorize.provider()) {
            default -> throw new IncompatibleClassChangeError();
            case EmbeddingProvider.TRANSFORMERS -> this.getSentenceEmbeddingsAsByteArrayFor(texts);
            case EmbeddingProvider.DJL -> Collections.emptyList();
            case EmbeddingProvider.OPENAI -> {
                OpenAiEmbeddingModel model = this.getOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.OLLAMA -> {
                OllamaEmbeddingModel model = this.getOllamaEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AZURE_OPENAI -> {
                AzureOpenAiEmbeddingModel model = this.getAzureOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.VERTEX_AI -> {
                VertexAiTextEmbeddingModel model = this.getVertexAiPaLm2EmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_COHERE -> {
                BedrockCohereEmbeddingModel model = this.getBedrockCohereEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_TITAN -> {
                BedrockTitanEmbeddingModel model = this.getBedrockTitanEmbeddingModel(vectorize);
                yield this.getEmbeddingsAsByteArrayFor(texts, (EmbeddingModel)model);
            }
        };
    }

    private List<float[]> getSentenceEmbeddingAsFloats(List<String> texts, Vectorize vectorize) {
        return switch (vectorize.provider()) {
            default -> throw new IncompatibleClassChangeError();
            case EmbeddingProvider.TRANSFORMERS -> {
                TransformersEmbeddingModel model = this.getTransformersEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.DJL -> Collections.emptyList();
            case EmbeddingProvider.OPENAI -> {
                OpenAiEmbeddingModel model = this.getOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.OLLAMA -> {
                OllamaEmbeddingModel model = this.getOllamaEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AZURE_OPENAI -> {
                AzureOpenAiEmbeddingModel model = this.getAzureOpenAiEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.VERTEX_AI -> {
                VertexAiTextEmbeddingModel model = this.getVertexAiPaLm2EmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_COHERE -> {
                BedrockCohereEmbeddingModel model = this.getBedrockCohereEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
            case EmbeddingProvider.AMAZON_BEDROCK_TITAN -> {
                BedrockTitanEmbeddingModel model = this.getBedrockTitanEmbeddingModel(vectorize);
                yield this.getEmbeddingAsFloatArrayFor(texts, (EmbeddingModel)model);
            }
        };
    }

    @Override
    public List<float[]> getTextEmbeddingsAsFloats(List<String> texts, Field field) {
        if (field.isAnnotationPresent(Vectorize.class)) {
            Vectorize vectorize = field.getAnnotation(Vectorize.class);
            return vectorize.embeddingType() == EmbeddingType.SENTENCE ? this.getSentenceEmbeddingAsFloats(texts, vectorize) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> getTextEmbeddingsAsBytes(List<String> texts, MetamodelField<?, ?> metamodelField) {
        return this.getTextEmbeddingsAsBytes(texts, metamodelField.getSearchFieldAccessor().getField());
    }

    @Override
    public List<float[]> getTextEmbeddingsAsFloats(List<String> texts, MetamodelField<?, ?> metamodelField) {
        return this.getTextEmbeddingsAsFloats(texts, metamodelField.getSearchFieldAccessor().getField());
    }

    private /* synthetic */ void lambda$processEntity$2(PropertyAccessor accessor, Object item, Field f) {
        Vectorize vectorize = f.getAnnotation(Vectorize.class);
        Object fieldValue = accessor.getPropertyValue(f.getName());
        boolean isDocument = item.getClass().isAnnotationPresent(Document.class);
        if (fieldValue != null) {
            switch (vectorize.embeddingType()) {
                case IMAGE: {
                    this.processImageEmbedding(accessor, vectorize, fieldValue, isDocument);
                    break;
                }
                case WORD: {
                    break;
                }
                case FACE: {
                    this.processFaceEmbedding(accessor, vectorize, fieldValue, isDocument);
                    break;
                }
                case SENTENCE: {
                    this.processSentenceEmbedding(accessor, vectorize, fieldValue, isDocument);
                }
            }
        }
    }
}

