/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.audit.EntityAuditor;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.convert.RedisOMCustomConversions;
import com.redis.om.spring.id.IdentifierFilter;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.vectorize.Embedder;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;

public class RedisEnhancedKeyValueAdapter
extends RedisKeyValueAdapter {
    private final RedisOperations<?, ?> redisOperations;
    private final RedisConverter converter;
    private final RedisModulesOperations<String> modulesOperations;
    private final RediSearchIndexer indexer;
    private final EntityAuditor auditor;
    private final Embedder embedder;
    private final RedisOMProperties redisOMProperties;

    public RedisEnhancedKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, Embedder embedder, RedisOMProperties redisOMProperties) {
        this(redisOps, rmo, new RedisMappingContext(), indexer, embedder, redisOMProperties);
    }

    public RedisEnhancedKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RedisMappingContext mappingContext, RediSearchIndexer indexer, Embedder embedder, RedisOMProperties redisOMProperties) {
        this(redisOps, rmo, mappingContext, (CustomConversions)new RedisOMCustomConversions(), indexer, embedder, redisOMProperties);
    }

    public RedisEnhancedKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RedisMappingContext mappingContext, @Nullable CustomConversions customConversions, RediSearchIndexer indexer, Embedder embedder, RedisOMProperties redisOMProperties) {
        super(redisOps, mappingContext, customConversions);
        Assert.notNull(redisOps, (String)"RedisOperations must not be null!");
        Assert.notNull((Object)mappingContext, (String)"RedisMappingContext must not be null!");
        MappingRedisOMConverter mappingConverter = new MappingRedisOMConverter(mappingContext, (ReferenceResolver)new ReferenceResolverImpl(redisOps));
        mappingConverter.setCustomConversions((CustomConversions)(customConversions == null ? new RedisOMCustomConversions() : customConversions));
        mappingConverter.afterPropertiesSet();
        this.converter = mappingConverter;
        this.redisOperations = redisOps;
        this.modulesOperations = rmo;
        this.indexer = indexer;
        this.auditor = new EntityAuditor(this.redisOperations);
        this.embedder = embedder;
        this.redisOMProperties = redisOMProperties;
    }

    private static String sanitizeKeyspace(String keyspace) {
        return keyspace.endsWith(":") ? keyspace.substring(0, keyspace.length() - 1) : keyspace;
    }

    public Object put(Object id, Object item, String keyspace) {
        RedisData rdo;
        if (item instanceof RedisData) {
            RedisData redisData;
            rdo = redisData = (RedisData)item;
        } else {
            String idAsString = (String)this.converter.getConversionService().convert(id, String.class);
            if (idAsString == null) {
                idAsString = id.toString();
            }
            byte[] redisKey = this.createKey(RedisEnhancedKeyValueAdapter.sanitizeKeyspace(keyspace), idAsString);
            this.auditor.processEntity(redisKey, item);
            this.embedder.processEntity(item);
            rdo = new RedisData();
            this.converter.write(item, (Object)rdo);
        }
        if (rdo.getId() == null) {
            rdo.setId((String)this.converter.getConversionService().convert(id, String.class));
        }
        byte[] objectKey = this.createKey(RedisEnhancedKeyValueAdapter.sanitizeKeyspace(rdo.getKeyspace()), rdo.getId());
        this.redisOperations.execute(connection -> connection.keyCommands().del((byte[][])new byte[][]{objectKey}) == 0L);
        this.redisOperations.executePipelined(connection -> {
            Map rawMap = rdo.getBucket().rawMap();
            connection.hashCommands().hMSet(objectKey, rawMap);
            if (this.willExpire(rdo)) {
                connection.keyCommands().expire(objectKey, rdo.getTimeToLive().longValue());
            }
            return null;
        });
        return item;
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        String stringId = this.asStringValue(id);
        String stringKeyspace = RedisEnhancedKeyValueAdapter.sanitizeKeyspace(this.asStringValue(keyspace));
        byte[] binId = this.createKey(stringKeyspace, stringId);
        Map raw = (Map)this.redisOperations.execute(connection -> connection.hashCommands().hGetAll(binId));
        if (CollectionUtils.isEmpty((Map)raw)) {
            return null;
        }
        RedisData data = new RedisData(raw);
        data.setId(stringId);
        data.setKeyspace(stringKeyspace);
        return (T)this.readTimeToLiveIfSet(binId, this.converter.read(type, (Object)data));
    }

    public void deleteAllOf(String keyspace) {
        Class<?> type = this.indexer.getEntityClassForKeyspace(keyspace);
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        searchOps.dropIndexAndDocuments();
        this.indexer.createIndexFor(type);
    }

    public <T> List<String> getAllIds(String keyspace, Class<T> type) {
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(type);
        String idField = maybeIdField.map(Field::getName).orElse("id");
        Query query = new Query("*");
        query.returnFields(new String[]{idField});
        SearchResult searchResult = searchOps.search(query);
        return searchResult.getDocuments().stream().map(d -> ObjectUtils.documentToObject(d, type, (MappingRedisOMConverter)this.converter)).map(e -> maybeIdField.map(field -> ObjectUtils.getIdFieldForEntity(field, e)).orElse(null)).filter(Objects::nonNull).map(Object::toString).toList();
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type, long offset, int rows) {
        String searchIndex = this.indexer.getIndexName(keyspace);
        SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(searchIndex);
        Query query = new Query("*");
        offset = Math.max(0L, offset);
        int limit = rows;
        if (limit <= 0) {
            limit = this.redisOMProperties.getRepository().getQuery().getLimit();
        }
        query.limit(Integer.valueOf(Math.toIntExact(offset)), Integer.valueOf(limit));
        SearchResult searchResult = searchOps.search(query);
        return searchResult.getDocuments().stream().map(d -> ObjectUtils.documentToObject(d, type, (MappingRedisOMConverter)this.converter)).toList();
    }

    public <T> T delete(Object id, String keyspace, Class<T> type) {
        T o = this.get(id, keyspace, type);
        if (o != null) {
            byte[] keyToDelete = this.createKey(RedisEnhancedKeyValueAdapter.sanitizeKeyspace(this.asStringValue(keyspace)), this.asStringValue(id));
            this.redisOperations.execute(connection -> {
                connection.keyCommands().unlink((byte[][])new byte[][]{keyToDelete});
                return null;
            });
        }
        return o;
    }

    public long count(String keyspace) {
        String indexName = this.indexer.getIndexName(keyspace);
        SearchOperations<String> search = this.modulesOperations.opsForSearch(indexName);
        Query query = new Query("*");
        query.limit(Integer.valueOf(0), Integer.valueOf(0));
        SearchResult result = search.search(query);
        return result.getTotalResults();
    }

    public boolean contains(Object id, String keyspace) {
        Boolean exists = (Boolean)this.redisOperations.execute(connection -> connection.keyCommands().exists(this.toBytes(this.getKey(keyspace, id))));
        return exists != null && exists != false;
    }

    public void update(PartialUpdate<?> update) {
        RedisPersistentEntity entity = (RedisPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(update.getTarget());
        String keyspace = RedisEnhancedKeyValueAdapter.sanitizeKeyspace(entity.getKeySpace());
        Object id = update.getId();
        byte[] redisKey = this.createKey(keyspace, (String)this.converter.getConversionService().convert(id, String.class));
        RedisData rdo = new RedisData();
        this.converter.write(update, (Object)rdo);
        this.redisOperations.execute(connection -> {
            RedisUpdateObject redisUpdateObject = new RedisUpdateObject(redisKey);
            for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                String propertyPath = pUpdate.getPropertyPath();
                if (!PartialUpdate.UpdateCommand.DEL.equals((Object)pUpdate.getCmd()) && !(pUpdate.getValue() instanceof Collection) && !(pUpdate.getValue() instanceof Map) && (pUpdate.getValue() == null || !pUpdate.getValue().getClass().isArray()) && (pUpdate.getValue() == null || this.converter.getConversionService().canConvert(pUpdate.getValue().getClass(), byte[].class))) continue;
                redisUpdateObject = this.fetchDeletePathsFromHash(redisUpdateObject, propertyPath, connection);
            }
            if (!redisUpdateObject.fieldsToRemove.isEmpty()) {
                connection.hashCommands().hDel(redisKey, (byte[][])redisUpdateObject.fieldsToRemove.toArray((T[])new byte[redisUpdateObject.fieldsToRemove.size()][]));
            }
            if (!rdo.getBucket().isEmpty() && (rdo.getBucket().size() > 1 || rdo.getBucket().size() == 1 && !rdo.getBucket().asMap().containsKey("_class"))) {
                connection.hashCommands().hMSet(redisKey, rdo.getBucket().rawMap());
            }
            if (update.isRefreshTtl()) {
                if (this.willExpire(rdo)) {
                    connection.keyCommands().expire(redisKey, rdo.getTimeToLive().longValue());
                } else {
                    connection.keyCommands().persist(redisKey);
                }
            }
            return null;
        });
    }

    private RedisUpdateObject fetchDeletePathsFromHash(RedisUpdateObject redisUpdateObject, String path, RedisConnection connection) {
        redisUpdateObject.addFieldToRemove(this.toBytes(path));
        byte[] value = connection.hashCommands().hGet(redisUpdateObject.targetKey, this.toBytes(path));
        if (value != null && value.length > 0) {
            return redisUpdateObject;
        }
        Set existingFields = connection.hashCommands().hKeys(redisUpdateObject.targetKey);
        for (byte[] field : existingFields) {
            if (!this.asStringValue(field).startsWith(path + ".")) continue;
            redisUpdateObject.addFieldToRemove(field);
            connection.hashCommands().hGet(redisUpdateObject.targetKey, this.toBytes(field));
        }
        return redisUpdateObject;
    }

    private String asStringValue(Object value) {
        if (value instanceof String) {
            String valueAsString = (String)value;
            return valueAsString;
        }
        return (String)this.getConverter().getConversionService().convert(value, String.class);
    }

    @Nullable
    private <T> T readTimeToLiveIfSet(@Nullable byte[] key, @Nullable T target) {
        if (target == null || key == null) {
            return target;
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(target.getClass());
        if (entity.hasExplictTimeToLiveProperty()) {
            RedisPersistentProperty ttlProperty = entity.getExplicitTimeToLiveProperty();
            if (ttlProperty == null) {
                return target;
            }
            TimeToLive ttl = (TimeToLive)ttlProperty.findAnnotation(TimeToLive.class);
            Long timeout = (Long)this.redisOperations.execute(connection -> {
                if (org.springframework.util.ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)ttl.unit()))) {
                    return connection.keyCommands().ttl(key);
                }
                return connection.keyCommands().pTtl(key, ttl.unit());
            });
            if (timeout != null || !ttlProperty.getType().isPrimitive()) {
                PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(target);
                propertyAccessor.setProperty((PersistentProperty)ttlProperty, this.converter.getConversionService().convert((Object)timeout, ttlProperty.getType()));
                target = propertyAccessor.getBean();
            }
        }
        return target;
    }

    private boolean willExpire(RedisData data) {
        return data.getTimeToLive() != null && data.getTimeToLive() > 0L;
    }

    protected String getKey(String keyspace, Object id) {
        String sanitizedKeyspace = RedisEnhancedKeyValueAdapter.sanitizeKeyspace(keyspace);
        return String.format("%s:%s", sanitizedKeyspace, id);
    }

    public byte[] createKey(String keyspace, String id) {
        Optional<IdentifierFilter<?>> maybeIdentifierFilter = this.indexer.getIdentifierFilterFor(keyspace);
        if (maybeIdentifierFilter.isPresent()) {
            IdentifierFilter<?> filter = maybeIdentifierFilter.get();
            id = filter.filter(id);
        }
        return this.toBytes(keyspace + ":" + id);
    }

    static class RedisUpdateObject {
        private final byte[] targetKey;
        private final Set<byte[]> fieldsToRemove = new LinkedHashSet<byte[]>();

        RedisUpdateObject(byte[] targetKey) {
            this.targetKey = targetKey;
        }

        void addFieldToRemove(byte[] field) {
            this.fieldsToRemove.add(field);
        }
    }
}

