/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.autocomplete;

import com.google.gson.Gson;
import com.redis.om.spring.annotations.AutoComplete;
import com.redis.om.spring.annotations.AutoCompletePayload;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.util.ObjectUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.Repository;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoCompleteAspect
implements Ordered {
    private static final Log logger = LogFactory.getLog(AutoCompleteAspect.class);
    final StringRedisTemplate template;
    private final Gson gson;
    private final RedisModulesOperations<String> rmo;

    public AutoCompleteAspect(RedisModulesOperations<String> rmo, Gson gson, StringRedisTemplate template) {
        this.rmo = rmo;
        this.gson = gson;
        this.template = template;
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.save(..))")
    public void inCrudRepositorySave() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.save(..))")
    public void inRedisDocumentRepositorySave() {
    }

    @Pointcut(value="inCrudRepositorySave() || inRedisDocumentRepositorySave()")
    private void inSaveOperation() {
    }

    @AfterReturning(value="inSaveOperation() && args(entity,..)")
    public void addSuggestion(JoinPoint jp, Object entity) {
        this.processSuggestionsForEntity(entity);
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.saveAll(..))")
    public void inCrudRepositorySaveAll() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.saveAll(..))")
    public void inRedisDocumentRepositorySaveAll() {
    }

    @Pointcut(value="inCrudRepositorySaveAll() || inRedisDocumentRepositorySaveAll()")
    private void inSaveAllOperation() {
    }

    @AfterReturning(value="inSaveAllOperation() && args(entities,..)")
    public void addAllSuggestions(JoinPoint jp, List<Object> entities) {
        for (Object entity : entities) {
            this.processSuggestionsForEntity(entity);
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.delete(..))")
    public void inRedisDocumentRepositoryDelete() {
    }

    @AfterReturning(value="inRedisDocumentRepositoryDelete() && args(entity,..)")
    public void deleteSuggestion(JoinPoint jp, Object entity) {
        this.deleteSuggestionsForEntity(entity);
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAll())")
    public void inRedisDocumentRepositoryDeleteAll() {
    }

    @AfterReturning(value="inRedisDocumentRepositoryDeleteAll()")
    public void deleteAllSuggestions(JoinPoint jp) {
        Repository repository = (Repository)jp.getTarget();
        Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(repository.getClass(), Repository.class);
        if (typeArguments != null && typeArguments.length > 0) {
            Class entityClass = typeArguments[0];
            for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entityClass)) {
                if (!field.isAnnotationPresent(AutoComplete.class)) continue;
                String key = String.format("sugg:%s:%s", entityClass.getSimpleName(), field.getName());
                this.template.delete((Object)key);
            }
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAll(..))")
    public void inRedisDocumentRepositoryDeleteAllEntities() {
    }

    @AfterReturning(value="inRedisDocumentRepositoryDeleteAllEntities() && args(entities,..)")
    public void deleteAllSuggestionsFromEntities(JoinPoint jp, List<Object> entities) {
        for (Object entity : entities) {
            for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entity.getClass())) {
                if (!field.isAnnotationPresent(AutoComplete.class)) continue;
                AutoComplete suggestible = field.getAnnotation(AutoComplete.class);
                String key = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)suggestible.name()) ? suggestible.name() : String.format("sugg:%s:%s", entity.getClass().getSimpleName(), field.getName());
                String payLoadKey = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)suggestible.name()) ? suggestible.name() : String.format("sugg:payload:%s:%s", entity.getClass().getSimpleName(), field.getName());
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                    SearchOperations<String> ops = this.rmo.opsForSearch(key);
                    String suggestion = pd.getReadMethod().invoke(entity, new Object[0]).toString();
                    ops.deleteSuggestion(key, suggestion);
                    this.template.opsForHash().delete((Object)payLoadKey, new Object[]{suggestion});
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    logger.error((Object)"Error while deleting suggestions...", (Throwable)e);
                }
            }
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteById(..))")
    public void inRedisDocumentRepositoryDeleteById() {
    }

    @Before(value="inRedisDocumentRepositoryDeleteById() && args(id)")
    public void deleteSuggestionById(JoinPoint jp, Object id) {
        CrudRepository repository = (CrudRepository)jp.getTarget();
        Optional maybeEntity = repository.findById((Object)id.toString());
        if (maybeEntity.isPresent()) {
            Object entity = maybeEntity.get();
            this.deleteSuggestionsForEntity(entity);
        }
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.deleteAllById(..))")
    public void inRedisDocumentRepositoryDeleteAllById() {
    }

    @Before(value="inRedisDocumentRepositoryDeleteAllById() && args(ids,..)")
    public void deleteAllSuggestionByIds(JoinPoint jp, List<Object> ids) {
        CrudRepository repository = (CrudRepository)jp.getTarget();
        for (Object id : ids) {
            Optional maybeEntity = repository.findById((Object)id.toString());
            if (!maybeEntity.isPresent()) continue;
            Object entity = maybeEntity.get();
            this.deleteSuggestionsForEntity(entity);
        }
    }

    public int getOrder() {
        return 1;
    }

    private void processSuggestionsForEntity(Object entity) {
        List<Field> entityClassFields = ObjectUtils.getDeclaredFieldsTransitively(entity.getClass());
        for (Field field : entityClassFields) {
            if (!field.isAnnotationPresent(AutoComplete.class)) continue;
            String suggestion = "";
            Map payload = null;
            AutoComplete suggestible = field.getAnnotation(AutoComplete.class);
            String key = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)suggestible.name()) ? suggestible.name() : String.format("sugg:%s:%s", entity.getClass().getSimpleName(), field.getName());
            SearchOperations<String> ops = this.rmo.opsForSearch(key);
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                suggestion = pd.getReadMethod().invoke(entity, new Object[0]).toString();
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error((Object)"Error while processing suggestions...", (Throwable)e);
            }
            for (Field field2 : entityClassFields) {
                AutoCompletePayload suggestiblePayload;
                boolean inPayload;
                if (!field2.isAnnotationPresent(AutoCompletePayload.class) || !(inPayload = !(suggestiblePayload = field2.getAnnotation(AutoCompletePayload.class)).value().isBlank() && suggestiblePayload.value().equalsIgnoreCase(field.getName()) || Arrays.asList(suggestiblePayload.fields()).contains(field.getName()))) continue;
                try {
                    payload = payload == null ? new HashMap() : payload;
                    PropertyDescriptor pd = new PropertyDescriptor(field2.getName(), entity.getClass());
                    payload.put(field2.getName(), pd.getReadMethod().invoke(entity, new Object[0]));
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    logger.error((Object)"Error while processing suggestions...", (Throwable)e);
                }
            }
            if (payload != null && !payload.isEmpty()) {
                String payLoadKey = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)suggestible.name()) ? suggestible.name() : String.format("sugg:payload:%s:%s", entity.getClass().getSimpleName(), field.getName());
                this.template.opsForHash().put((Object)payLoadKey, (Object)suggestion, (Object)this.gson.toJson((Object)payload));
            }
            ops.addSuggestion(key, suggestion);
        }
    }

    private void deleteSuggestionsForEntity(Object entity) {
        for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entity.getClass())) {
            if (!field.isAnnotationPresent(AutoComplete.class)) continue;
            AutoComplete suggestible = field.getAnnotation(AutoComplete.class);
            String key = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)suggestible.name()) ? suggestible.name() : String.format("sugg:%s:%s", entity.getClass().getSimpleName(), field.getName());
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                SearchOperations<String> ops = this.rmo.opsForSearch(key);
                String suggestion = pd.getReadMethod().invoke(entity, new Object[0]).toString();
                ops.deleteSuggestion(key, suggestion);
                String payLoadKey = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)suggestible.name()) ? suggestible.name() : String.format("sugg:payload:%s:%s", entity.getClass().getSimpleName(), field.getName());
                this.template.opsForHash().delete((Object)payLoadKey, new Object[]{suggestion});
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error((Object)"Error while deleting suggestions...", (Throwable)e);
            }
        }
    }
}

