/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel;

import com.github.f4b6a3.ulid.Ulid;
import com.google.auto.service.AutoService;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Metamodel;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.SchemaFieldType;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.annotations.VectorIndexed;
import com.redis.om.spring.metamodel.IllegalJavaBeanException;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.ObjectGraphFieldSpec;
import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.metamodel.indexed.BooleanField;
import com.redis.om.spring.metamodel.indexed.CollectionField;
import com.redis.om.spring.metamodel.indexed.DateField;
import com.redis.om.spring.metamodel.indexed.GeoField;
import com.redis.om.spring.metamodel.indexed.NumericField;
import com.redis.om.spring.metamodel.indexed.ReferenceField;
import com.redis.om.spring.metamodel.indexed.TagField;
import com.redis.om.spring.metamodel.indexed.TextField;
import com.redis.om.spring.metamodel.indexed.TextTagField;
import com.redis.om.spring.metamodel.indexed.VectorField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedBooleanField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedGeoField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedNumericField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedTagField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedTextField;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.Triple;
import com.redis.om.spring.tuple.Tuples;
import com.redis.om.spring.util.ObjectUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.util.ClassUtils;

@SupportedAnnotationTypes(value={"com.redis.om.spring.annotations.Document", "org.springframework.data.redis.core.RedisHash"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public final class MetamodelGenerator
extends AbstractProcessor {
    static final String GET_PREFIX = "get";
    static final String IS_PREFIX = "is";
    private static final Set<String> DISALLOWED_ACCESS_LEVELS = Stream.of("PROTECTED", "PRIVATE", "NONE").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    private final Map<String, Integer> depthMap = new HashMap<String, Integer>();
    private ProcessingEnvironment processingEnvironment;
    private Messager messager;
    private TypeElement objectTypeElement;

    private static TypeSpec getTypeSpecForMetamodelClass(String genEntityName, List<FieldSpec> interceptors, List<ObjectGraphFieldSpec> fields, List<FieldSpec> nestedFieldsConstants, CodeBlock staticBlock) {
        return TypeSpec.classBuilder((String)genEntityName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(fields.stream().map(ObjectGraphFieldSpec::fieldSpec).toList()).addFields(nestedFieldsConstants).addStaticBlock(staticBlock).addFields(interceptors).build();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.processingEnvironment = env;
        this.processingEnvironment.getElementUtils();
        this.processingEnvironment.getTypeUtils();
        this.messager = this.processingEnvironment.getMessager();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "\ud83c\udf43 Redis OM Spring Entity Metamodel Generator");
        this.objectTypeElement = this.processingEnvironment.getElementUtils().getTypeElement("java.lang.Object");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty() || roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> documentEntities = roundEnv.getElementsAnnotatedWith(Document.class);
        Set<? extends Element> hashEntities = roundEnv.getElementsAnnotatedWith(RedisHash.class);
        Set metamodelCandidates = Stream.of(documentEntities, hashEntities).flatMap(Collection::stream).collect(Collectors.toSet());
        metamodelCandidates.stream().filter(ae -> ae.getKind() == ElementKind.CLASS).forEach(ae -> {
            try {
                this.generateMetaModelClass((Element)ae);
            }
            catch (IOException ioe) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot generate metamodel class for " + ae.getClass().getName() + " because " + ioe.getMessage());
            }
        });
        return true;
    }

    void generateMetaModelClass(Element annotatedElement) throws IOException {
        boolean hasFields;
        String entityName;
        String packageName;
        Pair<Boolean, String> innerClassInfo = ObjectUtils.isInnerClassWithEnclosing(annotatedElement);
        boolean isInnerClass = innerClassInfo.getFirst();
        String enclosingClassName = innerClassInfo.getSecond();
        String qualifiedName = annotatedElement.asType().toString();
        PackageElement packageElement = this.processingEnvironment.getElementUtils().getPackageOf(annotatedElement);
        if (packageElement.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + annotatedElement.getSimpleName() + " has an unnamed package.");
            packageName = "";
            entityName = qualifiedName;
        } else {
            packageName = packageElement.getQualifiedName().toString();
            entityName = isInnerClass ? annotatedElement.getSimpleName().toString() : ObjectUtils.shortName(qualifiedName);
        }
        String genEntityName = entityName + "$";
        String qualifiedGenEntityName = (String)(packageName.isEmpty() ? "" : packageName + ".") + genEntityName;
        TypeName entity = TypeName.get((TypeMirror)annotatedElement.asType());
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Generating Entity Metamodel: " + qualifiedGenEntityName);
        Map<? extends Element, String> enclosedFields = this.getInstanceFields(annotatedElement);
        ArrayList<FieldSpec> interceptors = new ArrayList<FieldSpec>();
        ArrayList<ObjectGraphFieldSpec> fields = new ArrayList<ObjectGraphFieldSpec>();
        ArrayList<CodeBlock> initCodeBlocks = new ArrayList<CodeBlock>();
        ArrayList<FieldSpec> nestedFieldsConstants = new ArrayList<FieldSpec>();
        enclosedFields.forEach((field, getter) -> {
            List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels = this.processFieldMetamodel(entity, entityName, List.of(field));
            this.extractFieldMetamodels(entity, interceptors, fields, initCodeBlocks, fieldMetamodels);
        });
        Pair<FieldSpec, CodeBlock> keyAccessor = this.generateUnboundMetamodelField(entity, "_KEY", "__key", String.class);
        interceptors.add(keyAccessor.getFirst());
        initCodeBlocks.add(keyAccessor.getSecond());
        Pair<FieldSpec, CodeBlock> thisAccessor = this.generateThisMetamodelField(entity);
        interceptors.add(thisAccessor.getFirst());
        initCodeBlocks.add(thisAccessor.getSecond());
        CodeBlock.Builder blockBuilder = CodeBlock.builder();
        boolean bl = hasFields = !fields.isEmpty();
        if (hasFields) {
            blockBuilder.beginControlFlow("try", new Object[0]);
        }
        this.addStatement(entity, fields, initCodeBlocks, blockBuilder);
        if (hasFields) {
            blockBuilder.nextControlFlow("catch($T | $T e)", new Object[]{NoSuchFieldException.class, SecurityException.class});
            blockBuilder.addStatement("System.err.println(e.getMessage())", new Object[0]);
            blockBuilder.endControlFlow();
        }
        CodeBlock staticBlock = blockBuilder.build();
        TypeSpec metaClass = MetamodelGenerator.getTypeSpecForMetamodelClass(genEntityName, interceptors, fields, nestedFieldsConstants, staticBlock);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)metaClass).build();
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedGenEntityName, new Element[0]);
        Writer writer = builderFile.openWriter();
        javaFile.writeTo((Appendable)writer);
        writer.close();
    }

    private void addStatement(TypeName entity, List<ObjectGraphFieldSpec> fields, List<CodeBlock> initCodeBlocks, CodeBlock.Builder blockBuilder) {
        for (ObjectGraphFieldSpec ogfs : fields) {
            StringBuilder sb = new StringBuilder("$T.class");
            for (int i = 0; i < ogfs.chain().size(); ++i) {
                Element element = ogfs.chain().get(i);
                if (i != 0) {
                    sb.append(".getType()");
                }
                String formattedString = String.format("com.redis.om.spring.util.ObjectUtils.getDeclaredFieldTransitively(%s, \"%s\")", sb, element.getSimpleName());
                sb.setLength(0);
                sb.append(formattedString);
            }
            FieldSpec fieldSpec = ogfs.fieldSpec();
            blockBuilder.addStatement("$L = " + sb, new Object[]{fieldSpec.name, entity});
        }
        for (CodeBlock initCodeBlock : initCodeBlocks) {
            blockBuilder.add(initCodeBlock);
        }
    }

    private List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> processFieldMetamodel(TypeName entity, String entityName, List<Element> chain) {
        return this.processFieldMetamodel(entity, entityName, chain, null);
    }

    private List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> processFieldMetamodel(TypeName entity, String entityName, List<Element> chain, String collectionPrefix) {
        String searchSchemaAlias;
        Class targetInterceptor;
        TypeName entityField;
        String chainedFieldName;
        boolean fieldIsIndexed;
        ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodelSpec;
        block58: {
            fieldMetamodelSpec = new ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>>();
            Element field = chain.get(chain.size() - 1);
            Indexed indexed = field.getAnnotation(Indexed.class);
            Searchable searchable = field.getAnnotation(Searchable.class);
            TextIndexed textIndexed = field.getAnnotation(TextIndexed.class);
            TagIndexed tagIndexed = field.getAnnotation(TagIndexed.class);
            NumericIndexed numericIndexed = field.getAnnotation(NumericIndexed.class);
            GeoIndexed geoIndexed = field.getAnnotation(GeoIndexed.class);
            VectorIndexed vectorIndexed = field.getAnnotation(VectorIndexed.class);
            Id id = field.getAnnotation(Id.class);
            Reference reference = field.getAnnotation(Reference.class);
            fieldIsIndexed = searchable != null || indexed != null || textIndexed != null || tagIndexed != null || numericIndexed != null || geoIndexed != null || vectorIndexed != null || id != null;
            chainedFieldName = chain.stream().map(Element::getSimpleName).collect(Collectors.joining("_"));
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing " + chainedFieldName);
            entityField = TypeName.get((TypeMirror)field.asType());
            TypeMirror fieldType = field.asType();
            String fullTypeClassName = fieldType.toString();
            String cls = ObjectUtils.getTargetClassName(fullTypeClassName);
            if (field.asType().getKind().isPrimitive()) {
                Class primitive = ClassUtils.resolvePrimitiveClassName((String)cls);
                if (primitive == null) {
                    return Collections.emptyList();
                }
                Class primitiveWrapper = ClassUtils.resolvePrimitiveIfNecessary((Class)primitive);
                entityField = TypeName.get((Type)primitiveWrapper);
                fullTypeClassName = entityField.toString();
                cls = ObjectUtils.getTargetClassName(fullTypeClassName);
            }
            targetInterceptor = null;
            Class targetCls = null;
            searchSchemaAlias = null;
            if (indexed != null && reference != null) {
                targetInterceptor = ReferenceField.class;
                searchSchemaAlias = indexed.alias();
            } else if (searchable != null || textIndexed != null) {
                targetInterceptor = TextField.class;
                searchSchemaAlias = searchable != null ? searchable.alias() : textIndexed.alias();
            } else if (fieldIsIndexed) {
                block57: {
                    try {
                        targetCls = ClassUtils.forName((String)cls, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could not resolve " + cls + " while checking for nested @Indexed");
                        fieldMetamodelSpec.addAll(this.processNestedIndexableFields(entity, chain));
                    }
                    if (tagIndexed != null) {
                        targetInterceptor = TextTagField.class;
                        searchSchemaAlias = tagIndexed.alias();
                    } else if (numericIndexed != null) {
                        targetInterceptor = NumericField.class;
                        searchSchemaAlias = numericIndexed.alias();
                    } else if (geoIndexed != null) {
                        targetInterceptor = GeoField.class;
                        searchSchemaAlias = geoIndexed.alias();
                    } else if (vectorIndexed != null) {
                        targetInterceptor = VectorField.class;
                        searchSchemaAlias = vectorIndexed.alias();
                    } else if (indexed != null && indexed.schemaFieldType() != SchemaFieldType.AUTODETECT) {
                        searchSchemaAlias = indexed.alias();
                        switch (indexed.schemaFieldType()) {
                            case TAG: {
                                targetInterceptor = TextTagField.class;
                                break;
                            }
                            case NUMERIC: {
                                targetInterceptor = NumericField.class;
                                break;
                            }
                            case GEO: {
                                targetInterceptor = GeoField.class;
                                break;
                            }
                            case VECTOR: {
                                targetInterceptor = VectorField.class;
                                break;
                            }
                        }
                    } else if (indexed != null && targetCls == null && this.isEnum(this.processingEnv, fieldType)) {
                        targetInterceptor = TextTagField.class;
                        searchSchemaAlias = indexed.alias();
                    } else if (targetCls != null) {
                        if (CharSequence.class.isAssignableFrom(targetCls) || targetCls == Ulid.class) {
                            targetInterceptor = TextTagField.class;
                        } else if (Number.class.isAssignableFrom(targetCls)) {
                            targetInterceptor = NumericField.class;
                        } else if (targetCls == LocalDateTime.class || targetCls == LocalDate.class || targetCls == Date.class || targetCls == Instant.class || targetCls == OffsetDateTime.class) {
                            targetInterceptor = DateField.class;
                        } else {
                            if (Set.class.isAssignableFrom(targetCls) || List.class.isAssignableFrom(targetCls)) {
                                String collectionElementName = ObjectUtils.getCollectionTargetClassName(fullTypeClassName);
                                targetInterceptor = TagField.class;
                                try {
                                    ClassUtils.forName((String)collectionElementName, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                                }
                                catch (ClassNotFoundException cnfe) {
                                    Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> collectionFieldMetamodel = null;
                                    try {
                                        collectionFieldMetamodel = this.generateCollectionFieldMetamodel(entity, chain, chainedFieldName, collectionElementName);
                                    }
                                    catch (IOException e) {
                                        this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could create collection field metamodel element for " + collectionElementName);
                                    }
                                    if (collectionFieldMetamodel != null) {
                                        fieldMetamodelSpec.add(collectionFieldMetamodel);
                                        targetInterceptor = null;
                                    }
                                    break block57;
                                }
                            }
                            if (targetCls == Point.class) {
                                targetInterceptor = GeoField.class;
                            } else if (targetCls == Boolean.class) {
                                targetInterceptor = BooleanField.class;
                            }
                        }
                    }
                }
                if (indexed != null) {
                    searchSchemaAlias = indexed.alias();
                }
            } else {
                Metamodel metamodel = field.getAnnotation(Metamodel.class);
                try {
                    targetCls = ClassUtils.forName((String)cls, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                    if (CharSequence.class.isAssignableFrom(targetCls) || targetCls == Ulid.class) {
                        targetInterceptor = NonIndexedTextField.class;
                    } else if (targetCls == Boolean.class) {
                        targetInterceptor = NonIndexedBooleanField.class;
                    } else if (Number.class.isAssignableFrom(targetCls) || targetCls == LocalDateTime.class || targetCls == LocalDate.class || targetCls == Date.class || targetCls == Instant.class || targetCls == OffsetDateTime.class) {
                        targetInterceptor = NonIndexedNumericField.class;
                    } else if (Set.class.isAssignableFrom(targetCls) || List.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = NonIndexedTagField.class;
                    } else if (targetCls == Point.class) {
                        targetInterceptor = NonIndexedGeoField.class;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (metamodel == null) break block58;
                    this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing class " + entityName + ", generating nested class " + cls + " metamodel (@Metamodel)");
                    fieldMetamodelSpec.addAll(this.processNestedIndexableFields(entity, chain));
                }
            }
        }
        if (targetInterceptor != null) {
            fieldMetamodelSpec.add(this.generateFieldMetamodel(entity, chain, chainedFieldName, entityField, targetInterceptor, fieldIsIndexed, collectionPrefix, searchSchemaAlias));
        }
        return fieldMetamodelSpec;
    }

    private Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> generateCollectionFieldMetamodel(TypeName parentEntity, List<Element> chain, String chainedFieldName, String collectionElementName) throws IOException {
        String packageName;
        Element entity1 = chain.get(chain.size() - 1).getEnclosingElement();
        String qualifiedGenEntityName = parentEntity.toString() + "_" + chainedFieldName + "$";
        String genEntityName = qualifiedGenEntityName.substring(qualifiedGenEntityName.lastIndexOf(46) + 1);
        String entityName = collectionElementName;
        ClassName entity = ClassName.bestGuess((String)entityName);
        Map<? extends Element, String> enclosedFields = this.getInstanceFields((TypeName)entity);
        PackageElement packageElement = this.processingEnvironment.getElementUtils().getPackageOf(entity1);
        if (packageElement.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + entity1.getSimpleName() + " has an unnamed package.");
            packageName = "";
        } else {
            packageName = packageElement.getQualifiedName().toString();
        }
        ArrayList<FieldSpec> interceptors = new ArrayList<FieldSpec>();
        ArrayList<ObjectGraphFieldSpec> fields = new ArrayList<ObjectGraphFieldSpec>();
        ArrayList<CodeBlock> initCodeBlocks = new ArrayList<CodeBlock>();
        ArrayList<FieldSpec> nestedFieldsConstants = new ArrayList<FieldSpec>();
        enclosedFields.forEach((arg_0, arg_1) -> this.lambda$generateCollectionFieldMetamodel$3((TypeName)entity, entityName, chainedFieldName, interceptors, fields, initCodeBlocks, arg_0, arg_1));
        CodeBlock.Builder blockBuilder = CodeBlock.builder();
        blockBuilder.beginControlFlow("try", new Object[0]);
        this.addStatement((TypeName)entity, fields, initCodeBlocks, blockBuilder);
        blockBuilder.nextControlFlow("catch($T | $T e)", new Object[]{NoSuchFieldException.class, SecurityException.class});
        blockBuilder.addStatement("System.err.println(e.getMessage())", new Object[0]);
        blockBuilder.endControlFlow();
        TypeSpec metaClass = this.getTypeSpecForFieldMetamodel(genEntityName, interceptors, fields, nestedFieldsConstants, blockBuilder);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)metaClass).build();
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedGenEntityName, new Element[0]);
        Writer writer = builderFile.openWriter();
        javaFile.writeTo((Appendable)writer);
        writer.close();
        ClassName generatedTypeName = ClassName.bestGuess((String)qualifiedGenEntityName);
        return this.generateFieldMetamodel(chain, chainedFieldName, (TypeName)generatedTypeName);
    }

    private void extractFieldMetamodels(TypeName entity, List<FieldSpec> interceptors, List<ObjectGraphFieldSpec> fields, List<CodeBlock> initCodeBlocks, List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels) {
        for (Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> fieldMetamodel : fieldMetamodels) {
            FieldSpec fieldSpec = fieldMetamodel.getSecond();
            fields.add(fieldMetamodel.getFirst());
            interceptors.add(fieldMetamodel.getSecond());
            initCodeBlocks.add(fieldMetamodel.getThird());
            if (!fieldSpec.type.toString().startsWith(VectorField.class.getName())) continue;
            String fieldName = fieldMetamodel.getFirst().fieldSpec().name;
            Pair<FieldSpec, CodeBlock> vectorFieldScore = this.generateUnboundMetamodelField(entity, "_" + fieldSpec.name + "_SCORE", "__" + fieldName + "_score", Double.class);
            interceptors.add(vectorFieldScore.getFirst());
            initCodeBlocks.add(vectorFieldScore.getSecond());
        }
    }

    private TypeSpec getTypeSpecForFieldMetamodel(String genEntityName, List<FieldSpec> interceptors, List<ObjectGraphFieldSpec> fields, List<FieldSpec> nestedFieldsConstants, CodeBlock.Builder blockBuilder) {
        CodeBlock staticBlock = blockBuilder.build();
        return TypeSpec.classBuilder((String)genEntityName).superclass(CollectionField.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SearchFieldAccessor.class, "searchFieldAccessor", new Modifier[0]).addParameter(Boolean.TYPE, "indexed", new Modifier[0]).addStatement("super(searchFieldAccessor, indexed)", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(fields.stream().map(ObjectGraphFieldSpec::fieldSpec).toList()).addFields(nestedFieldsConstants).addStaticBlock(staticBlock).addFields(interceptors).build();
    }

    private List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> processNestedIndexableFields(TypeName entity, List<Element> chain) {
        Element fieldElement = chain.get(chain.size() - 1);
        TypeMirror typeMirror = fieldElement.asType();
        DeclaredType asDeclaredType = (DeclaredType)typeMirror;
        Element entityField = asDeclaredType.asElement();
        Indexed annotation = fieldElement.getAnnotation(Indexed.class);
        if (entity.toString().equals(entityField.toString()) && annotation != null) {
            Integer integer = this.depthMap.get(entity.toString());
            if (integer == null) {
                this.depthMap.put(entity.toString(), 1);
            } else {
                if ((integer = Integer.valueOf(integer + 1)) > annotation.depth()) {
                    return new ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>>();
                }
                this.depthMap.put(entity.toString(), integer);
            }
        }
        ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels = new ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>>();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing constants for " + fieldElement + " of type " + entityField);
        String entityFieldName = fieldElement.toString();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "entityFieldName => " + entityFieldName);
        Map<? extends Element, String> enclosedFields = this.getInstanceFields(entityField);
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Enclosed subfield size() ==> " + enclosedFields.size());
        enclosedFields.forEach((field, getter) -> {
            boolean generateMetamodel;
            boolean fieldIsIndexed = field.getAnnotation(Indexed.class) != null || field.getAnnotation(Searchable.class) != null;
            boolean bl = generateMetamodel = field.getAnnotation(Metamodel.class) != null;
            if (fieldIsIndexed || generateMetamodel) {
                ArrayList<Element> newChain = new ArrayList<Element>(chain);
                newChain.add((Element)field);
                fieldMetamodels.addAll(this.processFieldMetamodel(entity, entityFieldName, newChain));
            }
        });
        return fieldMetamodels;
    }

    private Map<? extends Element, String> getInstanceFields(Element element) {
        if (this.objectTypeElement.equals(element)) {
            return Collections.emptyMap();
        }
        Map getters = element.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).filter(ee -> ee.getEnclosedElements().stream().noneMatch(eee -> eee.getKind() == ElementKind.PARAMETER)).collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity()));
        Set isGetters = getters.values().stream().map(Element::getSimpleName).map(Object::toString).filter(n -> n.startsWith(IS_PREFIX)).map(n -> n.substring(2)).map(ObjectUtils::toLowercaseFirstCharacter).collect(Collectors.toSet());
        Map results = element.getEnclosedElements().stream().filter(ee -> ee.getKind().isField() && !ee.getModifiers().contains((Object)Modifier.STATIC) && !ee.getModifiers().contains((Object)Modifier.FINAL)).collect(Collectors.toMap(Function.identity(), ee -> this.findGetter((Element)ee, getters, isGetters, element.toString(), this.lombokGetterAvailable(element, (Element)ee))));
        Types types = this.processingEnvironment.getTypeUtils();
        List<? extends TypeMirror> superTypes = types.directSupertypes(element.asType());
        superTypes.stream().map(types::asElement).filter(superElement -> superElement.getKind().isClass()).findFirst().ifPresent(superElement -> results.putAll(this.getInstanceFields((Element)superElement)));
        return results;
    }

    private Map<? extends Element, String> getInstanceFields(TypeName entity) {
        Element element = this.getElementFromTypeName(entity);
        return this.getInstanceFields(element);
    }

    private Element getElementFromTypeName(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            return this.getElementFromTypeName((TypeName)parameterizedTypeName.rawType);
        }
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            return this.processingEnvironment.getElementUtils().getTypeElement(className.reflectionName());
        }
        throw new IllegalArgumentException("Unknown type name: " + typeName);
    }

    private boolean lombokGetterAvailable(Element classElement, Element fieldElement) {
        boolean globalEnable = this.isLombokAnnotated(classElement, "Data") || this.isLombokAnnotated(classElement, "Getter");
        boolean localEnable = this.isLombokAnnotated(fieldElement, "Getter");
        boolean disallowedAccessLevel = DISALLOWED_ACCESS_LEVELS.contains(this.getterAccessLevel(fieldElement).orElse("No access level defined"));
        return !disallowedAccessLevel && (globalEnable || localEnable);
    }

    private boolean isLombokAnnotated(Element annotatedElement, String lombokSimpleClassName) {
        try {
            String className = "lombok." + lombokSimpleClassName;
            Class<?> clazz = Class.forName(className);
            return annotatedElement.getAnnotation(clazz) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Optional<String> getterAccessLevel(Element fieldElement) {
        List<? extends AnnotationMirror> mirrors = fieldElement.getAnnotationMirrors();
        Map map = mirrors.stream().filter(am -> "lombok.Getter".equals(am.getAnnotationType().toString())).findFirst().map(AnnotationMirror::getElementValues).orElse(Collections.emptyMap());
        return map.values().stream().map(AnnotationValue::toString).map(v -> v.substring(v.lastIndexOf(46) + 1)).filter(this::isAccessLevel).findFirst();
    }

    private boolean isAccessLevel(String s) {
        Set validAccessLevels = Stream.of("PACKAGE", "NONE", "PRIVATE", "MODULE", "PROTECTED", "PUBLIC").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        return validAccessLevels.contains(s);
    }

    private String findGetter(Element field, Map<String, Element> getters, Set<String> isGetters, String entityName, boolean lombokGetterAvailable) {
        String standardJavaName;
        String fieldName = field.getSimpleName().toString();
        String getterPrefix = isGetters.contains(fieldName) ? IS_PREFIX : GET_PREFIX;
        String standardGetterName = getterPrefix + (standardJavaName = ObjectUtils.javaNameFromExternal(fieldName));
        Element standardGetter = getters.get(standardGetterName);
        if (standardGetter != null || lombokGetterAvailable) {
            return entityName + "::" + standardGetterName;
        }
        String lambdaName = ObjectUtils.toLowercaseFirstCharacter(entityName);
        if (!field.getModifiers().contains((Object)Modifier.PROTECTED) && !field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return lambdaName + " -> " + lambdaName + "." + fieldName;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Class " + entityName + " is not a proper JavaBean because " + field.getSimpleName().toString() + " has no standard getter.");
        return lambdaName + " -> {throw new " + IllegalJavaBeanException.class.getSimpleName() + "(" + entityName + ".class, \"" + fieldName + "\");}";
    }

    private Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> generateFieldMetamodel(TypeName entity, List<Element> chain, String chainFieldName, TypeName entityField, Class<?> interceptorClass, boolean fieldIsIndexed, String collectionPrefix, String searchSchemaAlias) {
        String alias;
        String fieldAccessor = ObjectUtils.staticField(chainFieldName);
        FieldSpec objectField = FieldSpec.builder(Field.class, (String)chainFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        ObjectGraphFieldSpec ogf = new ObjectGraphFieldSpec(objectField, chain);
        ParameterizedTypeName interceptor = ParameterizedTypeName.get((ClassName)ClassName.get(interceptorClass), (TypeName[])new TypeName[]{entity, entityField});
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)fieldAccessor, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)searchSchemaAlias)) {
            alias = searchSchemaAlias;
        } else {
            alias = chain.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining("_"));
            alias = collectionPrefix != null ? collectionPrefix + "_" + alias : alias;
        }
        Object jsonPath = chain.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining("."));
        jsonPath = "$." + (String)(collectionPrefix != null ? collectionPrefix + "." + (String)jsonPath : jsonPath);
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(new $T(\"$L\", \"$L\", $L),$L)", new Object[]{fieldAccessor, interceptor, SearchFieldAccessor.class, alias, jsonPath, chainFieldName, fieldIsIndexed}).build();
        return Tuples.of(ogf, aField, aFieldInit);
    }

    private Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> generateFieldMetamodel(List<Element> chain, String chainFieldName, TypeName interceptor) {
        String fieldAccessor = ObjectUtils.staticField(chainFieldName);
        FieldSpec objectField = FieldSpec.builder(Field.class, (String)chainFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        ObjectGraphFieldSpec ogf = new ObjectGraphFieldSpec(objectField, chain);
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)fieldAccessor, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        String searchSchemaAlias = chain.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining("_"));
        String jsonPath = "$." + chain.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining("."));
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(new $T(\"$L\", \"$L\", $L),$L)", new Object[]{fieldAccessor, interceptor, SearchFieldAccessor.class, searchSchemaAlias, jsonPath, chainFieldName, true}).build();
        return Tuples.of(ogf, aField, aFieldInit);
    }

    private Pair<FieldSpec, CodeBlock> generateUnboundMetamodelField(TypeName entity, String name, String alias, Class<?> type) {
        ParameterizedTypeName interceptor = ParameterizedTypeName.get((ClassName)ClassName.get(MetamodelField.class), (TypeName[])new TypeName[]{entity, TypeName.get(type)});
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(\"$L\", $T.class, $L)", new Object[]{name, interceptor, alias, type, true}).build();
        return Tuples.of(aField, aFieldInit);
    }

    private Pair<FieldSpec, CodeBlock> generateThisMetamodelField(TypeName entity) {
        String name = "_THIS";
        String alias = "__this";
        ParameterizedTypeName interceptor = ParameterizedTypeName.get((ClassName)ClassName.get(MetamodelField.class), (TypeName[])new TypeName[]{entity, entity});
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(\"$L\", $T.class, $L)", new Object[]{name, interceptor, alias, entity, true}).build();
        return Tuples.of(aField, aFieldInit);
    }

    private boolean isEnum(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        Types typeUtils = processingEnv.getTypeUtils();
        Element element = typeUtils.asElement(typeMirror);
        if (element != null) {
            return element.getKind() == ElementKind.ENUM;
        }
        return false;
    }

    private /* synthetic */ void lambda$generateCollectionFieldMetamodel$3(TypeName entity, String entityName, String chainedFieldName, List interceptors, List fields, List initCodeBlocks, Element field, String getter) {
        List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels = this.processFieldMetamodel(entity, entityName, List.of(field), chainedFieldName);
        this.extractFieldMetamodels(entity, interceptors, fields, initCodeBlocks, fieldMetamodels);
    }
}

