/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query.autocomplete;

import com.redis.om.spring.annotations.AutoComplete;
import com.redis.om.spring.autocomplete.Suggestion;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.autocomplete.AutoCompleteOptions;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.ReflectionUtils;

public class AutoCompleteQueryExecutor {
    public static final String AUTOCOMPLETE_PREFIX = "autoComplete";
    private static final Log logger = LogFactory.getLog(AutoCompleteQueryExecutor.class);
    final RepositoryQuery query;
    final RedisModulesOperations<String> modulesOperations;

    public AutoCompleteQueryExecutor(RepositoryQuery query, RedisModulesOperations<String> modulesOperations) {
        this.query = query;
        this.modulesOperations = modulesOperations;
    }

    public Optional<String> getAutoCompleteDictionaryKey() {
        String methodName = this.query.getQueryMethod().getName();
        boolean hasExistByPrefix = methodName.startsWith(AUTOCOMPLETE_PREFIX);
        if (hasExistByPrefix && this.query.getQueryMethod().isCollectionQuery()) {
            String targetProperty = ObjectUtils.firstToLowercase(methodName.substring(AUTOCOMPLETE_PREFIX.length()));
            logger.debug((Object)String.format("Target Property : %s", targetProperty));
            Class entityClass = this.query.getQueryMethod().getEntityInformation().getJavaType();
            try {
                Field field = ReflectionUtils.findField((Class)entityClass, (String)targetProperty);
                if (field == null) {
                    return Optional.empty();
                }
                if (field.isAnnotationPresent(AutoComplete.class)) {
                    AutoComplete bloom = field.getAnnotation(AutoComplete.class);
                    return Optional.of(!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bloom.name()) ? bloom.name() : String.format("sugg:%s:%s", entityClass.getSimpleName(), field.getName()));
                }
            }
            catch (SecurityException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public List<Suggestion> executeAutoCompleteQuery(Object[] parameters, String autoCompleteKey) {
        logger.debug((Object)String.format("Autocomplete Query: key:%s, params:%s", autoCompleteKey, Arrays.toString(parameters)));
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(autoCompleteKey);
        if (parameters.length > 1 && parameters[1].getClass() == AutoCompleteOptions.class) {
            AutoCompleteOptions options = (AutoCompleteOptions)parameters[1];
            return ops.getSuggestion(autoCompleteKey, parameters[0].toString(), options);
        }
        return ops.getSuggestion(autoCompleteKey, parameters[0].toString());
    }
}

