/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.google.gson.Gson;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.indexed.NumericField;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.search.stream.AggregationStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.SearchStreamImpl;
import com.redis.om.spring.search.stream.SummarizeParams;
import com.redis.om.spring.search.stream.WrapperSearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.Tuple;
import com.redis.om.spring.tuple.Tuples;
import com.redis.om.spring.util.ObjectUtils;
import com.redis.om.spring.util.SearchResultRawResponseToObjectConverter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.SortedField;
import redis.clients.jedis.util.SafeEncoder;

public class ReturnFieldsSearchStreamImpl<E, T>
implements SearchStream<T> {
    private static final Log logger = LogFactory.getLog(ReturnFieldsSearchStreamImpl.class);
    private final Gson gson;
    private final MappingRedisOMConverter mappingConverter;
    private final SearchStreamImpl<E> entitySearchStream;
    private final List<MetamodelField<E, ?>> returning;
    private final boolean useNoContent;
    private final boolean isDocument;
    private Stream<T> resolvedStream;
    private Runnable closeHandler;

    public ReturnFieldsSearchStreamImpl(SearchStreamImpl<E> entitySearchStream, List<MetamodelField<E, ?>> returning, MappingRedisOMConverter mappingConverter, Gson gson, boolean isDocument) {
        this.entitySearchStream = entitySearchStream;
        this.returning = returning;
        this.gson = gson;
        this.mappingConverter = mappingConverter;
        this.useNoContent = returning.size() == 1 && returning.get(0).getSearchFieldAccessor() != null && returning.get(0).getSearchFieldAccessor().getField().isAnnotationPresent(Id.class);
        this.isDocument = isDocument;
    }

    @Override
    public Iterator<T> iterator() {
        return this.resolveStream().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.resolveStream().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.resolveStream().isParallel();
    }

    @Override
    public SearchStream<T> sequential() {
        return new WrapperSearchStream((Stream)this.resolveStream().sequential());
    }

    @Override
    public SearchStream<T> parallel() {
        return new WrapperSearchStream((Stream)this.resolveStream().parallel());
    }

    @Override
    public SearchStream<T> unordered() {
        return new WrapperSearchStream((Stream)this.resolveStream().unordered());
    }

    @Override
    public SearchStream<T> onClose(Runnable closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public void close() {
        if (this.closeHandler == null) {
            this.resolveStream().close();
        } else {
            ((Stream)this.resolveStream().onClose(this.closeHandler)).close();
        }
    }

    @Override
    public SearchStream<T> filter(SearchFieldPredicate<? super T, ?> predicate) {
        throw new UnsupportedOperationException("Filter on a field predicate is not supported on mapped stream");
    }

    @Override
    public SearchStream<T> filter(Predicate<?> predicate) {
        return new WrapperSearchStream<T>(this.resolveStream().filter(predicate));
    }

    @Override
    public SearchStream<T> filter(String freeText) {
        throw new UnsupportedOperationException("Filter on free text predicate is not supported on mapped stream");
    }

    @Override
    public SearchStream<T> filter(Example<T> example) {
        throw new UnsupportedOperationException("Filter on Example predicate is not supported on mapped stream");
    }

    @Override
    public <R> SearchStream<R> map(Function<? super T, ? extends R> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).map(mapper);
    }

    @Override
    public Class<T> getEntityClass() {
        return null;
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.resolveStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.resolveStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.resolveStream().mapToDouble(mapper);
    }

    @Override
    public <R> SearchStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return new WrapperSearchStream<T>(this.resolveStream()).flatMapToDouble(mapper);
    }

    @Override
    public SearchStream<T> sorted(Comparator<? super T> comparator) {
        return new WrapperSearchStream<T>(this.resolveStream().sorted(comparator));
    }

    @Override
    public SearchStream<T> sorted(Comparator<? super T> comparator, SortedField.SortOrder order) {
        return this.sorted(comparator);
    }

    @Override
    public SearchStream<T> sorted(Sort sort) {
        throw new UnsupportedOperationException("sorted(Sort) is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public SearchStream<T> peek(Consumer<? super T> action) {
        return new WrapperSearchStream<T>(this.resolveStream().peek(action));
    }

    @Override
    public SearchStream<T> limit(long maxSize) {
        return new WrapperSearchStream<T>(this.resolveStream().limit(maxSize));
    }

    @Override
    public SearchStream<T> skip(long n) {
        return new WrapperSearchStream<T>(this.resolveStream().skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.resolveStream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.resolveStream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.resolveStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.resolveStream().toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.resolveStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.resolveStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.resolveStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.resolveStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.resolveStream().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.resolveStream().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.resolveStream().max(comparator);
    }

    @Override
    public long count() {
        return this.resolveStream().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.resolveStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.resolveStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.resolveStream().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.resolveStream().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.resolveStream().findAny();
    }

    private Stream<T> resolveStream() {
        if (this.resolvedStream == null) {
            Query query = this.entitySearchStream.prepareQuery();
            if (this.useNoContent) {
                query.setNoContent();
                SearchResult searchResult = this.entitySearchStream.getOps().search(query);
                if (!searchResult.getDocuments().isEmpty()) {
                    String keySample = ((Document)searchResult.getDocuments().get(0)).getId();
                    int idBegin = keySample.indexOf(":") + 1;
                    this.resolvedStream = searchResult.getDocuments().stream().map(Document::getId).map((? super T key) -> key.substring(idBegin));
                } else {
                    this.resolvedStream = Stream.empty();
                }
            } else {
                List<T> results;
                boolean returningFullEntity = this.returning.stream().anyMatch((? super T foi) -> foi.getSearchAlias().equalsIgnoreCase("__this"));
                String[] returnFields = !returningFullEntity ? (String[])this.returning.stream().map((? super T foi) -> ObjectUtils.isCollection(foi.getTargetClass()) ? "$." + foi.getSearchAlias() : foi.getSearchAlias()).toArray(String[]::new) : new String[]{};
                boolean resultSetHasNonIndexedFields = this.returning.stream().anyMatch((? super T foi) -> !foi.isIndexed());
                if (resultSetHasNonIndexedFields) {
                    SearchResult searchResult = this.entitySearchStream.getOps().search(query);
                    List<Object> entities = searchResult.getDocuments().stream().map((? super T d) -> {
                        if (this.isDocument) {
                            return this.gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), this.entitySearchStream.getEntityClass());
                        }
                        return ObjectUtils.documentToObject(d, this.entitySearchStream.getEntityClass(), this.mappingConverter);
                    }).toList();
                    results = this.toResultTuple(entities, returnFields);
                } else {
                    query.returnFields(returnFields);
                    results = this.toResultTuple(this.entitySearchStream.getOps().search(query), returnFields);
                }
                this.resolvedStream = results.stream();
            }
        }
        return this.resolvedStream;
    }

    private List<T> toResultTuple(SearchResult searchResult, String[] returnFields) {
        ArrayList results = new ArrayList();
        searchResult.getDocuments().forEach((? super T doc) -> {
            Map<String, Object> props = StreamSupport.stream(doc.getProperties().spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList mappedResults = new ArrayList();
            this.returning.forEach((? super T foi) -> {
                String field = foi.getSearchAlias();
                if (field.equalsIgnoreCase("__this")) {
                    if (this.isDocument) {
                        mappedResults.add(this.gson.fromJson(SafeEncoder.encode((byte[])((byte[])doc.get("$"))), foi.getTargetClass()));
                    } else {
                        mappedResults.add(ObjectUtils.documentToObject(doc, foi.getTargetClass(), this.mappingConverter));
                    }
                } else {
                    Class<?> targetClass = foi.getTargetClass();
                    Object rawValue = props.get(ObjectUtils.isCollection(targetClass) ? "$." + field : field);
                    mappedResults.add(SearchResultRawResponseToObjectConverter.process(rawValue, targetClass, this.gson));
                }
            });
            if (this.returning.size() > 1) {
                results.add(Tuples.ofArray(returnFields, mappedResults.toArray()));
            } else {
                results.add(mappedResults.get(0));
            }
        });
        return results;
    }

    private List<T> toResultTuple(List<E> entities, String[] returnFields) {
        ArrayList results = new ArrayList();
        entities.forEach((? super T entity) -> {
            ArrayList mappedResults = new ArrayList();
            this.returning.forEach((? super T foi) -> mappedResults.add(ObjectUtils.getValueByPath(entity, foi.getJSONPath())));
            if (this.returning.size() > 1) {
                results.add(Tuples.ofArray(returnFields, mappedResults.toArray()));
            } else {
                results.add(mappedResults.get(0));
            }
        });
        return results;
    }

    @Override
    public Stream<Long> map(ToLongFunction<? super T> mapper) {
        return this.resolveStream().mapToLong(mapper).boxed();
    }

    @Override
    public Stream<Map<String, Object>> mapToLabelledMaps() {
        return this.resolveStream().map(Tuple.class::cast).map(Tuple::labelledMap);
    }

    @Override
    @SafeVarargs
    public final <R> AggregationStream<R> groupBy(MetamodelField<T, ?> ... field) {
        throw new UnsupportedOperationException("groupBy is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> AggregationStream<R> apply(String expression, String alias) {
        throw new UnsupportedOperationException("apply is not supported on a ReturnFieldSearchStream");
    }

    @Override
    @SafeVarargs
    public final <R> AggregationStream<R> load(MetamodelField<T, ?> ... fields) {
        throw new UnsupportedOperationException("load is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> AggregationStream<R> loadAll() {
        throw new UnsupportedOperationException("loadAll is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public Optional<T> min(NumericField<T, ?> field) {
        throw new UnsupportedOperationException("min is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public Optional<T> max(NumericField<T, ?> field) {
        throw new UnsupportedOperationException("max is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public SearchStream<T> dialect(int dialect) {
        throw new UnsupportedOperationException("dialect is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> AggregationStream<R> cursor(int i, Duration duration) {
        throw new UnsupportedOperationException("cursor is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public SearchOperations<String> getSearchOperations() {
        throw new UnsupportedOperationException("getSearchOperations is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public Slice<T> getSlice(Pageable pageable) {
        throw new UnsupportedOperationException("getPage is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> SearchStream<T> project(Function<? super T, ? extends R> field) {
        throw new UnsupportedOperationException("project is not supported on a ReturnFieldSearchStream");
    }

    @Override
    @SafeVarargs
    public final <R> SearchStream<T> project(MetamodelField<? super T, ? extends R> ... field) {
        throw new UnsupportedOperationException("project is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public String backingQuery() {
        return this.entitySearchStream.backingQuery();
    }

    @Override
    public <R> SearchStream<T> summarize(Function<? super T, ? extends R> field) {
        throw new UnsupportedOperationException("summarize is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> SearchStream<T> summarize(Function<? super T, ? extends R> field, SummarizeParams params) {
        throw new UnsupportedOperationException("summarize is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> SearchStream<T> highlight(Function<? super T, ? extends R> field) {
        throw new UnsupportedOperationException("highlight is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public <R> SearchStream<T> highlight(Function<? super T, ? extends R> field, Pair<String, String> tags) {
        throw new UnsupportedOperationException("highlight is not supported on a ReturnFieldSearchStream");
    }

    @Override
    public boolean isDocument() {
        return this.isDocument;
    }

    @Override
    public SearchStream<T> findFirstOrElse(Supplier<? extends T> supplier) {
        throw new UnsupportedOperationException("findFirstOrElse is not supported on a ReturnFieldSearchStream");
    }
}

